/*
 * Decompiled with CFR 0.152.
 */
package sanproject.hlm.manager;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Properties;

public class SJhlmWordManager {
    private static final String WORDINFO_PATH = "wordinfo/";
    private static final String EXTERN = ".properties";
    private static final String SEPARATER = "_";
    private static final String DEFAULT_FILE_GUIDANCE = "Guidance";
    private static final String DEFAULT_FILE_MESSAGE = "Message";
    private static final String DEFAULT_FILE_MEASURE = "Measure";
    private static final String DEFAULT_GUIDANCE = "N/A";
    private static final String DEFAULT_MESSAGEID = "22252-007000";
    private static final String DEFAULT_MESSAGE = "No Message";
    private static HashMap<String, String> guidanceDic = null;
    private static HashMap<String, String> messageDic = null;
    private static HashMap<String, String> measureDic = null;
    private static String language = null;

    private static String convert(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        boolean bl = false;
        for (char c : string.toCharArray()) {
            if (c == '$') {
                if (bl) {
                    stringBuffer.append(stringBuffer2.toString());
                    stringBuffer2 = new StringBuffer();
                    bl = false;
                    continue;
                }
                bl = true;
                continue;
            }
            if (bl) {
                stringBuffer2.append(c);
                continue;
            }
            stringBuffer.append(c);
        }
        if (bl) {
            stringBuffer.append('$').append(stringBuffer2.toString());
        }
        return stringBuffer.toString();
    }

    private static HashMap<String, String> convert(HashMap<String, String> hashMap) {
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        for (String string : hashMap.keySet()) {
            String string2 = hashMap.get(string);
            hashMap2.put(string, SJhlmWordManager.convert(string2));
        }
        return hashMap2;
    }

    public static String getGuidance(String string) {
        String string2;
        if (guidanceDic == null) {
            guidanceDic = SJhlmWordManager.convert(SJhlmWordManager.loadProperties(DEFAULT_FILE_GUIDANCE));
        }
        if ((string2 = guidanceDic.get(string)) == null) {
            string2 = DEFAULT_GUIDANCE;
        }
        return string2;
    }

    public static String getMessage(String string) {
        String string2;
        if (messageDic == null) {
            messageDic = SJhlmWordManager.convert(SJhlmWordManager.loadProperties(DEFAULT_FILE_MESSAGE));
        }
        if ((string2 = messageDic.get(string)) == null && (string2 = messageDic.get(DEFAULT_MESSAGEID)) == null) {
            string2 = DEFAULT_MESSAGE;
        }
        return string2;
    }

    public static String getMeasure(String string) {
        String string2;
        if (messageDic == null) {
            messageDic = SJhlmWordManager.convert(SJhlmWordManager.loadProperties(DEFAULT_FILE_MESSAGE));
        }
        if (measureDic == null) {
            measureDic = SJhlmWordManager.convert(SJhlmWordManager.loadProperties(DEFAULT_FILE_MEASURE));
        }
        if ((string2 = measureDic.get(string)) == null && messageDic.get(string) == null) {
            string2 = measureDic.get(DEFAULT_MESSAGEID);
        }
        return string2;
    }

    private static HashMap<String, String> loadProperties(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.putAll(SJhlmWordManager.readWordInfoFile(string));
        if (language != null) {
            hashMap.putAll(SJhlmWordManager.readWordInfoFile(string + SEPARATER + language));
        }
        return hashMap;
    }

    private static HashMap<String, String> readWordInfoFile(String string) {
        Object object;
        String string2 = WORDINFO_PATH + string + EXTERN;
        Properties properties = new Properties();
        try {
            object = SJhlmWordManager.class.getClassLoader().getResourceAsStream(string2);
            try {
                properties.load((InputStream)object);
            }
            finally {
                if (object != null) {
                    ((InputStream)object).close();
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        object = new HashMap();
        for (Object object2 : properties.keySet()) {
            String string3 = (String)object2;
            try {
                String string4 = properties.getProperty(string3);
                ((HashMap)object).put(string3, string4);
            }
            catch (Exception exception) {}
        }
        return object;
    }

    public static void setLang(String string) {
        language = string;
    }
}

