/*
 * Decompiled with CFR 0.152.
 */
package sanproject.hlm.model;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import sanproject.hlm.exception.SJhlmDirectoryLockedException;
import sanproject.hlm.exception.SJhlmException;
import sanproject.hlm.exception.SJhlmJSONParseException;
import sanproject.hlm.factory.SJhlmExceptionFactory;
import sanproject.hlm.model.SJhlmLockedDirectoryModel;
import sanproject.hlm.util.SJhlmJSONConvertUtility;
import sanproject.hlm.util.SJhlmJSONFileIOUtility;
import sanproject.hlm.util.SJhlmLogUtility;

public class SJhlmHistoryModel {
    private static final String CLASSNAME = SJhlmHistoryModel.class.getSimpleName();
    private static final String FILE_NAME = "history.json";
    private static final String KEY_HISTORY = "history";

    public void writeHistory(String string) throws SJhlmException {
        SJhlmLogUtility.putLog(CLASSNAME, "writeHistory()", "Started.");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(KEY_HISTORY, string);
        SJhlmLockedDirectoryModel sJhlmLockedDirectoryModel = null;
        try {
            sJhlmLockedDirectoryModel = new SJhlmLockedDirectoryModel("./config");
            SJhlmJSONFileIOUtility.writeJSONData("./config" + File.separator + FILE_NAME, hashMap);
            sJhlmLockedDirectoryModel.unlock();
            sJhlmLockedDirectoryModel = null;
        }
        catch (SJhlmJSONParseException sJhlmJSONParseException) {
            throw SJhlmExceptionFactory.create(sJhlmJSONParseException);
        }
        catch (IOException iOException) {
            throw SJhlmExceptionFactory.create("22252-007004", iOException);
        }
        catch (SJhlmDirectoryLockedException sJhlmDirectoryLockedException) {
            throw SJhlmExceptionFactory.create("22252-007006", sJhlmDirectoryLockedException);
        }
        finally {
            if (sJhlmLockedDirectoryModel != null) {
                try {
                    sJhlmLockedDirectoryModel.unlock();
                }
                catch (IOException iOException) {
                    throw SJhlmExceptionFactory.create(iOException);
                }
            }
        }
        SJhlmLogUtility.putLog(CLASSNAME, "writeHistory()", "End.");
    }

    public String readHistory() throws SJhlmException {
        SJhlmLogUtility.putLog(CLASSNAME, "readHistory()", "Started.");
        String string = "";
        SJhlmLockedDirectoryModel sJhlmLockedDirectoryModel = null;
        try {
            sJhlmLockedDirectoryModel = new SJhlmLockedDirectoryModel("./config");
            Object object = SJhlmJSONFileIOUtility.readJSONData("./config" + File.separator + FILE_NAME);
            sJhlmLockedDirectoryModel.unlock();
            sJhlmLockedDirectoryModel = null;
            string = this.convertObject(object);
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (sJhlmLockedDirectoryModel != null) {
                try {
                    sJhlmLockedDirectoryModel.unlock();
                }
                catch (IOException iOException) {
                    SJhlmLogUtility.putError(CLASSNAME, "readHistory()", iOException);
                    throw SJhlmExceptionFactory.create();
                }
                sJhlmLockedDirectoryModel = null;
            }
            this.writeHistory(string);
        }
        catch (IOException iOException) {
            throw SJhlmExceptionFactory.create("22252-007005", iOException);
        }
        catch (SJhlmJSONParseException sJhlmJSONParseException) {
            throw SJhlmExceptionFactory.create(sJhlmJSONParseException);
        }
        catch (SJhlmDirectoryLockedException sJhlmDirectoryLockedException) {
            throw SJhlmExceptionFactory.create("22252-007006", sJhlmDirectoryLockedException);
        }
        finally {
            if (sJhlmLockedDirectoryModel != null) {
                try {
                    sJhlmLockedDirectoryModel.unlock();
                }
                catch (IOException iOException) {
                    throw SJhlmExceptionFactory.create(iOException);
                }
            }
        }
        SJhlmLogUtility.putLog(CLASSNAME, "readHistory()", "End.");
        return string;
    }

    public void setHistory(String string) throws SJhlmException {
        SJhlmLogUtility.putLog(CLASSNAME, "addHistory()", "Started(ip=" + string + ").");
        this.writeHistory(string);
        SJhlmLogUtility.putLog(CLASSNAME, "addHistory()", "End.");
    }

    private String convertObject(Object object) throws SJhlmJSONParseException {
        if (!(object instanceof Map)) {
            throw new SJhlmJSONParseException();
        }
        Map<String, Object> map = SJhlmJSONConvertUtility.castMap(object);
        Object object2 = map.get(KEY_HISTORY);
        if (!(object2 instanceof String)) {
            throw new SJhlmJSONParseException();
        }
        String string = (String)object2;
        return string;
    }
}

