/*
 * Decompiled with CFR 0.152.
 */
package sanproject.hlm.model;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import sanproject.hlm.com.SJhlmRunnable;
import sanproject.hlm.data.SJhlmJWSParamData;
import sanproject.hlm.data.SJhlmJarInfoData;
import sanproject.hlm.exception.SJhlmConfirmingException;
import sanproject.hlm.exception.SJhlmException;
import sanproject.hlm.exception.SJhlmGumInvalidSignConfirmException;
import sanproject.hlm.exception.SJhlmSVPInvalidSignConfirmException;
import sanproject.hlm.factory.SJhlmExceptionFactory;
import sanproject.hlm.manager.SJhlmKeyManager;
import sanproject.hlm.manager.SJhlmWhiteListManager;
import sanproject.hlm.model.SJhlmLockedDirectoryModel;
import sanproject.hlm.util.SJhlmDownloadUtility;
import sanproject.hlm.util.SJhlmLogUtility;
import sanproject.hlm.util.SJhlmSignetureUtility;
import sanproject.hlm.util.log.SJhlmCustomLogger;

public class SJhlmJWSModel {
    private static final String CLASSNAME = SJhlmJWSModel.class.getSimpleName();
    private SJhlmJWSParamData param;
    private SJhlmLockedDirectoryModel tmpDir;
    private SJhlmCustomLogger logger;
    private static final String JAVA_EXEC_WIN = ".\\bundle\\jre_win\\bin\\java.exe";
    private static final String JAVA_EXEC_UNIX = "./bundle/jre_unix/bin/java";
    private boolean skipVerify = false;

    public SJhlmJWSModel(SJhlmJWSParamData sJhlmJWSParamData, SJhlmLockedDirectoryModel sJhlmLockedDirectoryModel, SJhlmCustomLogger sJhlmCustomLogger) {
        this.param = sJhlmJWSParamData;
        this.tmpDir = sJhlmLockedDirectoryModel;
        this.logger = sJhlmCustomLogger;
    }

    public void start(SJhlmRunnable sJhlmRunnable) throws SJhlmException, SJhlmConfirmingException {
        SJhlmLogUtility.putLog(CLASSNAME, "start", "Start.");
        this.downloadJars();
        if (!this.skipVerify) {
            this.downloadSigns();
            this.verifySigns();
        }
        List<String> list = this.createCommand();
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        processBuilder.command(list);
        try {
            processBuilder.redirectErrorStream(true);
            Process process = processBuilder.start();
            this.logger.putLog(CLASSNAME, "start", "External Process Start.");
            sJhlmRunnable.run();
            try (InputStream inputStream = process.getInputStream();
                 BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));){
                String string = null;
                while ((string = bufferedReader.readLine()) != null) {
                    this.logger.putLog(CLASSNAME, "console", string);
                }
            }
            catch (IOException iOException) {
                throw SJhlmExceptionFactory.create("22252-007001", iOException);
            }
            int n = process.waitFor();
            if (n != 0) {
                this.logger.putError(CLASSNAME, "start", "External process failed. (return=" + n + ")");
            }
        }
        catch (SJhlmException sJhlmException) {
            throw sJhlmException;
        }
        catch (Exception exception) {
            throw SJhlmExceptionFactory.create("22252-007001", exception);
        }
        SJhlmLogUtility.putLog(CLASSNAME, "start", "End.");
    }

    private void downloadJars() throws SJhlmException {
        for (SJhlmJarInfoData sJhlmJarInfoData : this.param.getJar()) {
            this.downloadJar(sJhlmJarInfoData);
        }
    }

    private void downloadJar(SJhlmJarInfoData sJhlmJarInfoData) throws SJhlmException {
        SJhlmLogUtility.putLog(CLASSNAME, "downloadJar", "Start.");
        String string = sJhlmJarInfoData.getPath();
        String string2 = this.createJarPath(sJhlmJarInfoData);
        SJhlmDownloadUtility.download(string, string2);
        SJhlmLogUtility.putLog(CLASSNAME, "downloadJar", "End.");
    }

    private String createJarPath(SJhlmJarInfoData sJhlmJarInfoData) throws SJhlmException {
        String string = "";
        try {
            string = this.tmpDir.getDir().getCanonicalPath() + File.separator + sJhlmJarInfoData.getFileName();
        }
        catch (IOException iOException) {
            throw SJhlmExceptionFactory.create(iOException);
        }
        return string;
    }

    private void downloadSigns() throws SJhlmException, SJhlmConfirmingException {
        for (SJhlmJarInfoData sJhlmJarInfoData : this.param.getJar()) {
            try {
                this.downloadSign(sJhlmJarInfoData);
            }
            catch (SJhlmException sJhlmException) {
                SJhlmLogUtility.putError(CLASSNAME, "downloadSigns", sJhlmException);
                if (SJhlmWhiteListManager.isListedGum(this.param)) {
                    throw new SJhlmGumInvalidSignConfirmException(this);
                }
                if (SJhlmWhiteListManager.isListedSVP(this.param)) {
                    throw new SJhlmSVPInvalidSignConfirmException(this);
                }
                throw SJhlmExceptionFactory.create("22252-005004", sJhlmException);
            }
        }
    }

    private void downloadSign(SJhlmJarInfoData sJhlmJarInfoData) throws SJhlmException {
        SJhlmLogUtility.putLog(CLASSNAME, "downloadSin", "Start.");
        String string = this.createSignUrl(sJhlmJarInfoData);
        String string2 = this.createSignPath(sJhlmJarInfoData);
        SJhlmDownloadUtility.download(string, string2);
        SJhlmLogUtility.putLog(CLASSNAME, "downloadSin", "End.");
    }

    private String createSignUrl(SJhlmJarInfoData sJhlmJarInfoData) throws SJhlmException {
        String string = "";
        String string2 = sJhlmJarInfoData.getPath().substring(0, sJhlmJarInfoData.getPath().lastIndexOf("/"));
        string = string2 + "/" + sJhlmJarInfoData.getFileName() + ".sig";
        return string;
    }

    private String createSignPath(SJhlmJarInfoData sJhlmJarInfoData) throws SJhlmException {
        String string = "";
        try {
            string = this.tmpDir.getDir().getCanonicalPath() + File.separator + sJhlmJarInfoData.getFileName() + ".sig";
        }
        catch (IOException iOException) {
            throw SJhlmExceptionFactory.create(iOException);
        }
        return string;
    }

    private void verifySigns() throws SJhlmException {
        for (SJhlmJarInfoData sJhlmJarInfoData : this.param.getJar()) {
            this.verifySign(sJhlmJarInfoData);
        }
    }

    private void verifySign(SJhlmJarInfoData sJhlmJarInfoData) throws SJhlmException {
        File file;
        File file2 = new File(this.createJarPath(sJhlmJarInfoData));
        if (!SJhlmSignetureUtility.verifySigneture(file2, file = new File(this.createSignPath(sJhlmJarInfoData)), SJhlmKeyManager.getPublicKey())) {
            throw SJhlmExceptionFactory.create("22252-005006");
        }
    }

    private List<String> createCommand() throws SJhlmException {
        SJhlmLogUtility.putLog(CLASSNAME, "createCommand", "Start.");
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = "java";
        try {
            Object object = null;
            String string2 = System.getProperty("os.name").toLowerCase();
            SJhlmLogUtility.putLog(CLASSNAME, "createCommand", "OS Name=" + string2);
            if (string2.startsWith("windows")) {
                object = new File(JAVA_EXEC_WIN);
                if (((File)object).exists()) {
                    string = ((File)object).getCanonicalPath();
                } else {
                    SJhlmLogUtility.putLog(CLASSNAME, "createCommand", "Bundle JRE is not found(Use Default Java) : " + ((File)object).getCanonicalPath());
                }
            } else if (string2.startsWith("linux")) {
                object = new File(JAVA_EXEC_UNIX);
                if (((File)object).exists()) {
                    string = ((File)object).getCanonicalPath();
                } else {
                    SJhlmLogUtility.putLog(CLASSNAME, "createCommand", "Bundle JRE is not found(Use Default Java) : " + ((File)object).getCanonicalPath());
                }
            }
        }
        catch (IOException iOException) {
            SJhlmLogUtility.putError(CLASSNAME, "createCommand", "Error Occured(Use Default Java)", iOException);
        }
        arrayList.add(string);
        arrayList.add("-cp");
        arrayList.add(this.createClassPath());
        for (String string2 : this.param.getVmArg()) {
            arrayList.add(string2);
        }
        for (String string2 : this.param.getProperties().keySet()) {
            arrayList.add("-D" + string2 + "=" + this.param.getProperties().get(string2));
        }
        arrayList.add(this.param.getMainClass());
        for (String string2 : this.param.getArgs()) {
            arrayList.add(string2);
        }
        SJhlmLogUtility.putLog(CLASSNAME, "createCommand", String.join((CharSequence)" ", arrayList));
        SJhlmLogUtility.putLog(CLASSNAME, "createCommand", "End.");
        return arrayList;
    }

    private String createClassPath() throws SJhlmException {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (SJhlmJarInfoData sJhlmJarInfoData : this.param.getJar()) {
            if (!bl) {
                stringBuffer.append(File.pathSeparator);
            }
            stringBuffer.append(this.createJarPath(sJhlmJarInfoData));
            bl = false;
        }
        return stringBuffer.toString();
    }

    public SJhlmJWSParamData getParam() {
        return this.param;
    }

    public SJhlmJWSModel skipVerify() {
        SJhlmLogUtility.putLog(CLASSNAME, "skipVerify", "Set.");
        this.skipVerify = true;
        return this;
    }
}

