/*
 * Decompiled with CFR 0.152.
 */
package sanproject.hlm.model;

import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import sanproject.hlm.exception.SJhlmDirectoryLockedException;
import sanproject.hlm.exception.SJhlmException;
import sanproject.hlm.factory.SJhlmExceptionFactory;
import sanproject.hlm.util.SJhlmDeleteFileUtility;
import sanproject.hlm.util.SJhlmLogUtility;

public class SJhlmLockedDirectoryModel {
    private static final String CLASSNAME = SJhlmLockedDirectoryModel.class.getSimpleName();
    public static final String LOCK_FILE = ".lock";
    private File dir = null;
    private File lockFile = null;
    private FileChannel fc = null;
    private FileLock fl = null;

    public SJhlmLockedDirectoryModel(String string) throws IOException, SJhlmDirectoryLockedException, SJhlmException {
        String string2 = CLASSNAME;
        SJhlmLogUtility.putLog(CLASSNAME, string2, "Started. (path=" + string + ")");
        this.dir = new File(string);
        if (this.dir.exists() && this.dir.isFile()) {
            throw SJhlmExceptionFactory.create();
        }
        if (!this.dir.exists()) {
            this.dir.mkdirs();
            SJhlmLogUtility.putLog(CLASSNAME, string2, this.dir.getCanonicalPath() + " is created.");
        }
        this.lockFile = new File(string + "/" + LOCK_FILE);
        if (this.lockFile.exists() && this.lockFile.isDirectory()) {
            throw SJhlmExceptionFactory.create();
        }
        if (!this.lockFile.exists()) {
            this.lockFile.createNewFile();
            SJhlmLogUtility.putLog(CLASSNAME, string2, this.lockFile.getCanonicalPath() + " is created.");
        }
        this.fc = FileChannel.open(this.lockFile.toPath(), StandardOpenOption.CREATE, StandardOpenOption.WRITE);
        this.fl = this.fc.tryLock();
        if (this.fl == null) {
            throw new SJhlmDirectoryLockedException();
        }
    }

    public File getDir() {
        return this.dir;
    }

    public void destroy() throws IOException {
        SJhlmLogUtility.putLog(CLASSNAME, "destroy()", "Started. (path=" + this.dir.getAbsolutePath() + ")");
        ArrayList<File> arrayList = new ArrayList<File>();
        arrayList.add(this.lockFile);
        SJhlmDeleteFileUtility.deleteDirContents(this.dir, arrayList);
        this.unlock();
        SJhlmDeleteFileUtility.delete(this.dir);
        SJhlmLogUtility.putLog(CLASSNAME, "destroy()", "unlocked.");
    }

    public void unlock() throws IOException {
        SJhlmLogUtility.putLog(CLASSNAME, "unlock()", "Started. (path=" + this.dir.getAbsolutePath() + ")");
        try {
            this.fl.release();
            this.fc.close();
            this.lockFile.delete();
        }
        catch (IOException iOException) {
            SJhlmLogUtility.putError(CLASSNAME, "unlock()", iOException);
            try {
                this.fl.release();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.fc.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw iOException;
        }
        SJhlmLogUtility.putLog(CLASSNAME, "unlock()", "unlocked.");
    }
}

