/*
 * Decompiled with CFR 0.152.
 */
package sanproject.hlm.util;

import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import javax.net.ssl.SSLHandshakeException;
import sanproject.hlm.exception.SJhlmException;
import sanproject.hlm.factory.SJhlmExceptionFactory;
import sanproject.hlm.util.SJhlmHTTPConnectionUtility;
import sanproject.hlm.util.SJhlmLogUtility;

public class SJhlmDownloadUtility {
    private static final String CLASSNAME = SJhlmDownloadUtility.class.getSimpleName();
    private static final int HANDSHAKE_RETRY_COUNT = 5;

    public static void download(String string, String string2) throws SJhlmException {
        SJhlmLogUtility.putLog(CLASSNAME, "download()", "Start. (url=" + string + ", path=" + string2 + ")");
        HttpURLConnection httpURLConnection = null;
        boolean bl = false;
        int n = 0;
        while (!bl) {
            try {
                httpURLConnection = SJhlmHTTPConnectionUtility.createConnection(string);
                httpURLConnection.setRequestMethod("GET");
                httpURLConnection.connect();
                File file = new File(string2);
                if (!file.exists()) {
                    try {
                        file.createNewFile();
                    }
                    catch (IOException iOException) {
                        throw SJhlmExceptionFactory.create("22252-007003", iOException);
                    }
                }
                try (DataInputStream dataInputStream = new DataInputStream(httpURLConnection.getInputStream());){
                    try (FileOutputStream fileOutputStream = new FileOutputStream(file);
                         BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);){
                        byte[] byArray = new byte[4096];
                        int n2 = 0;
                        while (-1 != (n2 = dataInputStream.read(byArray))) {
                            bufferedOutputStream.write(byArray, 0, n2);
                        }
                    }
                    catch (IOException iOException) {
                        throw SJhlmExceptionFactory.create("22252-007003", iOException);
                    }
                }
                bl = true;
            }
            catch (SSLHandshakeException sSLHandshakeException) {
                sSLHandshakeException.printStackTrace();
                SJhlmLogUtility.putError(CLASSNAME, "download()", "handshakeException:" + ++n, sSLHandshakeException);
                if (n > 5) {
                    throw SJhlmExceptionFactory.create("22252-005003", sSLHandshakeException);
                }
                SJhlmLogUtility.putLog(CLASSNAME, "download()", "handshakeException(Ignored)");
            }
            catch (IOException iOException) {
                throw SJhlmExceptionFactory.create("22252-005002", iOException);
            }
        }
        SJhlmLogUtility.putLog(CLASSNAME, "download()", "Downloaded.");
    }
}

