/*
 * Decompiled with CFR 0.152.
 */
package sanproject.hlm.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import sanproject.hlm.exception.SJhlmException;
import sanproject.hlm.factory.SJhlmExceptionFactory;
import sanproject.hlm.util.SJhlmLogUtility;

public class SJhlmSignetureUtility {
    private static final String CLASSNAME = SJhlmSignetureUtility.class.getSimpleName();

    public static boolean verifySigneture(File file, File file2, PublicKey publicKey) throws SJhlmException {
        Object object;
        SJhlmLogUtility.putLog(CLASSNAME, "verifySigneture", "Started");
        Signature signature = null;
        try {
            signature = Signature.getInstance("SHA256withRSA");
            signature.initVerify(publicKey);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException generalSecurityException) {
            throw SJhlmExceptionFactory.create(generalSecurityException);
        }
        SJhlmLogUtility.putLog(CLASSNAME, "verifySigneture", "Verify start:" + file.getAbsolutePath());
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            int n;
            object = new byte[2048];
            while ((n = ((InputStream)fileInputStream).read((byte[])object)) != -1) {
                signature.update((byte[])object, 0, n);
            }
        }
        catch (IOException iOException) {
            throw SJhlmExceptionFactory.create(iOException);
        }
        catch (SignatureException signatureException) {
            throw SJhlmExceptionFactory.create("22252-005006", signatureException);
        }
        boolean bl = false;
        SJhlmLogUtility.putLog(CLASSNAME, "verifySigneture", "Read Signeture:" + file2.getAbsolutePath());
        try {
            object = Paths.get(file2.toURI());
            byte[] byArray = Files.readAllBytes((Path)object);
            bl = signature.verify(byArray);
        }
        catch (IOException iOException) {
            throw SJhlmExceptionFactory.create(iOException);
        }
        catch (SignatureException signatureException) {
            throw SJhlmExceptionFactory.create("22252-005006", signatureException);
        }
        SJhlmLogUtility.putLog(CLASSNAME, "verifySigneture", "End(ret=" + bl + ")");
        return bl;
    }
}

