/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TreeSet;

public class FileSearch {
    public static final int TYPE_FILE_OR_DIR = 1;
    public static final int TYPE_FILE = 2;
    public static final int TYPE_DIR = 3;
    private TreeSet set = new TreeSet();

    public File[] listFiles(String directoryPath, String fileName) {
        if (fileName != null) {
            fileName = fileName.replace(".", "\\.");
            fileName = fileName.replace("*", ".*");
        }
        return this.listFiles(directoryPath, fileName, 2, true, 0);
    }

    public File[] listFiles(String directoryPath, String fileNamePattern, int type, boolean isRecursive, int period) {
        File dir = new File(directoryPath);
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("\u8811\u5893\u711a\u7e3a\uff67\u8b16\ufffd\u87b3\u58f9\uff06\u7e67\u5f8c\u25c6\u7e5d\u4ee3\u305b[" + dir.getAbsolutePath() + "]\u7e3a\uff6f\u7e5d\ufffd\u7e67\uff63\u7e5d\uff6c\u7e67\uff6f\u7e5d\u533b\u039c\u7e3a\uff67\u7e3a\uff6f\u7e3a\u3085\uff4a\u7e3a\uff7e\u7e3a\u5e19\uff53\u7e32\ufffd");
        }
        File[] files = dir.listFiles();
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            this.addFile(type, fileNamePattern, this.set, file, period);
            if (isRecursive && file.isDirectory()) {
                this.listFiles(file.getAbsolutePath(), fileNamePattern, type, isRecursive, period);
            }
            ++i;
        }
        return this.set.toArray(new File[this.set.size()]);
    }

    private void addFile(int type, String match, TreeSet set, File file, int period) {
        switch (type) {
            case 2: {
                if (file.isFile()) break;
                return;
            }
            case 3: {
                if (file.isDirectory()) break;
                return;
            }
        }
        if (match != null && !file.getName().matches(match)) {
            return;
        }
        if (period != 0) {
            Date lastModifiedDate = new Date(file.lastModified());
            String lastModifiedDateStr = new SimpleDateFormat("yyyyMMdd").format(lastModifiedDate);
            long oneDayTime = 86400000L;
            long periodTime = oneDayTime * (long)Math.abs(period);
            Date designatedDate = new Date(System.currentTimeMillis() - periodTime);
            String designatedDateStr = new SimpleDateFormat("yyyyMMdd").format(designatedDate);
            if (period > 0 ? lastModifiedDateStr.compareTo(designatedDateStr) < 0 : lastModifiedDateStr.compareTo(designatedDateStr) > 0) {
                return;
            }
        }
        set.add(file);
    }

    public void clear() {
        this.set.clear();
    }
}

