/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2msg.model.ctrl;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import sanproject.sn2msg.SN2MsgLogger;
import sanproject.sn2msg.model.SN2MsgMdlException;
import sanproject.sn2msg.model.SN2MsgMdlMacro;
import sanproject.sn2msg.model.data.SN2MsgMdlMsgIdxData;

public class SN2MsgMdlCtrlMsgIdxTbl
implements SN2MsgMdlMacro {
    private Connection m_Conn = null;

    public SN2MsgMdlCtrlMsgIdxTbl(Connection con) {
        this.m_Conn = con;
    }

    public boolean initMsgIdxTbl() {
        boolean bRet = true;
        Statement stmt = null;
        try {
            try {
                stmt = this.m_Conn.createStatement();
                if (this.isTableExist()) {
                    stmt.execute("drop table MSG_IDX");
                    SN2MsgLogger.getLogger().warning("MSG_IDX was initialized.");
                }
                stmt.execute("create table MSG_IDX ( MSG_ID VARCHAR(16) , RESERVED SMALLINT , SUPPORT_REV INTEGER , DISREGARD_OEM SMALLINT , ANNOTATION SMALLINT , PRIMARY KEY (MSG_ID) )");
            }
            catch (Exception jvExp) {
                jvExp.printStackTrace();
                SN2MsgLogger.getLogger().severe(jvExp.getMessage());
                bRet = false;
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception jvExp2) {
                    jvExp2.printStackTrace();
                    SN2MsgLogger.getLogger().warning("Close Statement failed.");
                }
            }
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception jvExp) {
                jvExp.printStackTrace();
                SN2MsgLogger.getLogger().warning("Close Statement failed.");
            }
        }
        return bRet;
    }

    public boolean makeRecord(SN2MsgMdlMsgIdxData msgData) {
        boolean bRet;
        block13: {
            bRet = true;
            Statement stmt = null;
            try {
                try {
                    if (msgData != null && !msgData.getStrMsgId().equals("")) {
                        stmt = this.m_Conn.createStatement();
                        stmt.execute("insert into MSG_IDX ( MSG_ID , RESERVED , SUPPORT_REV , DISREGARD_OEM , ANNOTATION ) values ( '" + msgData.getStrMsgId() + "'" + " ," + msgData.getRsv() + " ," + msgData.getISupportRev() + " ," + msgData.getDisregardOemBit() + " ," + msgData.getAnnotation() + ")");
                        break block13;
                    }
                    SN2MsgLogger.getLogger().warning("Invalid parameter.");
                    bRet = false;
                }
                catch (SQLException sqlExp) {
                    sqlExp.printStackTrace();
                    SN2MsgLogger.getLogger().warning(sqlExp.getSQLState());
                    SN2MsgLogger.getLogger().warning(sqlExp.getMessage());
                    bRet = false;
                    if (stmt == null) break block13;
                    try {
                        stmt.close();
                    }
                    catch (SQLException sqlExp2) {
                        sqlExp2.printStackTrace();
                        SN2MsgLogger.getLogger().warning("Close Statement failed.");
                    }
                }
            }
            finally {
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException sqlExp) {
                        sqlExp.printStackTrace();
                        SN2MsgLogger.getLogger().warning("Close Statement failed.");
                    }
                }
            }
        }
        return bRet;
    }

    String getValueList(ArrayList<SN2MsgMdlMsgIdxData> msgList) {
        StringBuffer strValue = new StringBuffer();
        int iList = 0;
        while (iList < msgList.size()) {
            SN2MsgMdlMsgIdxData msgData = msgList.get(iList);
            if (iList != 0) {
                strValue.append(",");
            }
            strValue.append("(");
            strValue.append(" '" + msgData.getStrMsgId() + "'");
            strValue.append(" ," + msgData.getRsv());
            strValue.append(" ," + msgData.getISupportRev());
            strValue.append(" ," + msgData.getDisregardOemBit());
            strValue.append(" ," + msgData.getAnnotation());
            strValue.append(")");
            ++iList;
        }
        return strValue.toString();
    }

    public void makeRecords(ArrayList<SN2MsgMdlMsgIdxData> msgList) throws SN2MsgMdlException {
        SN2MsgMdlException mdlExp;
        block20: {
            mdlExp = null;
            Statement stmt = null;
            try {
                if (msgList != null) {
                    stmt = this.m_Conn.createStatement();
                    stmt.execute("insert into MSG_IDX ( MSG_ID , RESERVED , SUPPORT_REV , DISREGARD_OEM , ANNOTATION ) values " + this.getValueList(msgList));
                } else {
                    SN2MsgLogger.getLogger().warning("Invalid parameter.");
                    mdlExp = new SN2MsgMdlException("Invalid parameter.");
                }
            }
            catch (SQLException sqlExp) {
                sqlExp.printStackTrace();
                SN2MsgLogger.getLogger().warning(sqlExp.getSQLState());
                SN2MsgLogger.getLogger().warning(sqlExp.getMessage());
                mdlExp = new SN2MsgMdlException("SQLException occured");
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException sqlExp2) {
                        sqlExp2.printStackTrace();
                        SN2MsgLogger.getLogger().warning("Close Statement failed.");
                    }
                }
                break block20;
            }
            catch (Exception jvExp) {
                try {
                    jvExp.printStackTrace();
                    SN2MsgLogger.getLogger().warning(jvExp.toString());
                    mdlExp = new SN2MsgMdlException("Exception occured");
                    break block20;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (SQLException sqlExp) {
                            sqlExp.printStackTrace();
                            SN2MsgLogger.getLogger().warning("Close Statement failed.");
                        }
                    }
                }
            }
            if (stmt == null) break block20;
            try {
                stmt.close();
            }
            catch (SQLException sqlExp) {
                sqlExp.printStackTrace();
                SN2MsgLogger.getLogger().warning("Close Statement failed.");
            }
        }
        if (mdlExp != null) {
            throw mdlExp;
        }
    }

    public boolean isTableExist() {
        boolean bRet = true;
        Statement stmt = null;
        try {
            try {
                stmt = this.m_Conn.createStatement();
                ResultSet results = stmt.executeQuery("select * from MSG_IDX");
                results.close();
            }
            catch (SQLException sqlExp) {
                bRet = false;
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception jvExp) {
                    SN2MsgLogger.getLogger().warning("Close Statement failed.");
                    jvExp.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception jvExp) {
                SN2MsgLogger.getLogger().warning("Close Statement failed.");
                jvExp.printStackTrace();
            }
        }
        return bRet;
    }

    public boolean deleteRecord(String strKey) {
        boolean bRet = true;
        Statement stmt = null;
        try {
            try {
                SN2MsgLogger.getLogger().warning("Delete record:" + strKey);
                stmt = this.m_Conn.createStatement();
                stmt.execute("delete from MSG_IDX where MSG_ID ='" + strKey + "'");
            }
            catch (SQLException sqlExp) {
                sqlExp.printStackTrace();
                SN2MsgLogger.getLogger().warning(sqlExp.getSQLState());
                SN2MsgLogger.getLogger().warning(sqlExp.getMessage());
                bRet = false;
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception jvExp) {
                    jvExp.printStackTrace();
                    SN2MsgLogger.getLogger().warning("Close Statement failed.");
                }
            }
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception jvExp) {
                jvExp.printStackTrace();
                SN2MsgLogger.getLogger().warning("Close Statement failed.");
            }
        }
        return bRet;
    }

    public SN2MsgMdlMsgIdxData getRecord(String strKey) throws SN2MsgMdlException {
        SN2MsgMdlException mdlExp;
        SN2MsgMdlMsgIdxData retData;
        block22: {
            retData = new SN2MsgMdlMsgIdxData();
            Statement stmt = null;
            mdlExp = null;
            boolean iReqRev = false;
            try {
                stmt = this.m_Conn.createStatement();
                ResultSet results = stmt.executeQuery("select * from MSG_IDX where MSG_ID='" + strKey + "'");
                while (results.next()) {
                    String strMsgId = results.getString("MSG_ID");
                    short sRsv = results.getShort("RESERVED");
                    int iRev = results.getInt("SUPPORT_REV");
                    short sDsrOem = results.getShort("DISREGARD_OEM");
                    short sAnnotation = results.getShort("ANNOTATION");
                    retData.setStrMsgId(strMsgId);
                    if (1 == sRsv) {
                        retData.setBRsv(true);
                    } else {
                        retData.setBRsv(false);
                    }
                    retData.setISupportRev(iRev);
                    retData.setBitDisregardOem(sDsrOem);
                    retData.setAnnotation(sAnnotation);
                }
            }
            catch (SQLException sqlExp) {
                sqlExp.printStackTrace();
                SN2MsgLogger.getLogger().warning(sqlExp.getSQLState());
                SN2MsgLogger.getLogger().warning(sqlExp.toString());
                mdlExp = new SN2MsgMdlException();
                mdlExp.setErrCode(1);
                try {
                    if (stmt != null) {
                        stmt.close();
                        stmt = null;
                    }
                    break block22;
                }
                catch (Exception jvExp) {
                    jvExp.printStackTrace();
                    SN2MsgLogger.getLogger().warning(jvExp.toString());
                }
                break block22;
            }
            catch (Exception jvExp) {
                try {
                    jvExp.printStackTrace();
                    SN2MsgLogger.getLogger().warning(jvExp.toString());
                    mdlExp = new SN2MsgMdlException();
                    mdlExp.setErrCode(2);
                    break block22;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        if (stmt != null) {
                            stmt.close();
                            stmt = null;
                        }
                    }
                    catch (Exception jvExp2) {
                        jvExp2.printStackTrace();
                        SN2MsgLogger.getLogger().warning(jvExp2.toString());
                    }
                }
            }
            try {
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
            }
            catch (Exception jvExp) {
                jvExp.printStackTrace();
                SN2MsgLogger.getLogger().warning(jvExp.toString());
            }
        }
        if (mdlExp != null) {
            throw mdlExp;
        }
        return retData;
    }

    public ArrayList<SN2MsgMdlMsgIdxData> getMessageIdList(boolean bRsv, String strRev) throws SN2MsgMdlException {
        SN2MsgMdlException mdlExp;
        ArrayList<SN2MsgMdlMsgIdxData> alRet;
        block24: {
            alRet = new ArrayList<SN2MsgMdlMsgIdxData>();
            Statement stmt = null;
            mdlExp = null;
            int iReqRev = 0;
            try {
                try {
                    iReqRev = Integer.parseInt(strRev, 16);
                }
                catch (Exception prsExp) {
                    SN2MsgLogger.getLogger().warning("Invalid revision:" + strRev);
                    prsExp.printStackTrace();
                }
                stmt = this.m_Conn.createStatement();
                ResultSet results = stmt.executeQuery("select * from MSG_IDX order by MSG_ID asc");
                while (results.next()) {
                    String strKey = results.getString("MSG_ID");
                    short sRsv = results.getShort("RESERVED");
                    int iRev = results.getInt("SUPPORT_REV");
                    short sDsrOem = results.getShort("DISREGARD_OEM");
                    short sAnnotation = results.getShort("ANNOTATION");
                    if (!bRsv && 1 == sRsv || iReqRev != 0 && iRev > iReqRev) continue;
                    SN2MsgMdlMsgIdxData retTmp = new SN2MsgMdlMsgIdxData();
                    retTmp.setStrMsgId(strKey);
                    if (1 == sRsv) {
                        retTmp.setBRsv(true);
                    } else {
                        retTmp.setBRsv(false);
                    }
                    retTmp.setISupportRev(iRev);
                    retTmp.setBitDisregardOem(sDsrOem);
                    retTmp.setAnnotation(sAnnotation);
                    alRet.add(retTmp);
                }
            }
            catch (SQLException sqlExp) {
                sqlExp.printStackTrace();
                SN2MsgLogger.getLogger().warning(sqlExp.getSQLState());
                SN2MsgLogger.getLogger().warning(sqlExp.toString());
                mdlExp = new SN2MsgMdlException();
                mdlExp.setErrCode(1);
                try {
                    if (stmt != null) {
                        stmt.close();
                        stmt = null;
                    }
                    break block24;
                }
                catch (Exception jvExp) {
                    jvExp.printStackTrace();
                    SN2MsgLogger.getLogger().warning(jvExp.toString());
                }
                break block24;
            }
            catch (Exception jvExp) {
                try {
                    jvExp.printStackTrace();
                    SN2MsgLogger.getLogger().warning(jvExp.toString());
                    mdlExp = new SN2MsgMdlException();
                    mdlExp.setErrCode(2);
                    break block24;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        if (stmt != null) {
                            stmt.close();
                            stmt = null;
                        }
                    }
                    catch (Exception jvExp2) {
                        jvExp2.printStackTrace();
                        SN2MsgLogger.getLogger().warning(jvExp2.toString());
                    }
                }
            }
            try {
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
            }
            catch (Exception jvExp) {
                jvExp.printStackTrace();
                SN2MsgLogger.getLogger().warning(jvExp.toString());
            }
        }
        if (mdlExp != null) {
            throw mdlExp;
        }
        return alRet;
    }

    public ArrayList<SN2MsgMdlMsgIdxData> getSpecifiedIdList(String strId) throws SN2MsgMdlException {
        SN2MsgMdlException mdlExp;
        ArrayList<SN2MsgMdlMsgIdxData> alRet;
        block22: {
            alRet = new ArrayList<SN2MsgMdlMsgIdxData>();
            Statement stmt = null;
            mdlExp = null;
            try {
                stmt = this.m_Conn.createStatement();
                ResultSet results = stmt.executeQuery("select * from MSG_IDX where MSG_ID like '" + strId + "'");
                while (results.next()) {
                    String strKey = results.getString("MSG_ID");
                    short sRsv = results.getShort("RESERVED");
                    int iRev = results.getInt("SUPPORT_REV");
                    short sDsrOem = results.getShort("DISREGARD_OEM");
                    short sAnnotation = results.getShort("ANNOTATION");
                    SN2MsgMdlMsgIdxData retTmp = new SN2MsgMdlMsgIdxData();
                    retTmp.setStrMsgId(strKey);
                    if (1 == sRsv) {
                        retTmp.setBRsv(true);
                    } else {
                        retTmp.setBRsv(false);
                    }
                    retTmp.setISupportRev(iRev);
                    retTmp.setBitDisregardOem(sDsrOem);
                    retTmp.setAnnotation(sAnnotation);
                    alRet.add(retTmp);
                }
            }
            catch (SQLException sqlExp) {
                sqlExp.printStackTrace();
                SN2MsgLogger.getLogger().warning(sqlExp.getSQLState());
                SN2MsgLogger.getLogger().warning(sqlExp.toString());
                mdlExp = new SN2MsgMdlException();
                mdlExp.setErrCode(1);
                try {
                    if (stmt != null) {
                        stmt.close();
                        stmt = null;
                    }
                    break block22;
                }
                catch (Exception jvExp) {
                    jvExp.printStackTrace();
                    SN2MsgLogger.getLogger().warning(jvExp.toString());
                }
                break block22;
            }
            catch (Exception jvExp) {
                try {
                    jvExp.printStackTrace();
                    SN2MsgLogger.getLogger().warning(jvExp.toString());
                    mdlExp = new SN2MsgMdlException();
                    mdlExp.setErrCode(2);
                    break block22;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        if (stmt != null) {
                            stmt.close();
                            stmt = null;
                        }
                    }
                    catch (Exception jvExp2) {
                        jvExp2.printStackTrace();
                        SN2MsgLogger.getLogger().warning(jvExp2.toString());
                    }
                }
            }
            try {
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
            }
            catch (Exception jvExp) {
                jvExp.printStackTrace();
                SN2MsgLogger.getLogger().warning(jvExp.toString());
            }
        }
        if (mdlExp != null) {
            throw mdlExp;
        }
        return alRet;
    }
}

