@echo off

REM  RESTAPI backup tool
REM  All Rights Reserved. Copyright (C) 2016, Hitachi, Ltd.

setlocal enabledelayedexpansion

echo [I] %date% %time% Starting backup

:startGetArgs
set KEY=%~1
set VALUE=%~2
if "%KEY%"=="" goto endGetArgs

if "%KEY%"=="/i" (
  set "INSTALL_DIR=%VALUE%"
  shift
  shift
  goto startGetArgs
) else if "%KEY%"=="/dir" (
  set "BACKUP_DIR=%VALUE%"
  shift
  shift
  goto startGetArgs
) else (
  set CHECK_PARAM=TRUE
)

shift
goto startGetArgs
:endGetArgs

if not "%CHECK_PARAM%" == "" goto ERROR_ARGS
if "%INSTALL_DIR%" == "" goto ERROR_ARGS
if "%BACKUP_DIR%" == "" goto ERROR_ARGS

echo INSTALL_DIR=%INSTALL_DIR%
echo BACKUP_DIR=%BACKUP_DIR%

SET STARTUP_V_PROP=%INSTALL_DIR%\data\properties\StartupV.properties
SET KEY_SHAREDDB_DIR=shared.dir

:: Return code of copy/mkdir
SET RC_COPY_FAILED=1
SET RC_COPY_MKDIR_FAILED=2
REM ==================================================
REM check args
REM ==================================================
:: Not installed
if not exist "%INSTALL_DIR%" goto SKIP_END

set SRV_CHK_CMD=%INSTALL_DIR%\status.bat
if not exist "%SRV_CHK_CMD%" goto SKIP_END

SET BK_CNF_DIR=%BACKUP_DIR%\ConfManager
:: Checking backup dir
if exist "%BK_CNF_DIR%" goto ERROR_CNFMNG_DIR_EXIST

:: Checking service
echo -- Service Status --
call "%SRV_CHK_CMD%"
SET RC=%ERRORLEVEL%
echo -- Service Status --
if %RC% NEQ 1 goto ERROR_SERVICE_RUNNING

:: Backup
SET RC=0

CALL :EXEC_MKDIR "%BK_CNF_DIR%"
SET RC=%ERRORLEVEL%
if %RC% NEQ 0 goto DISPATCH_RET_COPY

CALL :EXEC_COPY "D" "cnf"
SET RC=%ERRORLEVEL%
if %RC% NEQ 0 goto DISPATCH_RET_COPY

if exist "%INSTALL_DIR%\data\db" (
    CALL :EXEC_COPY "D" "data\db"
    SET RC=!ERRORLEVEL!
    if !RC! NEQ 0 goto DISPATCH_RET_COPY
) else (
    echo Skipped. "%INSTALL_DIR%\data\db" does not exist. The server may never start so far.
)

CALL :EXEC_COPY "D" "data\properties"
SET RC=%ERRORLEVEL%
if %RC% NEQ 0 goto DISPATCH_RET_COPY

CALL :EXEC_COPY "D" "data\rest"
SET RC=%ERRORLEVEL%
if %RC% NEQ 0 goto DISPATCH_RET_COPY

CALL :EXEC_COPY "D" "data\usercnf"
SET RC=%ERRORLEVEL%
if %RC% NEQ 0 goto DISPATCH_RET_COPY

CALL :EXEC_COPY "D" "oss\apache\conf"
SET RC=%ERRORLEVEL%
if %RC% NEQ 0 goto DISPATCH_RET_COPY

if EXIST "%INSTALL_DIR%\oss\rabbitmq\etc" (
    CALL :EXEC_COPY "D" "oss\rabbitmq\etc"
    SET RC=!ERRORLEVEL!
    if !RC! NEQ 0 goto DISPATCH_RET_COPY
) ELSE (
    echo Skipped. "%INSTALL_DIR%\oss\rabbitmq\etc" does not exist.
)

:: Checking cluster
if not exist "%STARTUP_V_PROP%" goto END
for /F "usebackq tokens=1-2 delims==" %%a in ("%STARTUP_V_PROP%") do (
    IF "%%a" == "%KEY_SHAREDDB_DIR%" (
        set "SHAREDDB_DB=%%b"
    )
)
echo SHAREDDB_DB=%SHAREDDB_DB%
if "%SHAREDDB_DB%" == "" goto END

CALL :EXEC_COPY "DF" "%SHAREDDB_DB%" "%BK_CNF_DIR%\SharedDisk"
if %RC% NEQ 0 goto END

:END
echo [I] %date% %time% Backup completed.
exit /b %RC%

:SKIP_END
echo [W] %date% %time% Not installed. Skipped backup.
exit /b 0

REM ======================== ERROR CASE=========================
:ERROR_ARGS
echo [E] %date% %time% Invalid arguments.
exit /b 254

:ERROR_SERVICE_RUNNING
echo [E] %date% %time% Services are running.
exit /b 1

:ERROR_CNFMNG_DIR_EXIST
echo [E] %date% %time% The name of ConfManager directory exists."%BACKUP_DIR%\ConfManager"
exit /b 2

:ERROR_MKDIR_FAILED
echo [E] %date% %time% Making of the directory failed.
exit /b 3

:ERROR_COPY_FAILED
echo [E] %date% %time% Copying of the file failed.
exit /b 4


REM ======================== FUNCTION ==========================
:EXEC_MKDIR
SET bkdir=%~1
SET RC_COPY=0

if exist "%bkdir%" goto END_MKDIR

echo mkdir "%bkdir%"
mkdir "%bkdir%"
if %ERRORLEVEL% NEQ 0 SET RC_COPY=%RC_COPY_MKDIR_FAILED%

:END_MKDIR
exit /b %RC_COPY%

:: ---------------------------
:: %1: type
::     "D"  : Directory(Specify the relative path from install path.)
::     "DF" : Directory(FullPath)
:: %2: target dir
:: %3: (Option) Specify the backup dir(FullPath) only when type is "DF"
:EXEC_COPY
SET _type=%~1
SET _targetpath=%~2
SET _backuppath=%~3
SET RC_COPY=0

if "%_type%" == "DF" goto FULLPATH_DIR_COPY

:: Type: Directory
SET "_src=%INSTALL_DIR%\%_targetpath%"
SET "_dst=%BK_CNF_DIR%\%_targetpath%"

IF NOT EXIST "%_src%\" goto COPY_SRC_NOT_FOUND

IF NOT EXIST "%_dst%\" (
    call :EXEC_MKDIR "%_dst%"
    if %ERRORLEVEL% NEQ 0 goto COPY_END
)
goto COPY

:FULLPATH_DIR_COPY
:: Type is FullPath Directory

SET "_src=%_targetpath%"
SET "_dst=%_backuppath%"

IF NOT EXIST "%_src%\" goto COPY_SRC_NOT_FOUND

if "%_dst%" == "" (
    SET RC_COPY=%RC_COPY_FAILED%
    echo Internal error. Destination is empty. src="%_src%"
    goto COPY_END
)

if NOT EXIST "%_dst%\" (
    call :EXEC_MKDIR "%_dst%"
    if %ERRORLEVEL% NEQ 0 goto COPY_END
)

:COPY
echo xcopy /S /E /H /R /O /X /Y "%_src%" "%_dst%"
xcopy /S /E /H /R /O /X /Y "%_src%" "%_dst%"
if %ERRORLEVEL% NEQ 0 (
    SET RC_COPY=%RC_COPY_FAILED%
)

:COPY_END
exit /b %RC_COPY%

:COPY_SRC_NOT_FOUND
echo There is not file. "%_src%"
exit /b %RC_COPY_FAILED%

:: ---------------------------
:: %1: ret value of EXEC_COPY
:DISPATCH_RET_COPY
if %RC_COPY% EQU %RC_COPY_MKDIR_FAILED% goto ERROR_MKDIR_FAILED
goto ERROR_COPY_FAILED

:: ---------------------------

