@echo off

REM  RESTAPI checkRMstatus tool
REM  All Rights Reserved. Copyright (C) 2016, Hitachi, Ltd.
REM
REM Document
REM Jetty9.3.5
REM Apache2.4
REM 

SETLOCAL enabledelayedexpansion

set HCS_RM_DEFAULT_VV=01
set HCS_RM_DEFAULT_MM=37
set HCS_RM_DEFAULT_BB=03
set HCS_RM_DEFAULT_RR=04
set HP_RM_DEFAULT_VV=01
set HP_RM_DEFAULT_MM=37
set HP_RM_DEFAULT_BB=04

echo %date% %time% [I] Start checkRMstatus.bat

REM CHECK_RM
set CHECK_RM_RESULT=0

IF "%1" == "/i" (
    set "REST_PATH=%~2"
    set ROOT_DIR=!REST_PATH:~0,2!
) else (
    echo %date% %time% [E] A required option was not specified.
    set CHECK_RM_RESULT=254
    goto END_CHECK_RM
)

IF NOT EXIST "%ROOT_DIR%\HORCM\" (
  IF EXIST "%ROOT_DIR%\HORCM" (
    echo %date% %time% [I] HORCM file exist
    set CHECK_RM_RESULT=5
    goto END_CHECK_RM
  ) else (
    for /F "usebackq tokens=*" %%i in (`fsutil fsinfo drives`) do (
       echo [INFO] %date% %time% Attached Drive= %%i > nul
       for %%d in (%%i) do (
            IF EXIST "%%dHORCM\etc\raidqry.exe" (
                set CHECK_DIR=%%d
                echo %date% %time% [I] File exist:%CHECK_DIR%\HORCM\etc\raidqry.exe
                goto OTHER_DIRECTORY_CHECK
            )
       )
       echo %date% %time% [I] Not exist HORCM folder
       set CHECK_RM_RESULT=0
       goto END_CHECK_RM
    )
  )
) else (
    goto REST_DIRECTORY_CHECK
)

:REST_DIRECTORY_CHECK
IF NOT EXIST "%ROOT_DIR%\HORCM\etc\raidqry.exe" (
  echo %date% %time% [E] File not exist:%ROOT_DIR%\HORCM\etc\raidqry.exe
  set CHECK_RM_RESULT=5
  goto END_CHECK_RM
)
echo %date% %time% [I] File exist:%ROOT_DIR%\HORCM\etc\raidqry.exe

for /F "usebackq tokens=*" %%x in (`%ROOT_DIR%\HORCM\etc\raidqry.exe -h`) do (
  set "LINE=%%x"
  if "!LINE:~0,5!"=="Model" (
    set MODEL_LINE=%%x
  ) else if "!LINE:~0,7!"=="Ver&Rev" (
    set VERSION_LINE=%%x
  )
)
echo %date% %time% [I] !MODEL_LINE!
echo %date% %time% [I] !VERSION_LINE!
call :CHECK_RM_VERSION
set /a exit_code = !errorlevel!
IF !exit_code! == 0 (
  echo %date% %time% [I] RM version check OK
  set CHECK_RM_RESULT=1
) else (
  echo %date% %time% [W] RM version check NG
  set CHECK_RM_RESULT=2
)

:LINK_CHECK
dir %ROOT_DIR%\ /A:D | findstr /I /C:"<SYMLINKD>" | findstr /I /C:"HORCM [%REST_PATH%\HORCM]"  > nul 2>&1
set /a exit_code = !errorlevel!
IF !exit_code! == 0 (
  echo %date% %time% [I] HORCM folder linked to %ROOT_DIR%HORCM
) else (
  set /a CHECK_RM_RESULT = !CHECK_RM_RESULT! + 2
)

goto END_CHECK_RM

:OTHER_DIRECTORY_CHECK
for /F "usebackq tokens=*" %%x in (`%CHECK_DIR%\HORCM\etc\raidqry.exe -h`) do (
  set "LINE=%%x"
  if "!LINE:~0,5!"=="Model" (
    set MODEL_LINE=%%x
  ) else if "!LINE:~0,7!"=="Ver&Rev" (
    set VERSION_LINE=%%x
  )
)
call :CHECK_RM_VERSION
set /a exit_code = !errorlevel!
IF !exit_code! EQU 0 (
  echo %date% %time% [I] RM version of %CHECK_DIR% check OK
  set CHECK_RM_RESULT=3
) else (
  echo %date% %time% [W] RM version of %CHECK_DIR% check NG
  set CHECK_RM_RESULT=4
)

:END_CHECK_RM
echo %date% %time% [I] End checkRMstatus.bat %CHECK_RM_RESULT%
exit /b %CHECK_RM_RESULT%

REM ====================================================================
:CHECK_RM_VERSION
REM check version return code (0:success, 1:false)
set RM_MODEL=HCS
if "!MODEL_LINE:~9,3!"=="XP7" (
  set RM_MODEL=HP
)

set VALUE=!VERSION_LINE:~9,19!
set RM_INSTALLED_VV=!VALUE:~0,2!
set RM_INSTALLED_MM=!VALUE:~3,2!
set RM_INSTALLED_BB=!VALUE:~6,2!
set RM_INSTALLED_RR=!VALUE:~9,2!

if "!RM_MODEL!"=="HCS" (
  if "!RM_INSTALLED_VV!" gtr "!HCS_RM_DEFAULT_VV!" (
    exit /b 0
  ) 
  if "!RM_INSTALLED_VV!" lss "!HCS_RM_DEFAULT_VV!" (
    exit /b 1
  )

  if "!RM_INSTALLED_MM!" gtr "!HCS_RM_DEFAULT_MM!" (
    exit /b 0
  ) 
  if "!RM_INSTALLED_MM!" lss "!HCS_RM_DEFAULT_MM!" (
    exit /b 1
  )

  REM Do not compare BB

  if "!RM_INSTALLED_RR!" gtr "!HCS_RM_DEFAULT_RR!" (
    exit /b 0
  ) 
  if "!RM_INSTALLED_RR!" lss "!HCS_RM_DEFAULT_RR!" (
    exit /b 1
  )

  REM installed version = default version
  exit /b 0
) else (
  if "!RM_INSTALLED_VV!" gtr "!HP_RM_DEFAULT_VV!" (
    exit /b 0
  ) 
  if "!RM_INSTALLED_VV!" lss "!HP_RM_DEFAULT_VV!" (
    exit /b 1
  )

  if "!RM_INSTALLED_MM!" gtr "!HP_RM_DEFAULT_MM!" (
    exit /b 0
  ) 
  if "!RM_INSTALLED_MM!" lss "!HP_RM_DEFAULT_MM!" (
    exit /b 1
  )

  if "!RM_INSTALLED_BB!" gtr "!HP_RM_DEFAULT_BB!" (
    exit /b 0
  ) 
  if "!RM_INSTALLED_BB!" lss "!HP_RM_DEFAULT_BB!" (
    exit /b 1
  )

  REM installed version = default version
  exit /b 0
)
