@echo off

REM  RESTAPI preinstall tool
REM  All Rights Reserved, Copyright (C) 2016, 2018, Hitachi, Ltd.
REM 

setlocal enabledelayedexpansion

cd %~dp0..
%~d0

set INSTALL_VERSION=086200
set "REG_CMD=%SystemRoot%\system32\reg.exe"
set RETRY_MAX_CNT=5
set RETRY_INTERVAL=5

REM ==================================================
REM rotate logs
REM ==================================================
set LOG_MAX=5
set LOG_DIR=%systemdrive%
set LOG_FILE="%LOG_DIR%\confmanager_inst_1.log"

for /L %%i in (5,-1,1) do (
  set LOG_OLD="%LOG_DIR%\confmanager_inst_%%i.log"
  set /a COUNT=%%i+1
  set LOG_NEW="%LOG_DIR%\confmanager_inst_!COUNT!.log"
  if exist !LOG_OLD! (
    rename !LOG_OLD! "confmanager_inst_!COUNT!.log"
  )
)

set /A COUNT=%LOG_MAX%+1
set LOG_LIMIT="%LOG_DIR%\confmanager_inst_%COUNT%.log"
if exist %LOG_LIMIT% (
  del %LOG_LIMIT%
)

REM ==================================================
REM get args
REM ==================================================
echo ----- >> %LOG_FILE% 2>&1
echo # Start Program >> %LOG_FILE% 2>&1
echo ----- >> %LOG_FILE% 2>&1
echo [INFO] %date% %time% -------- Beginning preinstall.bat information. ---------- >> %LOG_FILE% 2>&1

echo [INFO] %date% %time% %0 %* >> %LOG_FILE% 2>&1

:startGetArgs
set KEY=%~1
set VALUE=%~2
if "!KEY!"=="" goto endGetArgs

if "!KEY!"=="/i" (
  set "INSTALL_DIR=!VALUE!"
  shift
  shift
  goto startGetArgs
)

if "!KEY!"=="/m" (
  if "%VALUE%"=="standalone" (
    set INSTALL_MODE=!VALUE!
  )
  if "%VALUE%"=="active" (
    set INSTALL_MODE=!VALUE!
  )
  if "%VALUE%"=="standby" (
    set INSTALL_MODE=!VALUE!
  )
  shift
  shift
  goto startGetArgs
)

if "!KEY!"=="/s" (
  set "SHAREDDISK_DIR=!VALUE!"
  shift
  shift
  goto startGetArgs
)

shift
goto startGetArgs
:endGetArgs

REM ==================================================
REM check args
REM ==================================================
echo [INFO] %date% %time% INSTALL_DIR="%INSTALL_DIR%"  >> %LOG_FILE% 2>&1
echo [INFO] %date% %time% INSTALL_MODE="%INSTALL_MODE%"  >> %LOG_FILE% 2>&1
echo [INFO] %date% %time% SHAREDDISK_DIR="%SHAREDDISK_DIR%"  >> %LOG_FILE% 2>&1

if "%INSTALL_DIR%"=="" (
  echo [ERROR] %date% %time% INSTALL_DIR^(/i^) is not input. >> %LOG_FILE% 2>&1
  exit /B 254
) 
if "%INSTALL_MODE%"=="" (
  echo [ERROR]%date% %time% INSTALL_MODE^(/m^) is not input. >> %LOG_FILE% 2>&1
  exit /B 254
) else if not "%INSTALL_MODE%"=="standalone" (
  if "%SHAREDDISK_DIR%"=="" (
    echo [INFO] %date% %time% INSTALL_MODE=%INSTALL_MODE% >> %LOG_FILE% 2>&1
    echo [ERROR] %date% %time% SHAREDDISK_DIR^(/s^) is not input. >> %LOG_FILE% 2>&1
    exit /B 254
  ) 
)

REM ==================================================
REM main
REM ==================================================

set INSTALL=NEW

%REG_CMD% query "HKLM\SOFTWARE\Hitachi\Configuration Manager REST API" >> %LOG_FILE% 2>&1
set /a exit_code = %errorlevel%
if %exit_code% EQU 0 (
  set INSTALL=UPGRADE
  goto END_CHECK_INSTALL_TYPE
) 

set "JETTY_SERVICE_NAME=ConfManagerAPIServer"
set JETTY_INSTALLED=FALSE
echo [INFO] %date% %time% sc query %JETTY_SERVICE_NAME%  >> %LOG_FILE% 2>&1
sc query %JETTY_SERVICE_NAME%  >> %LOG_FILE% 2>&1
set /a exit_code = !errorlevel!
if %exit_code% == 1060 (
  echo [INFO] %date% %time% %JETTY_SERVICE_NAME% service does not exist.  >> %LOG_FILE% 2>&1
) else (
  echo [INFO] %date% %time% %JETTY_SERVICE_NAME% service exist.  >> %LOG_FILE% 2>&1
  set JETTY_INSTALLED=TRUE
)

set "APACHE_SERVICE_NAME=ConfManagerWebServer"
set APACHE_INSTALLED=FALSE
echo [INFO] %date% %time% sc query %APACHE_SERVICE_NAME%  >> %LOG_FILE% 2>&1
sc query %APACHE_SERVICE_NAME%  >> %LOG_FILE% 2>&1
set /a exit_code = !errorlevel!
echo [INFO] %date% %time% exit code = %exit_code%  >> %LOG_FILE% 2>&1
if %exit_code% == 1060 (
  echo [INFO] %date% %time% %APACHE_SERVICE_NAME% service does not exist.  >> %LOG_FILE% 2>&1
) else (
  echo [INFO] %date% %time% %APACHE_SERVICE_NAME% service exist.  >> %LOG_FILE% 2>&1
  set APACHE_INSTALLED=TRUE
)

if "%JETTY_INSTALLED%"=="TRUE" (
  if "%APACHE_INSTALLED%"=="TRUE" (
    set INSTALL=UPGRADE
  )
)

:END_CHECK_INSTALL_TYPE

echo [INFO] %date% %time% INSTALL_VERSION=%INSTALL_VERSION%  >> %LOG_FILE% 2>&1

if "%INSTALL%"=="NEW" (
  REM ==================================================
  REM new
  REM ==================================================
  echo [INFO] %date% %time% InstallMode= new  >> %LOG_FILE% 2>&1
) else (
  REM ==================================================
  REM upgrade
  REM ==================================================
  echo [INFO] %date% %time% InstallMode= upgrade  >> %LOG_FILE% 2>&1

  REM check version
  if NOT exist "%INSTALL_DIR%\stop.bat" (
    echo [ERROR] %date% %time% File not found: "%INSTALL_DIR%\stop.bat"  >> %LOG_FILE% 2>&1
    echo [ERROR] %date% %time% Environment issue. Services are registered, but file does not exist.  >> %LOG_FILE% 2>&1
    exit /B 1
  ) else (
    if exist "%INSTALL_DIR%\installinfo" (
      for /f "usebackq tokens=1,* delims==" %%a in ("%INSTALL_DIR%\installinfo") do (
        set KEY=%%a
        set VALUE=%%b
        if "!KEY!"=="version" (
          set INSTALL_VERSION_MAJER=!INSTALL_VERSION:~0,4!
          set INSTALLED_VERSION=!VALUE!
          set INSTALLED_VERSION_MAJER=!INSTALLED_VERSION:~0,4!
          IF "!INSTALLED_VERSION_MAJER!" gtr "!INSTALL_VERSION_MAJER!" (
            echo [ERROR] %date% %time% Cannot downgrade the Configuration Manager because a more recent version of Configuration Manager is installed.^(installed=!INSTALLED_VERSION!, install=%INSTALL_VERSION%^)  >> %LOG_FILE% 2>&1
            exit /B 101
          )
          IF "!INSTALLED_VERSION_MAJER!"=="!INSTALL_VERSION_MAJER!" SET INSTALL_TYPE=OVW
          IF "!INSTALLED_VERSION_MAJER!" lss "!INSTALL_VERSION_MAJER!" SET INSTALL_TYPE=VUP
        )
      )

      echo ------installed installinfo------- >> %LOG_FILE% 2>&1
      type "%INSTALL_DIR%\installinfo" >> %LOG_FILE% 2>&1
      echo ------installed installinfo------- >> %LOG_FILE% 2>&1
    )
  )

  echo [INFO] %date% %time% upgrade install type = !INSTALL_TYPE! >> %LOG_FILE% 2>&1

  REM Stop services
  call "%INSTALL_DIR%\stop.bat"  >> %LOG_FILE% 2>&1
  set RC=!ERRORLEVEL!
  if "0" == "!RC!" (
    echo [INFO] %date% %time% Succeeded in the stop of REST API service.  >> %LOG_FILE% 2>&1
  ) else (
    echo [ERROR] %date% %time% Failed in the stop of REST API service.^(rc=!RC!^)  >> %LOG_FILE% 2>&1
    exit /b 100
  )
  if exist "%INSTALL_DIR%\sbin\rmruncheck.bat" (
    call "%INSTALL_DIR%\sbin\rmruncheck.bat"  >> %LOG_FILE% 2>&1
    set RC=!ERRORLEVEL!
    if "1" == "!RC!" (
      echo [ERROR] %date% %time% HORCM process is running. exit code=103  >> %LOG_FILE% 2>&1
      exit /b 103
    )
  )

  REM store user definition files
  if EXIST "%INSTALL_DIR%\tempdir" (
    if NOT EXIST "%INSTALL_DIR%\tempdir\LOCKED" (
      echo [INFO] %date% %time% rd /s /q "%INSTALL_DIR%\tempdir" >> %LOG_FILE% 2>&1
      rd /s /q "%INSTALL_DIR%\tempdir" >> %LOG_FILE% 2>&1
      IF EXIST "%INSTALL_DIR%\tempdir" (
        echo [WARNING] %date% %time% The "%INSTALL_DIR%\tempdir" cannot be deleted. >> %LOG_FILE% 2>&1
      )
    ) else (
      echo [INFO] %date% %time% Lock file exists. tempdir was not deleted. file="%INSTALL_DIR%\tempdir\LOCKED" >> %LOG_FILE% 2>&1
    )
  )

  if NOT EXIST "%INSTALL_DIR%\tempdir\LOCKED" (
    echo [INFO] %date% %time% mkdir "%INSTALL_DIR%\tempdir\cnf" >> %LOG_FILE% 2>&1
    mkdir "%INSTALL_DIR%\tempdir\cnf"
    echo [INFO] %date% %time% xcopy /D /S /R /Y /I /K /Q "%INSTALL_DIR%\cnf" "%INSTALL_DIR%\tempdir\cnf" >> %LOG_FILE% 2>&1
    xcopy /D /S /R /Y /I /K /Q "%INSTALL_DIR%\cnf" "%INSTALL_DIR%\tempdir\cnf" >> %LOG_FILE% 2>&1
    set /a exit_code = !errorlevel!
    echo [INFO] %date% %time% exit code = !exit_code! >> %LOG_FILE% 2>&1
    IF NOT !exit_code! == 0 (
        echo [ERROR] %date% %time% The user definition files cannot be stored. >> %LOG_FILE% 2>&1
        exit /b 102
    )

    echo [INFO] %date% %time% mkdir "%INSTALL_DIR%\tempdir\data\usercnf" >> %LOG_FILE% 2>&1
    mkdir "%INSTALL_DIR%\tempdir\data\usercnf"
    echo [INFO] %date% %time% xcopy /D /S /R /Y /I /K /Q "%INSTALL_DIR%\data\usercnf" "%INSTALL_DIR%\tempdir\data\usercnf" >> %LOG_FILE% 2>&1
    xcopy /D /S /R /Y /I /K /Q "%INSTALL_DIR%\data\usercnf" "%INSTALL_DIR%\tempdir\data\usercnf" >> %LOG_FILE% 2>&1
    set /a exit_code = !errorlevel!
    echo [INFO] %date% %time% exit code = !exit_code! >> %LOG_FILE% 2>&1
    IF NOT !exit_code! == 0 (
        echo [ERROR] %date% %time% The user definition files cannot be stored. >> %LOG_FILE% 2>&1
        exit /b 102
    )

    echo [INFO] %date% %time% mkdir "%INSTALL_DIR%\tempdir\oss\apache\conf\userextra" >> %LOG_FILE% 2>&1
    mkdir "%INSTALL_DIR%\tempdir\oss\apache\conf\userextra"
    echo [INFO] %date% %time% xcopy /D /S /R /Y /I /K /Q "%INSTALL_DIR%\oss\apache\conf\userextra" "%INSTALL_DIR%\tempdir\oss\apache\conf\userextra" >> %LOG_FILE% 2>&1
    xcopy /D /S /R /Y /I /K /Q "%INSTALL_DIR%\oss\apache\conf\userextra" "%INSTALL_DIR%\tempdir\oss\apache\conf\userextra" >> %LOG_FILE% 2>&1
    set /a exit_code = !errorlevel!
    echo [INFO] %date% %time% exit code = !exit_code! >> %LOG_FILE% 2>&1
    IF NOT !exit_code! == 0 (
      echo [ERROR] %date% %time% The user definition files cannot be stored. >> %LOG_FILE% 2>&1
      exit /b 102
    )

    echo [INFO] %date% %time% mkdir "%INSTALL_DIR%\tempdir\oss\rabbitmq\etc" >> %LOG_FILE% 2>&1
    mkdir "%INSTALL_DIR%\tempdir\oss\rabbitmq\etc"
    IF EXIST "%INSTALL_DIR%\oss\rabbitmq\etc" (
        echo [INFO] %date% %time% xcopy /D /S /R /Y /I /K /Q "%INSTALL_DIR%\oss\rabbitmq\etc" "%INSTALL_DIR%\tempdir\oss\rabbitmq\etc" >> %LOG_FILE% 2>&1
        xcopy /D /S /R /Y /I /K /Q "%INSTALL_DIR%\oss\rabbitmq\etc" "%INSTALL_DIR%\tempdir\oss\rabbitmq\etc" >> %LOG_FILE% 2>&1
        set /a exit_code = !errorlevel!
        echo [INFO] %date% %time% exit code = !exit_code! >> %LOG_FILE% 2>&1
        IF NOT !exit_code! == 0 (
            echo [ERROR] %date% %time% The user definition files cannot be stored. >> %LOG_FILE% 2>&1
            exit /b 102
        )
    ) ELSE (
        echo [INFO] %date% %time% The file does not exist Skipped the copying of file. file="%INSTALL_DIR%\oss\rabbitmq\etc" >> %LOG_FILE% 2>&1
    )

    IF EXIST "%INSTALL_DIR%\installinfo" (
        echo [INFO] %date% %time% copy /Y "%INSTALL_DIR%\installinfo" "%INSTALL_DIR%\tempdir\installinfo" >> %LOG_FILE% 2>&1
        copy /Y "%INSTALL_DIR%\installinfo" "%INSTALL_DIR%\tempdir\installinfo" >> %LOG_FILE% 2>&1
        IF NOT !exit_code! == 0 (
            echo [ERROR] %date% %time% The installinfo file cannot be stored. >> %LOG_FILE% 2>&1
            exit /b 102
        )
        echo [INFO] %date% %time% echo !INSTALL_TYPE! ^> "%INSTALL_DIR%\tempdir\installType" >> %LOG_FILE% 2>&1
        > "%INSTALL_DIR%\tempdir\installType" echo !INSTALL_TYPE!
    ) ELSE (
        echo [INFO] %date% %time% The file does not exist Skipped the copying of file. file="%INSTALL_DIR%\installinfo" >> %LOG_FILE% 2>&1
        echo [INFO] %date% %time% type nul ^> "%INSTALL_DIR%\tempdir\installType" >> %LOG_FILE% 2>&1
        > "%INSTALL_DIR%\tempdir\installType" type nul
    )

    REM After the configuration files backup, the configuration files are deleted in preinst when a user installs again.
    REM Created a lock file, because of the setting files will not be deleted.
    echo [INFO] %date% %time% ^> "%INSTALL_DIR%\tempdir\LOCKED" type nul >> %LOG_FILE% 2>&1
    > "%INSTALL_DIR%\tempdir\LOCKED" type nul

  ) else (
    echo [INFO] %date% %time% Lock file exists. skipped stored. file="%INSTALL_DIR%\tempdir\LOCKED" >> %LOG_FILE% 2>&1
  )

  call :DELETE_JETTY_DIRECTORY
  IF NOT !errorlevel! == 0 (
    exit /b 255
  )
  
  call :DELETE_RABBITMQ_DIRECTORY
  IF NOT !errorlevel! == 0 (
    exit /b 255
  )
)

echo [INFO] %date% %time% -------- Ending preinstall.bat log information. ---------- >> %LOG_FILE% 2>&1
exit /b 0


:DELETE_JETTY_DIRECTORY
REM delete the directory of the previous jetty version
set RETRY_MAX_CNT=5
set RETRY_INTERVAL=5
for /l %%i in (1, 1, !RETRY_MAX_CNT!) do (
    echo [INFO] !date! !time! rmdir /s /q "%INSTALL_DIR%\oss\jetty" >> %LOG_FILE% 2>&1
    rmdir /s /q "%INSTALL_DIR%\oss\jetty" >> %LOG_FILE% 2>&1
    if not exist "%INSTALL_DIR%\oss\jetty" (
      goto END_JETTY_RETRY
    )
    echo [INFO] !date! !time! retry the deletion of the directory of the previous jetty version ^( %%i ^/ !RETRY_MAX_CNT! ^) >> %LOG_FILE%
    timeout /T !RETRY_INTERVAL! > nul 2>&1
)
echo [ERROR] !date! !time! Cannot delete the directory of the previous jetty version >> %LOG_FILE% 2>&1
exit /b 255
:END_JETTY_RETRY
exit /b 0

:DELETE_RABBITMQ_DIRECTORY
REM delete the directory of the previous rabbitmq version
for /l %%i in (1, 1, !RETRY_MAX_CNT!) do (
    set RETRY_FLG=false
    for /d %%d in ("%INSTALL_DIR%\oss\rabbitmq\*") do (
      if not "%%d" == "%INSTALL_DIR%\oss\rabbitmq\etc" (
         echo [INFO] !date! !time! rmdir /s /q "%%d" >> %LOG_FILE% 2>&1
         rmdir /s /q "%%d" >> %LOG_FILE% 2>&1
         if exist "%%d" (
            set RETRY_FLG=true
         )
      )
    )
    if "!RETRY_FLG!" == "false" (
      goto END_RABBITMQ_RETRY
    )
    echo [INFO] !date! !time! retry the deletion of the directory of the previous rabbitmq version ^( %%i ^/ !RETRY_MAX_CNT! ^) >> %LOG_FILE%
    timeout /T !RETRY_INTERVAL! > nul 2>&1
)
echo [ERROR] !date! !time! Cannot delete the directory of the previous rabbitmq version >> %LOG_FILE% 2>&1
exit /b 255
:END_RABBITMQ_RETRY
exit /b 0
