@ECHO OFF
setlocal enabledelayedexpansion
REM **********************************************************************
REM * Copyright (c) by Hitachi Data Systems. 2014. All rights reservered *
REM **********************************************************************
REM
REM Manufacturing post install configuration script for an S Series node
REM
REM Requirements:
REM   - SSH Agent - i.e. pagent.exe with appropriate keys
REM   - plink.exe in C:\Program Files (x86)\Putty"
REM   - pscp.exe in C:\Program Files (x86)\Putty"
REM   - IP Address of a server module in the S Series node
REM   - Serial number
REM   - Number of enclosures
REM   - Number of drives (data+db)
REM
ECHO S Series Node Post Install Script

IF "%1" == "--help" GOTO Usage
IF "%1" == "-h" GOTO Usage
IF "%1" == "/h" GOTO Usage
IF "%1" == "/H" GOTO Usage

IF [%1] == [] (
  ECHO ERROR: No IP address specified.
  GOTO Usage
)

IF [%2] == [] (
  ECHO ERROR: No serial number specified.
  GOTO Usage
)

IF [%3] == [] (
  ECHO ERROR: Number of enclosures not specified.
  GOTO Usage
)

IF [%4] == [] (
  ECHO ERROR: Number of drives not specified.
  GOTO Usage
)

SET ip=%1
SET serial=%2
SET expectedNumEnclosures=%3
SET expectedNumDrives=%4
SET logfile=postinstall.log
SET plink="C:\Program Files (x86)\Putty\plink.exe"
SET pscp="C:\Program Files (x86)\Putty\pscp.exe"

IF NOT EXIST %plink% (
  SET plink="C:\Program Files\Putty\plink.exe"
  IF NOT EXIST !plink! (
    ECHO ERROR: plink utility is not installed.
    GOTO End
  )
)

IF NOT EXIST %pscp% (
  SET pscp="C:\Program Files\Putty\pscp.exe"
  IF NOT EXIST !pscp! (
    ECHO ERROR: pscp utility is not installed.
    GOTO End
  )
)

REM makes sure log file is empty at the start of the script
TYPE NUL > %logfile%

REM Auto accept the host key
SET cmdfile="accept.cmd"
ECHO echo > %cmdfile%
ECHO Y | %plink% -ssh root@%ip% -m %cmdfile% > nul 2> nul

IF %ERRORLEVEL% GEQ 1 (
  ECHO ERROR: Failed to automatically accept the host key.
  GOTO End
)

ECHO Checking if system is ready
CALL :RunAdminCommand  "checkifready.cmd", "admin status isStarted", "ERROR: The S Series node is not yet ready for the post-install script to run.  Try again in a few minutes." || GOTO END

FOR /F "delims=" %%i IN (%logfile%) DO (
  IF NOT "%%i" == "true" (
    ECHO ERROR: The S Series node is not yet ready for the post-install script to run.  Try again in a few minutes.
    GOTO End
  )
)

SET difeAllowed=true

:DifePompt

SET /P difeAllowedPrompt="Allow data-in-flight encryption (SSL)? [Yn] "
IF /I "%difeAllowedPrompt%" EQU "Y" GOTO DifePomptDone
IF /I "%difeAllowedPrompt%" EQU "N" GOTO DifeDisable
IF /I "%difeAllowedPrompt%" EQU "" GOTO DifePomptDone
GOTO DifePompt

:DifeDisable

SET difeAllowed=false
GOTO DifePomptDone

:DifePomptDone

ECHO Waiting for the S Series node to be ready to run the post-install script.
CALL :RunAdminCommand  "waitforready.cmd", "admin --timeout 1200000 status waitUntilReadyForPostInstall", "ERROR: No longer waiting.  Either the wait time has expired, or an error occurred." || GOTO END

ECHO Verifying number of enclosures is %expectedNumEnclosures%
CALL :RunAdminCommand  "numenclosures.cmd", "admin enclosureman addedCount", "ERROR: Failed to retrieve current number of enclosures." || GOTO END

FOR /F "delims=" %%i IN (%logfile%) DO SET numEncl=%%i

IF NOT "%numEncl%" == "%expectedNumEnclosures%" (
  ECHO "ERROR: The specified number of enclosures (%expectedNumEnclosures%) does not match the number of enclosures found (%numEncl%)."
  GOTO End
)

ECHO Verifying number of drives is %expectedNumDrives%
CALL :RunAdminCommand  "numdrives.cmd", "admin driveman addedMirroredCount", "ERROR: Failed to retrieve current number of drives." || GOTO END

FOR /F "delims=" %%i IN (%logfile%) DO SET numDrive=%%i

IF NOT "%numDrive%" == "%expectedNumDrives%" (
  ECHO "ERROR: The specified number of drives (%expectedNumDrives%) does not match the number of drives found (%numDrive%)."
  GOTO End
)

ECHO Setting serial number to %serial%
CALL :RunAdminCommand  "serial.cmd", "admin serialnumber set %serial%", "ERROR: Failed to set the serial number." || GOTO END

ECHO Configuring data-in-flight encryption (SSL)
CALL :RunAdminCommand  "https.cmd", "admin config set gen_setting_encryption_dife %difeAllowed%", "ERROR: Failed to configure data-in-flight encryption." || GOTO END

SET cmdfile="alerts.cmd"
ECHO admin alerts verify > %cmdfile%

SET alertsfile="alerts.out"
%plink% -batch -ssh root@%ip% -m %cmdfile% > %alertsfile%
 TYPE %alertsfile% >> %logfile%

IF %ERRORLEVEL% GEQ 1 (
  ECHO ERROR: Failed to verify the alerts.
  GOTO End
)

REM Check first line for [] meaning no alerts
FOR /F "usebackq delims=" %%i IN (%alertsfile%) DO (
    IF NOT "%%i" == "[]" (
        ECHO "ERROR: The following alerts are present:"
        TYPE %alertsfile%
        GOTO End
    )
    BREAK
)

ECHO Disabling secure shell (SSH)
CALL :RunAdminCommand  "disablessh.cmd", "admin config set ssh.enabled false", "ERROR: Failed to disable secure shell (SSH)." || GOTO END

ECHO Post Install Script Complete

GOTO End

:Usage
ECHO Usage: %0% ^<ip address^> ^<serial number^> ^<number of enclosures^> ^<number of drives^>

GOTO End

:RunAdminCommand
SET cmdfile=%~1
ECHO %~2 > %cmdfile%

%plink% -batch -ssh root@%ip% -m %cmdfile% >> %logfile%

IF %ERRORLEVEL% GEQ 1 (
  ECHO %3
  EXIT /B %ERRORLEVEL%
)

GOTO :EOF

:End

IF EXIST accept.cmd DEL accept.cmd
IF EXIST numenclosures.cmd DEL numenclosures.cmd
IF EXIST numdrives.cmd DEL numdrives.cmd
IF EXIST serial.cmd DEL serial.cmd
IF EXIST https.cmd DEL https.cmd
IF EXIST alerts.cmd DEL alerts.cmd
IF EXIST alerts.out DEL alerts.out
IF EXIST reset.cmd DEL reset.cmd
IF EXIST checkifready.cmd DEL checkifready.cmd
IF EXIST waitforready.cmd DEL waitforready.cmd
IF EXIST disablessh.cmd DEL disablessh.cmd
