#!/usr/bin/expect -f

# Copyright 2008-2014 Cumulus Systems Incorporated.
# All Rights Reserved.
#
# Version: 1.0

# Following are the error codes. Always keep it in sync with error codes in netappDataCollector.pl file.
set ERROR_SUCCESS                        0
set ERROR_SSH_INVALID_CRED               1
set ERROR_SSH_CONNECTION_FAILED          2
set ERROR_INVALID_OPTION_FOUND           3

set cmdType [lindex $argv 0]

# This function is used to handle the process for passing password for the first time in a request. As it is the first request, we need to handle all
# cases here.
#
# @param password : Password for NetApp device.
proc sendFirstTimePassword { password } {
    global ERROR_SSH_INVALID_CRED
    global ERROR_SSH_CONNECTION_FAILED

    # If SSH key is not set for the NetApp Storage IP then we will first asked for the confirmation.
    expect {
        "Are you sure you want to continue connecting (yes/no)*" {
            send "yes\r"
            exp_continue
        }

        "*?assword:*" {
            send "$password\r"
            puts "\nOutput start"
            exp_continue
        }

        "*Permission denied, please*" {
            exp_continue
        }

        "*Permission denied (publickey,password)*" {
            exit $ERROR_SSH_INVALID_CRED
        }

        "*Connection refused*" {
            exit $ERROR_SSH_CONNECTION_FAILED
        }

        "*No route to host*" {
            exit $ERROR_SSH_CONNECTION_FAILED
        }

        "*Connection timed out*" {
            exit $ERROR_SSH_CONNECTION_FAILED
        }

        "*Failed to communicate with the device*" {
            exit $ERROR_SSH_CONNECTION_FAILED
        }
    }
}

# This function is used to handle the process for passing password after we have already passed password one time in a given request.
#
# @param password : Password for NetApp device.
proc sendNextTimePassword { password } {
    # If SSH key is not set for the NetApp Storage IP then we will first asked for the confirmation.
    expect {
        "*?assword:*" {
            send "$password\r"
            puts "\nOutput start"
            exp_continue
        }
    }
}

if {"NetApp" == $cmdType} {
    set netappIpAddress [lindex $argv 1]
    set userName [lindex $argv 2]
    set password [lindex $argv 3]

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "sysconfig -a"

    puts "NetApp CLI: sysconfig -a"

    sendFirstTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "ipspace list"

    puts "NetApp CLI: ipspace list"

    sendNextTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "license"

    puts "NetApp CLI: license"

    sendNextTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "vfiler status -r"

    puts "NetApp CLI: vfiler status -r"

    sendNextTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "vfiler limit"

    puts "NetApp CLI: vfiler limit"

    sendNextTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "ifgrp status"

    puts "NetApp CLI: ifgrp status"

    sendNextTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "aggr status"

    puts "NetApp CLI: aggr status"

    sendNextTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "aggr show_space"

    puts "NetApp CLI: aggr show_space"

    sendNextTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "aggr media_scrub status"

    puts "NetApp CLI: aggr media_scrub status"

    sendNextTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "vol status"

    puts "NetApp CLI: vol status"

    sendNextTimePassword $password

    puts "Output end"
    
    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "vol media_scrub status"

    puts "NetApp CLI: vol media_scrub status"

    sendNextTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "df -sk"

    puts "NetApp CLI: df -sk"

    sendNextTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "useradmin user list"

    puts "NetApp CLI: useradmin user list"

    sendNextTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "useradmin group list"

    puts "NetApp CLI: useradmin group list"

    sendNextTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "useradmin role list"

    puts "NetApp CLI: useradmin role list"

    sendNextTimePassword $password

    puts "Output end"
    
    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "disk show"

    puts "NetApp CLI: disk show"

    sendNextTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "cifs sessions"

    puts "NetApp CLI: cifs sessions"

    sendNextTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "cifs prefdc print"

    puts "NetApp CLI: cifs prefdc print"

    sendNextTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "cifs domaininfo"

    puts "NetApp CLI: cifs domaininfo"

    sendNextTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "cifs shares"

    puts "NetApp CLI: cifs shares"

    sendNextTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "cifs stat"

    puts "NetApp CLI: cifs stat"

    sendNextTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "exportfs"

    puts "NetApp CLI: exportfs"

    sendNextTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "options nfs"

    puts "NetApp CLI: options nfs"

    sendNextTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "nis info"

    puts "NetApp CLI: nis info"

    sendNextTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "nfsstat"

    puts "NetApp CLI: nfsstat"

    sendNextTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "qtree stats"

    puts "NetApp CLI: qtree stats"

    sendNextTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "qtree status"

    puts "NetApp CLI: qtree status"

    sendNextTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "quota status"

    puts "NetApp CLI: quota status"

    sendNextTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "quota report"

    puts "NetApp CLI: quota report"

    sendNextTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "snapmirror status"

    puts "NetApp CLI: snapmirror status"

    sendNextTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "snapmirror destinations"

    puts "NetApp CLI: snapmirror destinations"

    sendNextTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "snap list"

    puts "NetApp CLI: snap list"

    sendNextTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "snap sched"

    puts "NetApp CLI: snap sched"

    sendNextTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "snapvault status"

    puts "NetApp CLI: snapvault status"

    sendNextTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "snapvault destinations"

    puts "NetApp CLI: snapvault destinations"

    sendNextTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "lun show"

    puts "NetApp CLI: lun show"

    sendNextTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "lun stats"

    puts "NetApp CLI: lun stats"

    sendNextTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "iscsi alias"

    puts "NetApp CLI: iscsi alias"

    sendNextTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "iscsi interface accesslist show"

    puts "NetApp CLI: iscsi interface accesslist show"

    sendNextTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "iscsi security show"

    puts "NetApp CLI: iscsi security show"

    sendNextTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "iscsi show initiator"

    puts "NetApp CLI: iscsi show initiator"

    sendNextTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "iscsi status"

    puts "NetApp CLI: iscsi status"

    sendNextTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "iscsi stats"

    puts "NetApp CLI: iscsi stats"

    sendNextTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "iscsi connection show"

    puts "NetApp CLI: iscsi connection show"

    sendNextTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "iscsi session show"

    puts "NetApp CLI: iscsi session show"

    sendNextTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "iscsi isns show"

    puts "NetApp CLI: iscsi isns show"

    sendNextTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "iscsi nodename"

    puts "NetApp CLI: iscsi nodename"

    sendNextTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "iscsi portal show"

    puts "NetApp CLI: iscsi portal show"

    sendNextTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "iscsi tpgroup show"

    puts "NetApp CLI: iscsi tpgroup show"

    sendNextTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "sis status"

    puts "NetApp CLI: sis status"

    sendNextTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "sis config"

    puts "NetApp CLI: sis config"

    sendNextTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "fcp config"

    puts "NetApp CLI: fcp config"

    sendNextTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "fcp stats"

    puts "NetApp CLI: fcp stats"

    sendNextTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "fcp topology show"

    puts "NetApp CLI: fcp topology show"

    sendNextTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "fcp portname show"

    puts "NetApp CLI: fcp portname show"

    sendNextTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "fcp status"

    puts "NetApp CLI: fcp status"

    sendNextTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "fcp wwpn-alias show"

    puts "NetApp CLI: fcp wwpn-alias show"

    sendNextTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "fcp nameserver show"

    puts "NetApp CLI: fcp nameserver show"

    sendNextTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "fcp show nodename"

    puts "NetApp CLI: fcp show nodename"

    sendNextTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "fcp show initiator"

    puts "NetApp CLI: fcp show initiator"

    sendNextTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "fcp show adapter"

    puts "NetApp CLI: fcp show adapter"

    sendNextTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "fcp zone show"

    puts "NetApp CLI: fcp zone show"

    sendNextTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "fcp show cfmode"

    puts "NetApp CLI: fcp show cfmode"

    sendNextTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "df -h"

    puts "NetApp CLI: df -h"

    sendNextTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "aggr status -r"

    puts "NetApp CLI: aggr status -r"

    sendNextTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "aggr status -v"

    puts "NetApp CLI: aggr status -v"

    sendNextTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "options admin.hosts"

    puts "NetApp CLI: options admin.hosts"

    sendNextTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "lun show -v"

    puts "NetApp CLI: lun show -v"

    sendNextTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "lun show -m"

    puts "NetApp CLI: lun show -m"

    sendNextTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "snapmirror status -l"

    puts "NetApp CLI: snapmirror status -l"

    sendNextTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "rdfile /etc/snapmirror.conf"

    puts "NetApp CLI: rdfile /etc/snapmirror.conf"

    sendNextTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "snapvault status -l"

    puts "NetApp CLI: snapvault status -l"

    sendNextTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "snapvault snap sched"

    puts "NetApp CLI: snapvault snap sched"

    sendNextTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "snap delta -V"

    puts "NetApp CLI: snap delta -V"

    sendNextTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "options iscsi.max_connections_per_session"

    puts "NetApp CLI: options iscsi.max_connections_per_session"

    sendNextTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "igroup show"

    puts "NetApp CLI: igroup show"

    sendNextTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "iscsi connection show -v"

    puts "NetApp CLI: iscsi connection show -v"

    sendNextTimePassword $password

    puts "Output end"

    exit $ERROR_SUCCESS
} elseif {"Filer" == $cmdType} {
    set netappIpAddress [lindex $argv 1]
    set userName [lindex $argv 2]
    set password [lindex $argv 3]
    set vFilerName [lindex $argv 4]

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "vfiler run $vFilerName cifs sessions"

    puts "NetApp CLI: vfiler run $vFilerName cifs sessions"

    sendFirstTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "vfiler run $vFilerName cifs prefdc print"

    puts "NetApp CLI: vfiler run $vFilerName cifs prefdc print"

    sendNextTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "vfiler run $vFilerName cifs domaininfo"

    puts "NetApp CLI: vfiler run $vFilerName cifs domaininfo"

    sendNextTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "vfiler run $vFilerName cifs shares"

    puts "NetApp CLI: vfiler run $vFilerName cifs shares"

    sendNextTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "vfiler run $vFilerName cifs stat"

    puts "NetApp CLI: vfiler run $vFilerName cifs stat"

    sendNextTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "vfiler run $vFilerName exportfs"

    puts "NetApp CLI: vfiler run $vFilerName exportfs"

    sendNextTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "vfiler run $vFilerName options nfs"

    puts "NetApp CLI: vfiler run $vFilerName options nfs"

    sendNextTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "vfiler run $vFilerName nis info"

    puts "NetApp CLI: vfiler run $vFilerName nis info"

    sendNextTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "vfiler run $vFilerName nfsstat"

    puts "NetApp CLI: vfiler run $vFilerName nfsstat"

    sendNextTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "vfiler run $vFilerName qtree stats"

    puts "NetApp CLI: vfiler run $vFilerName qtree stats"

    sendNextTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "vfiler run $vFilerName qtree status"

    puts "NetApp CLI: vfiler run $vFilerName qtree status"

    sendNextTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "vfiler run $vFilerName quota status"

    puts "NetApp CLI: vfiler run $vFilerName quota status"

    sendNextTimePassword $password

    puts "Output end"
    
    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "vfiler run $vFilerName quota report"

    puts "NetApp CLI: vfiler run $vFilerName quota report"

    sendNextTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "vfiler run $vFilerName snapmirror status"

    puts "NetApp CLI: vfiler run $vFilerName snapmirror status"

    sendNextTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "vfiler run $vFilerName snapmirror destinations"

    puts "NetApp CLI: vfiler run $vFilerName snapmirror destinations"

    sendNextTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "vfiler run $vFilerName snap list"

    puts "NetApp CLI: vfiler run $vFilerName snap list"

    sendNextTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "vfiler run $vFilerName snap sched"

    puts "NetApp CLI: vfiler run $vFilerName snap sched"

    sendNextTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "vfiler run $vFilerName snapvault status"

    puts "NetApp CLI: vfiler run $vFilerName snapvault status"

    sendNextTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "vfiler run $vFilerName snapvault destinations"

    puts "NetApp CLI: vfiler run $vFilerName snapvault destinations"

    sendNextTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "vfiler run $vFilerName lun show"

    puts "NetApp CLI: vfiler run $vFilerName lun show"

    sendNextTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "vfiler run $vFilerName lun stats"

    puts "NetApp CLI: vfiler run $vFilerName lun stats"

    sendNextTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "vfiler run $vFilerName vol status -v"

    puts "NetApp CLI: vfiler run $vFilerName vol status -v"

    sendNextTimePassword $password

    puts "Output end"

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "vfiler run $vFilerName sis status -l"

    puts "NetApp CLI: vfiler run $vFilerName sis status -l"

    sendNextTimePassword $password

    puts "Output end"

    exit $ERROR_SUCCESS
} elseif {"FilerList" == $cmdType} {
    set eternusIpAddress [lindex $argv 1]
    set userName [lindex $argv 2]
    set password [lindex $argv 3]

    spawn -nottycopy -nottyinit ssh -2 -l $userName $eternusIpAddress "vfiler status"

    sendFirstTimePassword $password

    puts "Output end"

    exit $ERROR_SUCCESS
} elseif {"CIFSDEFAULT" == $cmdType} {
    set eternusIpAddress [lindex $argv 1]
    set userName [lindex $argv 2]
    set password [lindex $argv 3]

    spawn -nottycopy -nottyinit ssh -2 -l $userName $eternusIpAddress "cifs shares"

    sendFirstTimePassword $password

    puts "Output end"

    exit $ERROR_SUCCESS
} elseif {"CIFS" == $cmdType} {
    set eternusIpAddress [lindex $argv 1]
    set userName [lindex $argv 2]
    set password [lindex $argv 3]
    set vFilerName [lindex $argv 4]

    spawn -nottycopy -nottyinit ssh -2 -l $userName $eternusIpAddress "vfiler run $vFilerName cifs shares"

    puts "NetApp CLI: vfiler run $vFilerName cifs shares"

    sendFirstTimePassword $password

    puts "Output end"

    exit $ERROR_SUCCESS
} elseif {"System" == $cmdType} {
    set netappIpAddress [lindex $argv 1]
    set userName [lindex $argv 2]
    set password [lindex $argv 3]

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "sysconfig -a"

    puts "NetApp CLI: sysconfig -a"

    sendFirstTimePassword $password

    puts "Output end"

    exit $ERROR_SUCCESS
} elseif {"SnapMirrorStatus" == $cmdType} {
    set netappIpAddress [lindex $argv 1]
    set userName [lindex $argv 2]
    set password [lindex $argv 3]

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "snapmirror status"

    puts "NetApp CLI: snapmirror status"

    sendFirstTimePassword $password

    puts "Output end"

    exit $ERROR_SUCCESS
} elseif {"User" == $cmdType} {
    set netappIpAddress [lindex $argv 1]
    set userName [lindex $argv 2]
    set password [lindex $argv 3]

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "useradmin user list"

    puts "NetApp CLI: useradmin user list"

    sendFirstTimePassword $password

    puts "Output end"

    exit $ERROR_SUCCESS
} elseif {"Group" == $cmdType} {
    set netappIpAddress [lindex $argv 1]
    set userName [lindex $argv 2]
    set password [lindex $argv 3]

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "useradmin group list"

    puts "NetApp CLI: useradmin group list"

    sendFirstTimePassword $password

    puts "Output end"

    exit $ERROR_SUCCESS
} elseif {"VolumeCapacity" == $cmdType} {
    set netappIpAddress [lindex $argv 1]
    set userName [lindex $argv 2]
    set password [lindex $argv 3]

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "df -h"

    puts "NetApp CLI: df -h"

    sendFirstTimePassword $password

    puts "Output end"

    exit $ERROR_SUCCESS
} elseif {"Volume" == $cmdType} {
    set netappIpAddress [lindex $argv 1]
    set userName [lindex $argv 2]
    set password [lindex $argv 3]
    set volName [lindex $argv 4]

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "vol status -v $volName"

    puts "NetApp CLI: vol status -v $volName"

    sendFirstTimePassword $password

    puts "Output end"

    exit $ERROR_SUCCESS
} elseif {"VolumeSis" == $cmdType} {
    set netappIpAddress [lindex $argv 1]
    set userName [lindex $argv 2]
    set password [lindex $argv 3]
    set volPath [lindex $argv 4]

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "sis status -l $volPath"

    puts "NetApp CLI: sis status -l $volPath"

    sendFirstTimePassword $password

    puts "Output end"

    exit $ERROR_SUCCESS
} elseif {"VolumeOptions" == $cmdType} {
    set netappIpAddress [lindex $argv 1]
    set userName [lindex $argv 2]
    set password [lindex $argv 3]
    set volName [lindex $argv 4]

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "vol options $volName"

    puts "NetApp CLI: vol options $volName"

    sendFirstTimePassword $password

    puts "Output end"

    exit $ERROR_SUCCESS   
}  elseif {"AggregateCapacity" == $cmdType} {
    set netappIpAddress [lindex $argv 1]
    set userName [lindex $argv 2]
    set password [lindex $argv 3]

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "aggr show_space"
    
    puts "NetApp CLI: aggr show_space"

    sendFirstTimePassword $password

    puts "Output end"

    exit $ERROR_SUCCESS
} elseif {"AggregateDiskCount" == $cmdType} {
    set netappIpAddress [lindex $argv 1]
    set userName [lindex $argv 2]
    set password [lindex $argv 3]

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "aggr status -r"
    
    puts "NetApp CLI: aggr status -r"

    sendFirstTimePassword $password

    puts "Output end"

    exit $ERROR_SUCCESS
} elseif {"Aggregate" == $cmdType} {
    set netappIpAddress [lindex $argv 1]
    set userName [lindex $argv 2]
    set password [lindex $argv 3]
    set aggrName [lindex $argv 4]

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "aggr status -v $aggrName"
    
    puts "NetApp CLI: aggr status -v $aggrName"

    sendFirstTimePassword $password

    puts "Output end"

    exit $ERROR_SUCCESS
} elseif {"AdminHost" == $cmdType} {
    set netappIpAddress [lindex $argv 1]
    set userName [lindex $argv 2]
    set password [lindex $argv 3]

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "options admin.hosts"
    
    puts "NetApp CLI: options admin.hosts"

    sendFirstTimePassword $password

    puts "Output end"

    exit $ERROR_SUCCESS
} elseif {"NetBios" == $cmdType} {
    set netappIpAddress [lindex $argv 1]
    set userName [lindex $argv 2]
    set password [lindex $argv 3]
    set vFilerName [lindex $argv 4]

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "vfiler run $vFilerName cifs sessions"
    
    puts "NetApp CLI: vfiler run $vFilerName cifs sessions"

    sendFirstTimePassword $password

    puts "Output end"

    exit $ERROR_SUCCESS
} elseif {"Qtree" == $cmdType} {
    set netappIpAddress [lindex $argv 1]
    set userName [lindex $argv 2]
    set password [lindex $argv 3]

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "qtree status"
    
    puts "NetApp CLI: qtree status"

    sendFirstTimePassword $password

    puts "Output end"

    exit $ERROR_SUCCESS
} elseif {"Quota" == $cmdType} {
    set netappIpAddress [lindex $argv 1]
    set userName [lindex $argv 2]
    set password [lindex $argv 3]
    set vFilerName [lindex $argv 4]

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "vfiler run $vFilerName quota report"
    
    puts "NetApp CLI: vfiler run $vFilerName quota report"

    sendFirstTimePassword $password

    puts "Output end"

    exit $ERROR_SUCCESS
} elseif {"QuotaWithoutFiler" == $cmdType} {
    set netappIpAddress [lindex $argv 1]
    set userName [lindex $argv 2]
    set password [lindex $argv 3]

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "quota report"

    puts "NetApp CLI: quota report"

    sendFirstTimePassword $password

    puts "Output end"

    exit $ERROR_SUCCESS
} elseif {"QuotaStatus" == $cmdType} {
    set netappIpAddress [lindex $argv 1]
    set userName [lindex $argv 2]
    set password [lindex $argv 3]

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "quota status"

    puts "NetApp CLI: quota status"

    sendFirstTimePassword $password

    puts "Output end"

    exit $ERROR_SUCCESS
} elseif {"VFiler" == $cmdType} {
    set netappIpAddress [lindex $argv 1]
    set userName [lindex $argv 2]
    set password [lindex $argv 3]

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "vfiler status -r"

    puts "NetApp CLI: vfiler status -r"

    sendFirstTimePassword $password

    puts "Output end"

    exit $ERROR_SUCCESS
} elseif {"Lun" == $cmdType} {
    set netappIpAddress [lindex $argv 1]
    set userName [lindex $argv 2]
    set password [lindex $argv 3]

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "lun show -v"

    puts "NetApp CLI: lun show -v"

    sendFirstTimePassword $password

    puts "Output end"

    exit $ERROR_SUCCESS
} elseif {"LunMapping" == $cmdType} {
    set netappIpAddress [lindex $argv 1]
    set userName [lindex $argv 2]
    set password [lindex $argv 3]

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "lun show -m"

    puts "NetApp CLI: lun show -m"

    sendFirstTimePassword $password

    puts "Output end"

    exit $ERROR_SUCCESS
} elseif {"NfsShare" == $cmdType} {
    set netappIpAddress [lindex $argv 1]
    set userName [lindex $argv 2]
    set password [lindex $argv 3]
    set vFilerName [lindex $argv 4]

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "vfiler run $vFilerName exportfs"

    puts "NetApp CLI: vfiler run $vFilerName exportfs"

    sendFirstTimePassword $password

    puts "Output end"

    exit $ERROR_SUCCESS
} elseif {"NfsShareWithoutFiler" == $cmdType} {
    set netappIpAddress [lindex $argv 1]
    set userName [lindex $argv 2]
    set password [lindex $argv 3]

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "exportfs"

    puts "NetApp CLI: exportfs"

    sendFirstTimePassword $password

    puts "Output end"

    exit $ERROR_SUCCESS
} elseif {"SnapMirror" == $cmdType} {
    set netappIpAddress [lindex $argv 1]
    set userName [lindex $argv 2]
    set password [lindex $argv 3]

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "snapmirror status -l"

    puts "NetApp CLI: snapmirror status -l"

    sendFirstTimePassword $password

    puts "Output end"

    exit $ERROR_SUCCESS
} elseif {"SnapMirrorSchedule" == $cmdType} {
    set netappIpAddress [lindex $argv 1]
    set userName [lindex $argv 2]
    set password [lindex $argv 3]

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "rdfile /etc/snapmirror.conf"

    puts "NetApp CLI: rdfile /etc/snapmirror.conf"

    sendFirstTimePassword $password

    puts "Output end"

    exit $ERROR_SUCCESS
} elseif {"SnapVault" == $cmdType} {
    set netappIpAddress [lindex $argv 1]
    set userName [lindex $argv 2]
    set password [lindex $argv 3]

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "snapvault status -l"

    puts "NetApp CLI: snapvault status -l"

    sendFirstTimePassword $password

    puts "Output end"

    exit $ERROR_SUCCESS
} elseif {"SnapVaultSchedule" == $cmdType} {
    set netappIpAddress [lindex $argv 1]
    set userName [lindex $argv 2]
    set password [lindex $argv 3]

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "snapvault snap sched"

    puts "NetApp CLI: snapvault snap sched"

    sendFirstTimePassword $password

    puts "Output end"

    exit $ERROR_SUCCESS
} elseif {"CifsShare" == $cmdType} {
    set netappIpAddress [lindex $argv 1]
    set userName [lindex $argv 2]
    set password [lindex $argv 3]
    set vFilerName [lindex $argv 4]

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "vfiler run $vFilerName cifs shares"

    puts "NetApp CLI: vfiler run $vFilerName cifs shares"

    sendFirstTimePassword $password

    puts "Output end"

    exit $ERROR_SUCCESS
} elseif {"CifsShareWithoutFiler" == $cmdType} {
    set netappIpAddress [lindex $argv 1]
    set userName [lindex $argv 2]
    set password [lindex $argv 3]

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "cifs shares"

    puts "NetApp CLI: cifs shares"

    sendFirstTimePassword $password

    puts "Output end"

    exit $ERROR_SUCCESS
} elseif {"SnapShot" == $cmdType} {
    set netappIpAddress [lindex $argv 1]
    set userName [lindex $argv 2]
    set password [lindex $argv 3]
    set volumeName [lindex $argv 4]

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "snap list $volumeName"

    puts "NetApp CLI: snap list $volumeName"

    sendFirstTimePassword $password

    puts "Output end"

    exit $ERROR_SUCCESS
} elseif {"SnapShotBlockCount" == $cmdType} {
    set netappIpAddress [lindex $argv 1]
    set userName [lindex $argv 2]
    set password [lindex $argv 3]
    set volumeName [lindex $argv 4]
    set snapshotName [lindex $argv 5]

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "snap delta -V $volumeName $snapshotName"

    puts "NetApp CLI: snap delta -V $volumeName $snapshotName"

    sendFirstTimePassword $password

    puts "Output end"

    exit $ERROR_SUCCESS
} elseif {"FcpNameServer" == $cmdType} {
    set netappIpAddress [lindex $argv 1]
    set userName [lindex $argv 2]
    set password [lindex $argv 3]

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "fcp nameserver show"

    puts "NetApp CLI: fcp nameserver show"

    sendFirstTimePassword $password

    puts "Output end"

    exit $ERROR_SUCCESS
} elseif {"FcpInitiator" == $cmdType} {
    set netappIpAddress [lindex $argv 1]
    set userName [lindex $argv 2]
    set password [lindex $argv 3]

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "fcp show initiator"

    puts "NetApp CLI: fcp show initiator"

    sendFirstTimePassword $password

    puts "Output end"

    exit $ERROR_SUCCESS
} elseif {"IscsiInitiator" == $cmdType} {
    set netappIpAddress [lindex $argv 1]
    set userName [lindex $argv 2]
    set password [lindex $argv 3]

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "iscsi initiator show"

    puts "NetApp CLI: iscsi initiator show"

    sendFirstTimePassword $password

    puts "Output end"

    exit $ERROR_SUCCESS
} elseif {"IscsiPortal" == $cmdType} {
    set netappIpAddress [lindex $argv 1]
    set userName [lindex $argv 2]
    set password [lindex $argv 3]

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "iscsi portal show"

    puts "NetApp CLI: iscsi portal show"

    sendFirstTimePassword $password

    puts "Output end"

    exit $ERROR_SUCCESS
} elseif {"IscsiMaxCon" == $cmdType} {
    set netappIpAddress [lindex $argv 1]
    set userName [lindex $argv 2]
    set password [lindex $argv 3]

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "options iscsi.max_connections_per_session"

    puts "NetApp CLI: options iscsi.max_connections_per_session"

    sendFirstTimePassword $password

    puts "Output end"

    exit $ERROR_SUCCESS
} elseif {"IscsiSecurity" == $cmdType} {
    set netappIpAddress [lindex $argv 1]
    set userName [lindex $argv 2]
    set password [lindex $argv 3]

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "iscsi security show"

    puts "NetApp CLI: iscsi security show"

    sendFirstTimePassword $password

    puts "Output end"

    exit $ERROR_SUCCESS
} elseif {"InitiatorGroup" == $cmdType} {
    set netappIpAddress [lindex $argv 1]
    set userName [lindex $argv 2]
    set password [lindex $argv 3]

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "igroup show"

    puts "NetApp CLI: igroup show"

    sendFirstTimePassword $password

    puts "Output end"

    exit $ERROR_SUCCESS
} elseif {"IscsiCon" == $cmdType} {
    set netappIpAddress [lindex $argv 1]
    set userName [lindex $argv 2]
    set password [lindex $argv 3]

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "iscsi connection show -v"

    puts "NetApp CLI: iscsi connection show -v"

    sendFirstTimePassword $password

    puts "Output end"

    exit $ERROR_SUCCESS
} elseif {"VolumeList" == $cmdType} {
    set netappIpAddress [lindex $argv 1]
    set userName [lindex $argv 2]
    set password [lindex $argv 3]

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "vol status"

    puts "NetApp CLI: vol status"

    sendFirstTimePassword $password

    puts "Output end"

    exit $ERROR_SUCCESS
} elseif {"Authentication" == $cmdType} {
    set netappIpAddress [lindex $argv 1]
    set userName [lindex $argv 2]
    set password [lindex $argv 3]

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "version"

    puts "NetApp CLI: version"

    sendFirstTimePassword $password

    puts "Output end"

    exit $ERROR_SUCCESS
} elseif {"Port" == $cmdType} {
    set netappIpAddress [lindex $argv 1]
    set userName [lindex $argv 2]
    set password [lindex $argv 3]

    spawn -nottycopy -nottyinit ssh -2 -l $userName $netappIpAddress "fcp portname show"

    puts "NetApp CLI: fcp portname show"

    sendFirstTimePassword $password

    puts "Output end"

    exit $ERROR_SUCCESS
} else {
    exit $ERROR_INVALID_OPTION_FOUND
}
