<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="text"/>
	<xsl:param name="system" select="NoName"/>

	<xsl:template match="disk-detail-info" xml:space="default">
		<xsl:text>R:naDisk#</xsl:text><xsl:value-of select="$system"/>^<xsl:value-of select="name"/><xsl:text>&#xa;</xsl:text>
		<xsl:text>O:naDisk#</xsl:text><xsl:value-of select="$system"/>^<xsl:value-of select="disk-uid"/><xsl:text>&#xa;</xsl:text>
		<xsl:text>a:name=</xsl:text><xsl:value-of select="$system"/>^<xsl:value-of select="name"/><xsl:text>&#xa;</xsl:text>
		<xsl:text>a:uuid=</xsl:text><xsl:value-of select="disk-uid"/><xsl:text>&#xa;</xsl:text>
		<xsl:text>a:type=</xsl:text><xsl:value-of select="disk-type"/><xsl:text>&#xa;</xsl:text>
		<xsl:text>a:physicalSpace=</xsl:text><xsl:value-of select="physical-space"/><xsl:text>&#xa;</xsl:text>
		<xsl:text>a:pool=</xsl:text><xsl:value-of select="pool"/><xsl:text>&#xa;</xsl:text>
		<xsl:text>a:serialNumber=</xsl:text><xsl:value-of select="serial-number"/><xsl:text>&#xa;</xsl:text>
		<xsl:text>a:vendor=</xsl:text><xsl:value-of select="vendor-id"/><xsl:text>&#xa;</xsl:text>
		<xsl:text>a:model=</xsl:text><xsl:value-of select="disk-model"/><xsl:text>&#xa;</xsl:text>
		<xsl:text>a:raidState=</xsl:text><xsl:value-of select="raid-state"/><xsl:text>&#xa;</xsl:text>
		<xsl:text>a:raidGroup=</xsl:text><xsl:value-of select="raid-group"/><xsl:text>&#xa;</xsl:text>
		<xsl:text>a:shelf=</xsl:text><xsl:value-of select="shelf"/><xsl:text>&#xa;</xsl:text>

		<xsl:if test="aggregate != ''">
			<xsl:text>r:naSystem#</xsl:text><xsl:value-of select="$system"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>r:naAggregate#</xsl:text><xsl:value-of select="$system"/>^<xsl:value-of select="aggregate"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>r:naPlex#</xsl:text><xsl:value-of select="$system"/>^/<xsl:value-of select="aggregate"/>/<xsl:value-of select="plex"/><xsl:text>&#xa;</xsl:text>
		</xsl:if>

		<xsl:if test="volume != ''">
			<xsl:text>r:naSystem#</xsl:text><xsl:value-of select="$system"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>r:naAggregate#</xsl:text><xsl:value-of select="$system"/>^<xsl:value-of select="volume"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>r:naPlex#</xsl:text><xsl:value-of select="$system"/>^/<xsl:value-of select="aggregate"/>/<xsl:value-of select="plex"/><xsl:text>&#xa;</xsl:text>
		</xsl:if>

		<xsl:if test="not(aggregate) and not(volume)">
			<xsl:text>r:naSystem#</xsl:text><xsl:value-of select="$system"/><xsl:text>&#xa;</xsl:text>
		</xsl:if>
	</xsl:template>

</xsl:stylesheet>
