<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="text"/>
	<xsl:param name="system" select="NoName"/>

	<xsl:template match="/" xml:space="default">
		<xsl:for-each select="results/fcp-adapters/fcp-adapter-initiators-info">
			<xsl:variable name="adaptor" select="adapter"/>
			<xsl:for-each select="fcp-connected-initiators/fcp-connected-initiator-info">
				<xsl:text>R:naFcpInitiator#</xsl:text><xsl:value-of select="$system"/>^<xsl:value-of select="port-name"/><xsl:text>&#xa;</xsl:text>
				<xsl:text>a:name=</xsl:text><xsl:value-of select="$system"/>^<xsl:value-of select="port-name"/><xsl:text>&#xa;</xsl:text>
				<xsl:text>a:nodeName=</xsl:text><xsl:value-of select="node-name"/><xsl:text>&#xa;</xsl:text>
				<xsl:text>a:portAddress=</xsl:text><xsl:value-of select="port-address"/><xsl:text>&#xa;</xsl:text>
				<xsl:text>a:adaptor=</xsl:text><xsl:value-of select="$adaptor"/><xsl:text>&#xa;</xsl:text>
				<xsl:text>r:naSystem#</xsl:text><xsl:value-of select="$system"/><xsl:text>&#xa;</xsl:text>
			</xsl:for-each>
		</xsl:for-each>
	</xsl:template>

</xsl:stylesheet>
