<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="text"/>
	<xsl:param name="system" select="NoName"/>

	<xsl:template match="/" xml:space="default">
		<xsl:for-each select="results/useradmin-groups/useradmin-group-info">
			<xsl:text>R:naGroup#</xsl:text><xsl:value-of select="$system" />^<xsl:value-of select="name"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:name=</xsl:text><xsl:value-of select="$system"/>^<xsl:value-of select="name"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:rid=</xsl:text><xsl:value-of select="rid"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:roles=</xsl:text>
			<xsl:for-each select="useradmin-roles/useradmin-role-info/name">
				<xsl:value-of select="."/>
				<xsl:if test="position() != last()">
					<xsl:text>,</xsl:text>
				</xsl:if>
				<xsl:if test="position() = last()">
					<xsl:text>&#xa;</xsl:text>
				</xsl:if>
			</xsl:for-each>
			<xsl:text>r:naSystem#</xsl:text><xsl:value-of select="$system" /><xsl:text>&#xa;</xsl:text>
		</xsl:for-each>
	</xsl:template>

</xsl:stylesheet>
