<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="text"/>
	<xsl:param name="system" select="NoName"/>
	<xsl:param name="qtreeList" select="NoName"/>

	<xsl:template match="/" xml:space="default">
		<xsl:for-each select="results/quotas/quota">
			<xsl:if test="quota-type = 'group' and quota-target = '*' and tree = ''">
				<xsl:text>R:naQuota#</xsl:text><xsl:value-of select="$system" />^<xsl:value-of select="volume"/>-group-allqtree-allgroup<xsl:text>&#xa;</xsl:text>
				<xsl:text>a:name=</xsl:text><xsl:value-of select="$system"/>^<xsl:value-of select="volume"/>-group-allqtree-allgroup<xsl:text>&#xa;</xsl:text>
				<xsl:text>a:groupId=allgroup</xsl:text><xsl:text>&#xa;</xsl:text>
				<xsl:text>a:type=</xsl:text><xsl:value-of select="quota-type"/><xsl:text>&#xa;</xsl:text>
				<xsl:text>a:fileLimit=</xsl:text><xsl:value-of select="file-limit"/><xsl:text>&#xa;</xsl:text>
				<xsl:text>a:fileUsed=</xsl:text><xsl:value-of select="files-used"/><xsl:text>&#xa;</xsl:text>
				<xsl:text>a:diskLimit=</xsl:text><xsl:value-of select="disk-limit"/><xsl:text>&#xa;</xsl:text>
				<xsl:text>a:diskUsed=</xsl:text><xsl:value-of select="disk-used"/><xsl:text>&#xa;</xsl:text>
				<xsl:text>a:qtree=allqtree</xsl:text><xsl:text>&#xa;</xsl:text>
				<xsl:text>r:naVolume#</xsl:text><xsl:value-of select="$system" />^<xsl:value-of select="volume"/><xsl:text>&#xa;</xsl:text>
				<xsl:text>r:</xsl:text><xsl:value-of select="$qtreeList"/><xsl:text>&#xa;</xsl:text>
			</xsl:if>

			<xsl:if test="quota-type = 'group' and quota-target != '' and tree = '' and quota-users">
				<xsl:text>R:naQuota#</xsl:text><xsl:value-of select="$system" />^<xsl:value-of select="volume"/>-group-allqtree-<xsl:value-of select="quota-users/quota-user/quota-user-id" /><xsl:text>&#xa;</xsl:text>
				<xsl:text>a:name=</xsl:text><xsl:value-of select="$system"/>^<xsl:value-of select="volume"/>-group-allqtree-<xsl:value-of select="quota-users/quota-user/quota-user-id" /><xsl:text>&#xa;</xsl:text>
				<xsl:text>a:groupId=</xsl:text><xsl:value-of select="quota-users/quota-user/quota-user-id"/><xsl:text>&#xa;</xsl:text>
				<xsl:text>a:type=</xsl:text><xsl:value-of select="quota-type"/><xsl:text>&#xa;</xsl:text>
				<xsl:text>a:fileLimit=</xsl:text><xsl:value-of select="file-limit"/><xsl:text>&#xa;</xsl:text>
				<xsl:text>a:fileUsed=</xsl:text><xsl:value-of select="files-used"/><xsl:text>&#xa;</xsl:text>
				<xsl:text>a:diskLimit=</xsl:text><xsl:value-of select="disk-limit"/><xsl:text>&#xa;</xsl:text>
				<xsl:text>a:diskUsed=</xsl:text><xsl:value-of select="disk-used"/><xsl:text>&#xa;</xsl:text>
				<xsl:text>a:qtree=allqtree</xsl:text><xsl:text>&#xa;</xsl:text>
				<xsl:text>r:naVolume#</xsl:text><xsl:value-of select="$system" />^<xsl:value-of select="volume"/><xsl:text>&#xa;</xsl:text>
				<xsl:text>r:</xsl:text><xsl:value-of select="$qtreeList"/><xsl:text>&#xa;</xsl:text>
			</xsl:if>

			<xsl:if test="quota-type = 'group' and quota-target != '' and tree != '' and quota-users">
				<xsl:text>R:naQuota#</xsl:text><xsl:value-of select="$system" />^<xsl:value-of select="volume"/>-group-<xsl:value-of select="tree" />-<xsl:value-of select="quota-users/quota-user/quota-user-id" /><xsl:text>&#xa;</xsl:text>
				<xsl:text>a:name=</xsl:text><xsl:value-of select="$system"/>^<xsl:value-of select="volume"/>-group-<xsl:value-of select="tree" />-<xsl:value-of select="quota-users/quota-user/quota-user-id" /><xsl:text>&#xa;</xsl:text>
				<xsl:text>a:groupId=</xsl:text><xsl:value-of select="quota-users/quota-user/quota-user-id"/><xsl:text>&#xa;</xsl:text>
				<xsl:text>a:type=</xsl:text><xsl:value-of select="quota-type"/><xsl:text>&#xa;</xsl:text>
				<xsl:text>a:fileLimit=</xsl:text><xsl:value-of select="file-limit"/><xsl:text>&#xa;</xsl:text>
				<xsl:text>a:fileUsed=</xsl:text><xsl:value-of select="files-used"/><xsl:text>&#xa;</xsl:text>
				<xsl:text>a:diskLimit=</xsl:text><xsl:value-of select="disk-limit"/><xsl:text>&#xa;</xsl:text>
				<xsl:text>a:diskUsed=</xsl:text><xsl:value-of select="disk-used"/><xsl:text>&#xa;</xsl:text>
				<xsl:text>a:qtree=</xsl:text><xsl:value-of select="tree"/><xsl:text>&#xa;</xsl:text>
				<xsl:text>r:naVolume#</xsl:text><xsl:value-of select="$system" />^<xsl:value-of select="volume"/><xsl:text>&#xa;</xsl:text>
				<xsl:text>r:naQtree#</xsl:text><xsl:value-of select="$system"/>^<xsl:value-of select="volume"/>-<xsl:value-of select="tree"/><xsl:text>&#xa;</xsl:text>
			</xsl:if>

			<xsl:if test="quota-type = 'group' and quota-target = '*' and tree != ''">
				<xsl:text>R:naQuota#</xsl:text><xsl:value-of select="$system" />^<xsl:value-of select="volume"/>-group-<xsl:value-of select="tree" />-allgroup<xsl:text>&#xa;</xsl:text>
				<xsl:text>a:name=</xsl:text><xsl:value-of select="$system"/>^<xsl:value-of select="volume"/>-group-<xsl:value-of select="tree" />-allgroup<xsl:text>&#xa;</xsl:text>
				<xsl:text>a:groupId=allgroup</xsl:text><xsl:text>&#xa;</xsl:text>
				<xsl:text>a:type=</xsl:text><xsl:value-of select="quota-type"/><xsl:text>&#xa;</xsl:text>
				<xsl:text>a:fileLimit=</xsl:text><xsl:value-of select="file-limit"/><xsl:text>&#xa;</xsl:text>
				<xsl:text>a:fileUsed=</xsl:text><xsl:value-of select="files-used"/><xsl:text>&#xa;</xsl:text>
				<xsl:text>a:diskLimit=</xsl:text><xsl:value-of select="disk-limit"/><xsl:text>&#xa;</xsl:text>
				<xsl:text>a:diskUsed=</xsl:text><xsl:value-of select="disk-used"/><xsl:text>&#xa;</xsl:text>
				<xsl:text>a:qtree=</xsl:text><xsl:value-of select="tree"/><xsl:text>&#xa;</xsl:text>
				<xsl:text>r:naVolume#</xsl:text><xsl:value-of select="$system" />^<xsl:value-of select="volume"/><xsl:text>&#xa;</xsl:text>
				<xsl:text>r:naQtree#</xsl:text><xsl:value-of select="$system"/>^<xsl:value-of select="volume"/>-<xsl:value-of select="tree"/><xsl:text>&#xa;</xsl:text>
			</xsl:if>

			<xsl:if test="quota-type = 'group' and quota-target = '' and tree = '' and quota-users">
				<xsl:text>R:naQuota#</xsl:text><xsl:value-of select="$system" />^<xsl:value-of select="volume"/>-group-allqtree-<xsl:value-of select="quota-users/quota-user/quota-user-id" /><xsl:text>&#xa;</xsl:text>
				<xsl:text>a:name=</xsl:text><xsl:value-of select="$system"/>^<xsl:value-of select="volume"/>-group-allqtree-<xsl:value-of select="quota-users/quota-user/quota-user-id" /><xsl:text>&#xa;</xsl:text>
				<xsl:text>a:groupId=</xsl:text><xsl:value-of select="quota-users/quota-user/quota-user-id"/><xsl:text>&#xa;</xsl:text>
				<xsl:text>a:type=</xsl:text><xsl:value-of select="quota-type"/><xsl:text>&#xa;</xsl:text>
				<xsl:text>a:fileLimit=</xsl:text><xsl:value-of select="file-limit"/><xsl:text>&#xa;</xsl:text>
				<xsl:text>a:fileUsed=</xsl:text><xsl:value-of select="files-used"/><xsl:text>&#xa;</xsl:text>
				<xsl:text>a:diskLimit=</xsl:text><xsl:value-of select="disk-limit"/><xsl:text>&#xa;</xsl:text>
				<xsl:text>a:diskUsed=</xsl:text><xsl:value-of select="disk-used"/><xsl:text>&#xa;</xsl:text>
				<xsl:text>a:qtree=allqtree</xsl:text><xsl:text>&#xa;</xsl:text>
				<xsl:text>r:naVolume#</xsl:text><xsl:value-of select="$system" />^<xsl:value-of select="volume"/><xsl:text>&#xa;</xsl:text>
				<xsl:text>r:</xsl:text><xsl:value-of select="$qtreeList"/><xsl:text>&#xa;</xsl:text>
			</xsl:if>

			<xsl:if test="quota-type = 'group' and quota-target = '' and tree != '' and quota-users">
				<xsl:text>R:naQuota#</xsl:text><xsl:value-of select="$system" />^<xsl:value-of select="volume"/>-group-<xsl:value-of select="tree"/>-<xsl:value-of select="quota-users/quota-user/quota-user-id" /><xsl:text>&#xa;</xsl:text>
				<xsl:text>a:name=</xsl:text><xsl:value-of select="$system"/>^<xsl:value-of select="volume"/>-group-<xsl:value-of select="tree"/>-<xsl:value-of select="quota-users/quota-user/quota-user-id" /><xsl:text>&#xa;</xsl:text>
				<xsl:text>a:groupId=</xsl:text><xsl:value-of select="quota-users/quota-user/quota-user-id"/><xsl:text>&#xa;</xsl:text>
				<xsl:text>a:type=</xsl:text><xsl:value-of select="quota-type"/><xsl:text>&#xa;</xsl:text>
				<xsl:text>a:fileLimit=</xsl:text><xsl:value-of select="file-limit"/><xsl:text>&#xa;</xsl:text>
				<xsl:text>a:fileUsed=</xsl:text><xsl:value-of select="files-used"/><xsl:text>&#xa;</xsl:text>
				<xsl:text>a:diskLimit=</xsl:text><xsl:value-of select="disk-limit"/><xsl:text>&#xa;</xsl:text>
				<xsl:text>a:diskUsed=</xsl:text><xsl:value-of select="disk-used"/><xsl:text>&#xa;</xsl:text>
				<xsl:text>a:qtree=</xsl:text><xsl:value-of select="tree"/><xsl:text>&#xa;</xsl:text>
				<xsl:text>r:naVolume#</xsl:text><xsl:value-of select="$system" />^<xsl:value-of select="volume"/><xsl:text>&#xa;</xsl:text>
				<xsl:text>r:naQtree#</xsl:text><xsl:value-of select="$system"/>^<xsl:value-of select="volume"/>-<xsl:value-of select="tree"/><xsl:text>&#xa;</xsl:text>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>

</xsl:stylesheet>
