<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="text"/>
	<xsl:param name="system" select="NoName"/>

	<xsl:template match="interface-config-info" xml:space="default">
		<xsl:for-each select="interface-config-info">
			<xsl:text>R:naIfnet#</xsl:text><xsl:value-of select="$system"/>^<xsl:value-of select="interface-name"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:name=</xsl:text><xsl:value-of select="$system"/>^<xsl:value-of select="interface-name"/><xsl:text>&#xa;</xsl:text>

            <xsl:if test="v4-primary-address/ip-address-info/addr-family != ''">
                <xsl:text>a:ipv4PrimAddrFamily=</xsl:text><xsl:value-of select="v4-primary-address/ip-address-info/addr-family"/><xsl:text>&#xa;</xsl:text>
                <xsl:text>a:ipv4PrimAddress=</xsl:text><xsl:value-of select="v4-primary-address/ip-address-info/address"/><xsl:text>&#xa;</xsl:text>
                <xsl:text>a:ipv4PrimNetmask=</xsl:text><xsl:value-of select="v4-primary-address/ip-address-info/netmask-or-prefix"/><xsl:text>&#xa;</xsl:text>
                <xsl:text>a:ipv4PrimBroadcast=</xsl:text><xsl:value-of select="v4-primary-address/ip-address-info/broadcast"/><xsl:text>&#xa;</xsl:text>
                <xsl:text>a:ipv4PrimCreator=</xsl:text><xsl:value-of select="v4-primary-address/ip-address-info/creator"/><xsl:text>&#xa;</xsl:text>
            </xsl:if>

            <xsl:if test="v6-primary-address/ip-address-info/addr-family != ''">
                <xsl:text>a:ipv6PrimAddrFamily=</xsl:text><xsl:value-of select="v6-primary-address/ip-address-info/addr-family"/><xsl:text>&#xa;</xsl:text>
                <xsl:text>a:ipv6PrimAddress=</xsl:text><xsl:value-of select="v6-primary-address/ip-address-info/address"/><xsl:text>&#xa;</xsl:text>
                <xsl:text>a:ipv6PrimNetmask=</xsl:text><xsl:value-of select="v6-primary-address/ip-address-info/netmask-or-prefix"/><xsl:text>&#xa;</xsl:text>
                <xsl:text>a:ipv6PrimBroadcast=</xsl:text><xsl:value-of select="v6-primary-address/ip-address-info/broadcast"/><xsl:text>&#xa;</xsl:text>
                <xsl:text>a:ipv6PrimCreator=</xsl:text><xsl:value-of select="v6-primary-address/ip-address-info/creator"/><xsl:text>&#xa;</xsl:text>
            </xsl:if>
			
			<xsl:text>a:aliasAddrFamily=</xsl:text><xsl:value-of select="aliases/ip-address-info/addr-family"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:aliasAddress=</xsl:text><xsl:value-of select="aliases/ip-address-info/address"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:aliasNetmask=</xsl:text><xsl:value-of select="aliases/ip-address-info/netmask"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:aliasBroadcast=</xsl:text><xsl:value-of select="aliases/ip-address-info/broadcast"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:aliasCreator=</xsl:text><xsl:value-of select="aliases/ip-address-info/creator"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:macAddr=</xsl:text><xsl:value-of select="mac-address"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:mtuSize=</xsl:text><xsl:value-of select="mtusize"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:flowControl=</xsl:text><xsl:value-of select="flowcontrol"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:isTrusted=</xsl:text><xsl:value-of select="is-trusted"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:isWinsEnabled=</xsl:text><xsl:value-of select="is-wins-enabled"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:isNfoEnabled=</xsl:text><xsl:value-of select="is-nfo-enabled"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:isEnabled=</xsl:text><xsl:value-of select="is-enabled"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>r:naSystem#</xsl:text><xsl:value-of select="$system"/><xsl:text>&#xa;</xsl:text>
		</xsl:for-each>
	</xsl:template>

</xsl:stylesheet>
