<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="text"/>
	<xsl:param name="system" select="NoName"/>

	<xsl:template match="/" xml:space="default">
		<xsl:for-each select="results/iscsi-session-list-entries/iscsi-session-list-entry-info">
			<xsl:text>R:naIscsiInitiator#</xsl:text><xsl:value-of select="$system"/>^<xsl:value-of select="initiator-nodename"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:name=</xsl:text><xsl:value-of select="$system"/>^<xsl:value-of select="initiator-nodename"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:sessionId=</xsl:text><xsl:value-of select="isid"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:maxConnection=</xsl:text><xsl:value-of select="max-connections"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:initiatorIp=</xsl:text><xsl:value-of select="iscsi-session-connection-list-entries/iscsi-session-connection-list-entry-info/remote-ip-address"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:initiatorPort=</xsl:text><xsl:value-of select="iscsi-session-connection-list-entries/iscsi-session-connection-list-entry-info/remote-ip-port"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:filerIp=</xsl:text><xsl:value-of select="iscsi-session-connection-list-entries/iscsi-session-connection-list-entry-info/local-ip-address"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:filerPort=</xsl:text><xsl:value-of select="iscsi-session-connection-list-entries/iscsi-session-connection-list-entry-info/local-ip-port"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:authentication=</xsl:text><xsl:value-of select="iscsi-session-connection-list-entries/iscsi-session-connection-list-entry-info/authentication-method"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:interfaceName=</xsl:text><xsl:value-of select="iscsi-session-connection-list-entries/iscsi-session-connection-list-entry-info/interface-name"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>r:naSystem#</xsl:text><xsl:value-of select="$system"/><xsl:text>&#xa;</xsl:text>
		</xsl:for-each>
	</xsl:template>

</xsl:stylesheet>
