<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:accessMap="xalan://java.util.HashMap">
	<xsl:output method="text"/>
	<xsl:param name="system" select="NoName"/>
	<xsl:param name="typeList" select="NoName"/>
	<xsl:param name="initiatorList" select="NoName"/>
    <xsl:param name="volumeAndAggregateHash" select="NoName"/>
    <xsl:param name="qtreeAndAggregateHash" select="NoName"/>

	<xsl:template match="/" xml:space="default">
		<xsl:for-each select="results/luns/lun-info">
			<xsl:text>R:naLun#</xsl:text><xsl:value-of select="serial-number"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>O:naLun#</xsl:text><xsl:value-of select="$system"/>^<xsl:value-of select="path"/>-<xsl:value-of select="serial-number"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:name=</xsl:text><xsl:value-of select="$system"/>^<xsl:value-of select="path"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:path=</xsl:text><xsl:value-of select="path"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:type=</xsl:text><xsl:value-of select="$typeList"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:onlineStatus=</xsl:text><xsl:value-of select="online"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:uuid=</xsl:text><xsl:value-of select="uuid"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:serialNumber=</xsl:text><xsl:value-of select="serial-number"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:blockSize=</xsl:text><xsl:value-of select="block-size"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:protocolType=</xsl:text><xsl:value-of select="multiprotocol-type"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:size=</xsl:text><xsl:value-of select="size"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:usedSize=</xsl:text><xsl:value-of select="size-used"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:initiator=</xsl:text><xsl:value-of select="$initiatorList"/><xsl:text>&#xa;</xsl:text>

            <xsl:variable name="count" select="string-length(path) - string-length(translate(path, '/', ''))"/>
            <xsl:variable name="volume" select="substring-before(substring-after(path, '/vol/'), '/')"/>

            <xsl:choose>
             <xsl:when test="$count = '4'">
                <xsl:variable name="qtree" select="concat($volume, '-', substring-before(substring-after(path, concat('/vol/', $volume,'/')), '/'))"/>
                <xsl:text>r:naQtree#</xsl:text><xsl:value-of select="$system"/>^<xsl:value-of select="$qtree"/><xsl:text>&#xa;</xsl:text>
                <xsl:value-of select="accessMap:get($qtreeAndAggregateHash, $qtree)"/><xsl:text>&#xa;</xsl:text>
             </xsl:when>
             <xsl:otherwise>
                <xsl:text>r:naVolume#</xsl:text><xsl:value-of select="$system"/>^<xsl:value-of select="$volume"/><xsl:text>&#xa;</xsl:text>
                <xsl:value-of select="accessMap:get($volumeAndAggregateHash, $volume)"/><xsl:text>&#xa;</xsl:text>
             </xsl:otherwise>
            </xsl:choose>

			<xsl:text>r:naSystem#</xsl:text><xsl:value-of select="$system"/><xsl:text>&#xa;</xsl:text>
		</xsl:for-each>
	</xsl:template>

</xsl:stylesheet>
