<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"> <xsl:output method="text"/>
	<xsl:param name="system" select="NoName"/>
	<xsl:param name="vfiler" select="NoName"/>

	<xsl:template match="exports-rule-info" xml:space="default">
		<xsl:text>R:naNfsShare#</xsl:text><xsl:value-of select="$system"/>^<xsl:value-of select="pathname"/><xsl:text>&#xa;</xsl:text>
		<xsl:text>a:name=</xsl:text><xsl:value-of select="$system"/>^<xsl:value-of select="pathname"/><xsl:text>&#xa;</xsl:text>
		<xsl:text>a:actualPathName=</xsl:text><xsl:value-of select="actual-pathname"/><xsl:text>&#xa;</xsl:text>
		<xsl:if test="read-write/exports-hostname-info/all-hosts">
			<xsl:text>a:readWriteAccess=all</xsl:text><xsl:text>&#xa;</xsl:text>
		</xsl:if>

		<xsl:if test="read-write/exports-hostname-info/name">
			<xsl:text>a:readWriteAccess=</xsl:text>
			<xsl:for-each select="read-write/exports-hostname-info/name">
				<xsl:value-of select="."/>
				<xsl:if test="position() != last()">
					<xsl:text>,</xsl:text>
				</xsl:if>
				<xsl:if test="position() = last()">
					<xsl:text>&#xa;</xsl:text>
				</xsl:if>
			</xsl:for-each>
		</xsl:if>

		<xsl:if test="read-only/exports-hostname-info/all-hosts">
			<xsl:text>a:readOnlyAccess=all</xsl:text><xsl:text>&#xa;</xsl:text>
		</xsl:if>

		<xsl:if test="read-only/exports-hostname-info/name">
			<xsl:text>a:readOnlyAccess=</xsl:text>
			<xsl:for-each select="read-only/exports-hostname-info/name">
				<xsl:value-of select="."/>
				<xsl:if test="position() != last()">
					<xsl:text>,</xsl:text>
				</xsl:if>
				<xsl:if test="position() = last()">
					<xsl:text>&#xa;</xsl:text>
				</xsl:if>
			</xsl:for-each>
		</xsl:if>

		<xsl:if test="root/exports-hostname-info/name">
			<xsl:text>a:root=</xsl:text>
			<xsl:for-each select="root/exports-hostname-info/name">
				<xsl:value-of select="."/>
				<xsl:if test="position() != last()">
					<xsl:text>,</xsl:text>
				</xsl:if>
				<xsl:if test="position() = last()">
					<xsl:text>&#xa;</xsl:text>
				</xsl:if>
			</xsl:for-each>
		</xsl:if>

		<xsl:text>r:naVFiler#</xsl:text><xsl:value-of select="$system"/>^<xsl:value-of select="$vfiler"/><xsl:text>&#xa;</xsl:text>
	</xsl:template>
</xsl:stylesheet>
