<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:accessMap="xalan://java.util.HashMap"><xsl:output method="text"/>
    <xsl:param name="system" select="NoName"/>
    <xsl:param name="storageIp" select="NoName"/>
    <xsl:param name="volumeAndAggregateHash" select="NoName"/>
    <xsl:param name="qtreeAndAggregateHash" select="NoName"/>

    <xsl:template match="exports-rule-info" xml:space="default">
        <xsl:choose>
             <xsl:when test="actual-pathname != ''" >
                <xsl:text>R:nfsShare#</xsl:text><xsl:value-of select="$storageIp"/>:<xsl:value-of select="actual-pathname"/><xsl:text>&#xa;</xsl:text>
                <xsl:text>a:name=</xsl:text><xsl:value-of select="$storageIp"/>:<xsl:value-of select="actual-pathname"/><xsl:text>&#xa;</xsl:text>
            </xsl:when>
             <xsl:otherwise>
                <xsl:text>R:nfsShare#</xsl:text><xsl:value-of select="$storageIp"/>:<xsl:value-of select="pathname"/><xsl:text>&#xa;</xsl:text>
                <xsl:text>a:name=</xsl:text><xsl:value-of select="$storageIp"/>:<xsl:value-of select="pathname"/><xsl:text>&#xa;</xsl:text>
             </xsl:otherwise>
        </xsl:choose>

        <xsl:text>a:actualPathName=</xsl:text><xsl:value-of select="actual-pathname"/><xsl:text>&#xa;</xsl:text>
        <xsl:text>a:storageType=NetApp</xsl:text><xsl:text>&#xa;</xsl:text>

        <xsl:if test="read-write/exports-hostname-info/all-hosts">
            <xsl:text>a:readWriteAccess=all</xsl:text><xsl:text>&#xa;</xsl:text>
        </xsl:if>

        <xsl:if test="read-write/exports-hostname-info/name">
            <xsl:text>a:readWriteAccess=</xsl:text>
            <xsl:for-each select="read-write/exports-hostname-info/name">
                <xsl:value-of select="."/>
                <xsl:if test="position() != last()">
                    <xsl:text>,</xsl:text>
                </xsl:if>
                <xsl:if test="position() = last()">
                    <xsl:text>&#xa;</xsl:text>
                </xsl:if>
            </xsl:for-each>
        </xsl:if>

        <xsl:if test="read-only/exports-hostname-info/all-hosts">
            <xsl:text>a:readOnlyAccess=all</xsl:text><xsl:text>&#xa;</xsl:text>
        </xsl:if>

        <xsl:if test="read-only/exports-hostname-info/name">
            <xsl:text>a:readOnlyAccess=</xsl:text>
            <xsl:for-each select="read-only/exports-hostname-info/name">
                <xsl:value-of select="."/>
                <xsl:if test="position() != last()">
                    <xsl:text>,</xsl:text>
                </xsl:if>
                <xsl:if test="position() = last()">
                    <xsl:text>&#xa;</xsl:text>
                </xsl:if>
            </xsl:for-each>
        </xsl:if>

        <xsl:if test="root/exports-hostname-info/name">
            <xsl:text>a:root=</xsl:text>
            <xsl:for-each select="root/exports-hostname-info/name">
                <xsl:value-of select="."/>
                <xsl:if test="position() != last()">
                    <xsl:text>,</xsl:text>
                </xsl:if>
                <xsl:if test="position() = last()">
                    <xsl:text>&#xa;</xsl:text>
                </xsl:if>
            </xsl:for-each>
        </xsl:if>

        <xsl:choose>
            <xsl:when test="actual-pathname != ''" >
                <xsl:variable name="count" select="string-length(actual-pathname) - string-length(translate(actual-pathname, '/', ''))"/>
                <xsl:choose>
                    <xsl:when test="$count = '3'">
                        <xsl:variable name="volume" select="substring-before(substring-after(actual-pathname, '/vol/'), '/')"/>
                        <xsl:variable name="qtree" select="concat($volume,'-', substring-after(actual-pathname, concat('/vol/', $volume,'/')))"/>
                        <xsl:text>r:naQtree#</xsl:text><xsl:value-of select="$system"/>^<xsl:value-of select="$qtree"/><xsl:text>&#xa;</xsl:text>
                        <xsl:value-of select="accessMap:get($qtreeAndAggregateHash, $qtree)"/><xsl:text>&#xa;</xsl:text>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:variable name="volume" select="substring-after(actual-pathname, '/vol/')"/>
                        <xsl:text>r:naVolume#</xsl:text><xsl:value-of select="$system"/>^<xsl:value-of select="$volume"/><xsl:text>&#xa;</xsl:text>
                        <xsl:value-of select="accessMap:get($volumeAndAggregateHash, $volume)"/><xsl:text>&#xa;</xsl:text>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:otherwise>
                <xsl:variable name="count" select="string-length(pathname) - string-length(translate(pathname, '/', ''))"/>
                <xsl:choose>
                    <xsl:when test="$count = '3'">
                        <xsl:variable name="volume" select="substring-before(substring-after(pathname, '/vol/'), '/')"/>
                        <xsl:variable name="qtree" select="concat($volume,'-', substring-after(pathname, concat('/vol/', $volume,'/')))"/>
                        <xsl:text>r:naQtree#</xsl:text><xsl:value-of select="$system"/>^<xsl:value-of select="$qtree"/><xsl:text>&#xa;</xsl:text>
                        <xsl:value-of select="accessMap:get($qtreeAndAggregateHash, $qtree)"/><xsl:text>&#xa;</xsl:text>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:variable name="volume" select="substring-after(pathname, '/vol/')"/>
                        <xsl:text>r:naVolume#</xsl:text><xsl:value-of select="$system"/>^<xsl:value-of select="$volume"/><xsl:text>&#xa;</xsl:text>
                        <xsl:value-of select="accessMap:get($volumeAndAggregateHash, $volume)"/><xsl:text>&#xa;</xsl:text>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
</xsl:stylesheet>
