<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="text"/>
	<xsl:param name="system" select="NoName"/>

	<xsl:template match="/" xml:space="default">
		<xsl:for-each select="results/qtrees/qtree-info">
			<xsl:if test="qtree != ''">
				<xsl:text>qtreeInfo=</xsl:text>
				<xsl:if test="volume != ''"><xsl:value-of select="volume"/>/</xsl:if>
				<xsl:if test="volume = '' or not(volume)">notFound/</xsl:if>
				<xsl:if test="qtree != ''"><xsl:value-of select="qtree"/>/</xsl:if>
				<xsl:if test="qtree = '' or not(qtree)">notFound/</xsl:if>
				<xsl:if test="status != ''"><xsl:value-of select="status"/>/</xsl:if>
				<xsl:if test="status = '' or not(status)">notFound/</xsl:if>
				<xsl:if test="security-style != ''"><xsl:value-of select="security-style"/>/</xsl:if>
				<xsl:if test="security-style = '' or not(security-style)">notFound/</xsl:if>
				<xsl:if test="oplocks != ''"><xsl:value-of select="oplocks"/></xsl:if>
				<xsl:if test="oplocks = '' or not(oplocks)">notFound</xsl:if>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>

</xsl:stylesheet>
