<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="text"/>
	<xsl:param name="system" select="NoName"/>
	<xsl:param name="schedule" select="NoName"/>
	<xsl:param name="isList" select="NoName"/>

	<xsl:template match="/" xml:space="default">
		<xsl:for-each select="results/snapmirror-status/snapmirror-status-info">
			<xsl:if test="$isList = 'true'">
				<xsl:text>destinationLocation=</xsl:text><xsl:value-of select="destination-location"/>
			</xsl:if>

			<xsl:if test="$isList = 'false'">
				<xsl:text>R:naSnapMirror#</xsl:text><xsl:value-of select="$system"/>^<xsl:value-of select="source-location"/><xsl:text>&#xa;</xsl:text>
				<xsl:text>a:name=</xsl:text><xsl:value-of select="$system"/>^<xsl:value-of select="source-location"/><xsl:text>&#xa;</xsl:text>
				<xsl:text>a:sourceLocation=</xsl:text><xsl:value-of select="source-location"/><xsl:text>&#xa;</xsl:text>
				<xsl:text>a:destinationLocation=</xsl:text><xsl:value-of select="destination-location"/><xsl:text>&#xa;</xsl:text>
				<xsl:text>a:lagTime=</xsl:text><xsl:value-of select="lag-time"/><xsl:text>&#xa;</xsl:text>
				<xsl:text>a:mirrorTimeStamp=</xsl:text><xsl:value-of select="mirror-timestamp"/><xsl:text>&#xa;</xsl:text>
				<xsl:text>a:contents=</xsl:text><xsl:value-of select="contents"/><xsl:text>&#xa;</xsl:text>
				<xsl:text>a:status=</xsl:text><xsl:value-of select="status"/><xsl:text>&#xa;</xsl:text>
				<xsl:text>a:state=</xsl:text><xsl:value-of select="state"/><xsl:text>&#xa;</xsl:text>
				<xsl:text>a:baseSnapshot=</xsl:text><xsl:value-of select="base-snapshot"/><xsl:text>&#xa;</xsl:text>
				<xsl:text>a:lastTransferSize=</xsl:text><xsl:value-of select="last-transfer-size"/><xsl:text>&#xa;</xsl:text>
				<xsl:text>a:lastTransferDuration=</xsl:text><xsl:value-of select="last-transfer-duration"/><xsl:text>&#xa;</xsl:text>
				<xsl:text>a:schedule=</xsl:text><xsl:value-of select="$schedule"/><xsl:text>&#xa;</xsl:text>
				<xsl:text>r:naSystem#</xsl:text><xsl:value-of select="$system"/><xsl:text>&#xa;</xsl:text>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
</xsl:stylesheet>
