<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="text"/>
	<xsl:param name="system" select="NoName"/>
	<xsl:param name="schedule" select="NoName"/>
	<xsl:param name="retention" select="NoName"/>

	<xsl:template match="/" xml:space="default">
		<xsl:for-each select="results/status/snapvault-status-info">
			<xsl:text>R:naSnapVault#</xsl:text><xsl:value-of select="$system"/>^<xsl:value-of select="source-path"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:name=</xsl:text><xsl:value-of select="$system"/>^<xsl:value-of select="source-path"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:snapshotName=</xsl:text><xsl:value-of select="base-snapshot"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:sourceLocation=</xsl:text><xsl:value-of select="source-system"/>:<xsl:value-of select="source-path"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:destinationLocation=</xsl:text><xsl:value-of select="destination-system"/>:<xsl:value-of select="destination-path"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:lagTime=</xsl:text><xsl:value-of select="lag-time"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:status=</xsl:text><xsl:value-of select="status"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:state=</xsl:text><xsl:value-of select="state"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:schedule=</xsl:text><xsl:value-of select="$schedule"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:retention=</xsl:text><xsl:value-of select="$retention"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>r:naSystem#</xsl:text><xsl:value-of select="$system"/><xsl:text>&#xa;</xsl:text>
		</xsl:for-each>
	</xsl:template>

</xsl:stylesheet>
