<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="text"/>
	<xsl:param name="system" select="NoName"/>
	<xsl:param name="volume" select="NoName"/>

	<xsl:template match="/" xml:space="default">
		<xsl:for-each select="results/snapshots/snapshot-info">
			<xsl:text>R:naSnapshot#</xsl:text><xsl:value-of select="$system"/>^<xsl:value-of select="$volume"/>-<xsl:value-of select="name"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:name=</xsl:text><xsl:value-of select="$system"/>^<xsl:value-of select="$volume"/>-<xsl:value-of select="name"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:usedBlockCumuPct=</xsl:text><xsl:value-of select="cumulative-percentage-of-used-blocks"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:usedBlockPct=</xsl:text><xsl:value-of select="percentage-of-used-blocks"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:totalBlockCumuPct=</xsl:text><xsl:value-of select="cumulative-percentage-of-total-blocks"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:totalBlockPct=</xsl:text><xsl:value-of select="percentage-of-total-blocks"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:accessTime=</xsl:text><xsl:value-of select="access-time"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:blockCount=</xsl:text><xsl:value-of select="total"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>r:naVolume#</xsl:text><xsl:value-of select="$system"/>^<xsl:value-of select="$volume"/><xsl:text>&#xa;</xsl:text>
		</xsl:for-each>
	</xsl:template>

</xsl:stylesheet>
