<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="text"/>
	<xsl:param name="system" select="NoName"/>
	<xsl:param name="step" select="NoName"/>
	<xsl:param name="noOfFile" select="NoName"/>

	<xsl:template match="vfiler-info" xml:space="default">
		<xsl:if test="$step = 'pre'">
			<xsl:text>R:naVFiler#</xsl:text><xsl:value-of select="$system"/>^<xsl:value-of select="name"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:name=</xsl:text><xsl:value-of select="$system"/>^<xsl:value-of select="name"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:ipSpace=</xsl:text><xsl:value-of select="ipspace"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:uuid=</xsl:text><xsl:value-of select="uuid"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:vStorePath=</xsl:text><xsl:value-of select="vfstores/vfstore-info/path"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:vStoreStatus=</xsl:text><xsl:value-of select="vfstores/vfstore-info/status"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:vStoreIsEtc=</xsl:text><xsl:value-of select="vfstores/vfstore-info/is-etc"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:adminHost=</xsl:text><xsl:value-of select="admin-host"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:fileCount=</xsl:text><xsl:value-of select="$noOfFile"/><xsl:text>&#xa;</xsl:text>
			
			<xsl:for-each select="vfnets/vfnet-info">
				<xsl:if test="position() = 1">
				<xsl:text>a:ipAddress=</xsl:text>
				</xsl:if>

				<xsl:value-of select="ipaddress"/>

				<xsl:if test="position() != last()">
					<xsl:text>,</xsl:text>
				</xsl:if>

				<xsl:if test="position() = last()">
					<xsl:text>&#xa;</xsl:text>
				</xsl:if>
			</xsl:for-each>

		</xsl:if>

		<xsl:if test="$step = 'post'">
			<xsl:text>r:naSystem#</xsl:text><xsl:value-of select="$system"/><xsl:text>&#xa;</xsl:text>
		</xsl:if>
	</xsl:template>

</xsl:stylesheet>
