<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="text"/>
	<xsl:param name="system" select="NoName"/>
	<xsl:param name="isRootVolume" select="NoName"/>
	<xsl:param name="type" select="NoName"/>

	<xsl:template match="volume-info" xml:space="default">
		<xsl:if test="$type = 'pre'">
			<xsl:text>R:naVolume#</xsl:text><xsl:value-of select="$system"/>^<xsl:value-of select="name"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:name=</xsl:text><xsl:value-of select="$system"/>^<xsl:value-of select="name"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:uuid=</xsl:text><xsl:value-of select="uuid"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:type=</xsl:text><xsl:value-of select="type"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:raidSize=</xsl:text><xsl:value-of select="raid-size"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:raidStatus=</xsl:text><xsl:value-of select="raid-status"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:capacity=</xsl:text><xsl:value-of select="size-total"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:usedCapacity=</xsl:text><xsl:value-of select="size-used"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:freeCapacity=</xsl:text><xsl:value-of select="size-available"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:state=</xsl:text><xsl:value-of select="state"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:sisState=</xsl:text><xsl:value-of select="sis/sis-info/state"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:sisStatus=</xsl:text><xsl:value-of select="sis/sis-info/status"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:sisType=</xsl:text><xsl:value-of select="sis/sis-info/type"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:sisLastOpBeginTimestamp=</xsl:text><xsl:value-of select="sis/sis-info/last-operation-begin"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:sisLastOpEndTimestamp=</xsl:text><xsl:value-of select="sis/sis-info/last-operation-end"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:sisLastOpSize=</xsl:text><xsl:value-of select="sis/sis-info/last-operation-size"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:sisSchedule=</xsl:text><xsl:value-of select="sis/sis-info/schedule"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:isRootVolume=</xsl:text><xsl:value-of select="$isRootVolume"/><xsl:text>&#xa;</xsl:text>

			<xsl:if test="quota-init != '0'">
				<xsl:text>a:quotaStatus=on</xsl:text><xsl:text>&#xa;</xsl:text>
			</xsl:if>

			<xsl:if test="quota-init = '0'">
				<xsl:text>a:quotaStatus=off</xsl:text><xsl:text>&#xa;</xsl:text>
			</xsl:if>

			<xsl:if test="remote-location != ''">
				<xsl:text>a:cacheRemoteLocation=</xsl:text><xsl:value-of select="remote-location"/><xsl:text>&#xa;</xsl:text>
			</xsl:if>

			<xsl:if test="clone-parent/clone-parent-info/parent-volume-name != ''">
				<xsl:text>a:cloneParentVolumeName=</xsl:text><xsl:value-of select="clone-parent/clone-parent-info/parent-volume-name"/><xsl:text>&#xa;</xsl:text>
			</xsl:if>

			<xsl:if test="clone-parent/clone-parent-info/parent-snapshot-name != ''">
				<xsl:text>a:cloneParentSnapshotName=</xsl:text><xsl:value-of select="clone-parent/clone-parent-info/parent-snapshot-name"/><xsl:text>&#xa;</xsl:text>
			</xsl:if>
		</xsl:if>

		<xsl:if test="$type = 'post'">
			<xsl:if test="type = 'trad'">
				<xsl:text>r:naAggregate#</xsl:text><xsl:value-of select="$system"/>^<xsl:value-of select="name"/><xsl:text>&#xa;</xsl:text>
			</xsl:if>

			<xsl:if test="type = 'flex'">
				<xsl:text>r:naAggregate#</xsl:text><xsl:value-of select="$system"/>^<xsl:value-of select="containing-aggregate"/><xsl:text>&#xa;</xsl:text>
			</xsl:if>

		</xsl:if>
	</xsl:template>

</xsl:stylesheet>
