<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="text"/>
	<xsl:param name="system" select="NoName"/>
    <xsl:param name="version" select="NoName"/>

	<xsl:template match="attributes-list/aggr-attributes" xml:space="default">
        <xsl:choose>
            <xsl:when test="contains($version,'8.2andlower')">
		<xsl:text>R:naAggregate#</xsl:text><xsl:value-of select="$system"/>^<xsl:value-of select="aggr-ownership-attributes/home-name"/>:kernel:<xsl:value-of select="aggregate-name"/><xsl:text>&#xa;</xsl:text>
            </xsl:when>
            <xsl:otherwise>
                <xsl:text>R:naAggregate#</xsl:text><xsl:value-of select="$system"/>^<xsl:value-of select="aggregate-name"/><xsl:text>&#xa;</xsl:text>
            </xsl:otherwise>
        </xsl:choose>
	
		<xsl:text>a:name=</xsl:text><xsl:value-of select="$system"/>^<xsl:value-of select="aggr-ownership-attributes/home-name"/>^<xsl:value-of select="aggregate-name"/><xsl:text>&#xa;</xsl:text>
		<xsl:text>a:node=</xsl:text><xsl:value-of select="aggr-ownership-attributes/home-name"/><xsl:text>&#xa;</xsl:text>
		<xsl:text>a:uuid=</xsl:text><xsl:value-of select="aggregate-uuid"/><xsl:text>&#xa;</xsl:text>
		<xsl:text>a:type=</xsl:text><xsl:value-of select="aggr-fs-attributes/type"/><xsl:text>&#xa;</xsl:text>

        <xsl:choose>
             <xsl:when test="aggr-raid-attributes/state != 'restricted'">
                <xsl:text>a:sizeTotal=</xsl:text><xsl:value-of select="aggr-space-attributes/size-total"/><xsl:text>&#xa;</xsl:text>
                <xsl:text>a:sizeUsed=</xsl:text><xsl:value-of select="aggr-space-attributes/size-used"/><xsl:text>&#xa;</xsl:text>
                <xsl:text>a:sizeAvailable=</xsl:text><xsl:value-of select="aggr-space-attributes/size-available"/><xsl:text>&#xa;</xsl:text>
             </xsl:when>
             <xsl:otherwise>
                <xsl:text>a:sizeTotal=NA</xsl:text><xsl:text>&#xa;</xsl:text>
                <xsl:text>a:sizeUsed=NA</xsl:text><xsl:text>&#xa;</xsl:text>
                <xsl:text>a:sizeAvailable=NA</xsl:text><xsl:text>&#xa;</xsl:text>
             </xsl:otherwise>
        </xsl:choose>

		<xsl:text>a:raidSize=</xsl:text><xsl:value-of select="aggr-raid-attributes/raid-size"/><xsl:text>&#xa;</xsl:text>
		<xsl:text>a:raidStatus=</xsl:text><xsl:value-of select="aggr-raid-attributes/raid-status"/><xsl:text>&#xa;</xsl:text>
		<xsl:text>a:diskCount=</xsl:text><xsl:value-of select="aggr-raid-attributes/disk-count"/><xsl:text>&#xa;</xsl:text>
		<xsl:text>a:volumeCount=</xsl:text><xsl:value-of select="aggr-volume-count-attributes/flexvol-count"/><xsl:text>&#xa;</xsl:text>
		<xsl:text>a:plexCount=</xsl:text><xsl:value-of select="aggr-raid-attributes/plex-count"/><xsl:text>&#xa;</xsl:text>
		<xsl:text>a:state=</xsl:text><xsl:value-of select="aggr-raid-attributes/state"/><xsl:text>&#xa;</xsl:text>
		<xsl:text>a:blockType=</xsl:text><xsl:value-of select="aggr-fs-attributes/block-type"/><xsl:text>&#xa;</xsl:text>

        <xsl:choose>
            <xsl:when test="contains($version,'8.2')">
		<xsl:text>r:naSystem#</xsl:text><xsl:value-of select="$system"/>^<xsl:value-of select="aggr-ownership-attributes/home-name"/>:kernel:system<xsl:text>&#xa;</xsl:text>
            </xsl:when>
            <xsl:otherwise>
                <xsl:text>r:naSystem#</xsl:text><xsl:value-of select="$system"/>^<xsl:value-of select="aggr-ownership-attributes/home-name"/><xsl:text>&#xa;</xsl:text>
            </xsl:otherwise>
        </xsl:choose>	
	</xsl:template>

	<xsl:template match="next-tag" xml:space="default">
	</xsl:template>

	<xsl:template match="num-records" xml:space="default">
	</xsl:template>

</xsl:stylesheet>
