<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="text"/>
	<xsl:param name="system" select="NoName"/>
    <xsl:param name="version" select="NoName"/>

	<xsl:template match="attributes-list/storage-disk-info" xml:space="default">
		<xsl:text>R:naDisk#</xsl:text><xsl:value-of select="$system"/>^<xsl:value-of select="disk-uid"/><xsl:text>&#xa;</xsl:text>
		<xsl:text>a:name=</xsl:text><xsl:value-of select="$system"/>^<xsl:value-of select="disk-name"/><xsl:text>&#xa;</xsl:text>
		<xsl:text>a:uuid=</xsl:text><xsl:value-of select="disk-inventory-info/disk-uid"/><xsl:text>&#xa;</xsl:text>
		<xsl:text>a:type=</xsl:text><xsl:value-of select="disk-inventory-info/disk-type"/><xsl:text>&#xa;</xsl:text>
		<xsl:text>a:physicalSpace=</xsl:text><xsl:value-of select="disk-inventory-info/capacity-sectors*disk-inventory-info/bytes-per-sector"/><xsl:text>&#xa;</xsl:text>
		<xsl:text>a:pool=</xsl:text><xsl:value-of select="disk-ownership-info/pool"/><xsl:text>&#xa;</xsl:text>
		<xsl:text>a:serialNumber=</xsl:text><xsl:value-of select="disk-inventory-info/serial-number"/><xsl:text>&#xa;</xsl:text>
		<xsl:text>a:vendor=</xsl:text><xsl:value-of select="disk-inventory-info/vendor"/><xsl:text>&#xa;</xsl:text>
		<xsl:text>a:model=</xsl:text><xsl:value-of select="disk-inventory-info/model"/><xsl:text>&#xa;</xsl:text>
		<xsl:text>a:raidGroup=</xsl:text><xsl:value-of select="disk-raid-info/disk-aggregate-info/raid-group-name"/><xsl:text>&#xa;</xsl:text>

		<xsl:if test="disk-raid-info/disk-aggregate-info/aggregate-name != ''">
        <xsl:choose>
            <xsl:when test="contains($version,'8.2andlower')">
			<xsl:text>r:naSystem#</xsl:text><xsl:value-of select="$system"/>^<xsl:value-of select="substring-before(disk-name, ':')"/>:kernel:system<xsl:text>&#xa;</xsl:text>
			<xsl:text>r:naAggregate#</xsl:text><xsl:value-of select="$system"/>^<xsl:value-of select="substring-before(disk-name, ':')"/>:kernel:<xsl:value-of select="disk-raid-info/disk-aggregate-info/aggregate-name"/><xsl:text>&#xa;</xsl:text>
            </xsl:when>
            <xsl:otherwise>
                <xsl:text>r:naSystem#</xsl:text><xsl:value-of select="$system"/>^<xsl:value-of select="disk-ownership-info/home-node-name"/><xsl:text>&#xa;</xsl:text>
                <xsl:text>r:naAggregate#</xsl:text><xsl:value-of select="$system"/>^<xsl:value-of select="disk-raid-info/disk-aggregate-info/aggregate-name"/><xsl:text>&#xa;</xsl:text>
            </xsl:otherwise>
        </xsl:choose>
		</xsl:if>

		<xsl:if test="not(disk-raid-info/disk-aggregate-info)">
        <xsl:choose>
            <xsl:when test="contains($version,'8.2andlower')">
			<xsl:text>r:naSystem#</xsl:text><xsl:value-of select="$system"/>^<xsl:value-of select="substring-before(disk-name, ':')"/>:kernel:system<xsl:text>&#xa;</xsl:text>
            </xsl:when>
            <xsl:otherwise>
                <xsl:text>r:naSystem#</xsl:text><xsl:value-of select="$system"/>^<xsl:value-of select="disk-ownership-info/home-node-name"/><xsl:text>&#xa;</xsl:text>
            </xsl:otherwise>
        </xsl:choose>
		</xsl:if>
	</xsl:template>

	<xsl:template match="next-tag" xml:space="default">
	</xsl:template>

	<xsl:template match="num-records" xml:space="default">
	</xsl:template>

</xsl:stylesheet>
