<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="text"/>
	<xsl:param name="system" select="NoName"/>
    <xsl:param name="version" select="NoName"/>

	<xsl:template match="attributes-list/net-interface-info" xml:space="default">
        <xsl:if test="role = 'data'">
            <xsl:choose>
                <xsl:when test="contains($version,'8.2andlower')">
                    <xsl:text>R:naLif#</xsl:text><xsl:value-of select="$system"/>^<xsl:value-of select="vserver"/>:<xsl:value-of select="interface-name"/><xsl:text>&#xa;</xsl:text>
                    <xsl:text>a:name=</xsl:text><xsl:value-of select="$system"/>^<xsl:value-of select="vserver"/>:<xsl:value-of select="interface-name"/><xsl:text>&#xa;</xsl:text>
                </xsl:when>
                <xsl:otherwise>
		<xsl:text>R:naLif#</xsl:text><xsl:value-of select="$system"/>^<xsl:value-of select="interface-name"/><xsl:text>&#xa;</xsl:text>
		<xsl:text>a:name=</xsl:text><xsl:value-of select="$system"/>^<xsl:value-of select="interface-name"/><xsl:text>&#xa;</xsl:text>
                </xsl:otherwise>
            </xsl:choose>
            
		<xsl:text>a:address=</xsl:text><xsl:value-of select="address"/><xsl:text>&#xa;</xsl:text>
		<xsl:text>a:currentNode=</xsl:text><xsl:value-of select="current-node"/><xsl:text>&#xa;</xsl:text>
		<xsl:text>a:currentPort=</xsl:text><xsl:value-of select="current-port"/><xsl:text>&#xa;</xsl:text>
		<xsl:text>a:homeNode=</xsl:text><xsl:value-of select="home-node"/><xsl:text>&#xa;</xsl:text>
		<xsl:text>a:homePort=</xsl:text><xsl:value-of select="home-port"/><xsl:text>&#xa;</xsl:text>
		<xsl:text>a:vserver=</xsl:text><xsl:value-of select="vserver"/><xsl:text>&#xa;</xsl:text>
		<xsl:text>a:role=</xsl:text><xsl:value-of select="role"/><xsl:text>&#xa;</xsl:text>
		<xsl:text>a:uuid=</xsl:text><xsl:value-of select="lif-uuid"/><xsl:text>&#xa;</xsl:text>
		<xsl:text>r:naVserver#</xsl:text><xsl:value-of select="$system"/>^<xsl:value-of select="vserver"/><xsl:text>&#xa;</xsl:text>
        </xsl:if>
	</xsl:template>

	<xsl:template match="next-tag" xml:space="default">
	</xsl:template>

	<xsl:template match="num-records" xml:space="default">
	</xsl:template>

</xsl:stylesheet>
