<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="text"/>
	<xsl:param name="system" select="NoName"/>
	<xsl:param name="vserver" select="NoName"/>
	<xsl:param name="vol" select="NoName"/>
	<xsl:param name="uuid" select="NoName"/>
	<xsl:param name="node" select="NoName"/>

	<xsl:template match="attributes-list/lun-info" xml:space="default">
		<xsl:if test="$vserver = vserver and $vol = volume">
			<xsl:text>R:naLun#</xsl:text><xsl:value-of select="$system"/>^<xsl:value-of select="uuid"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>O:naLun#</xsl:text><xsl:value-of select="$system"/>^<xsl:value-of select="serial-number"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:name=</xsl:text><xsl:value-of select="$system"/>^<xsl:value-of select="vserver"/>^<xsl:value-of select="path"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:path=</xsl:text><xsl:value-of select="path"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:onlineStatus=</xsl:text><xsl:value-of select="online"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:uuid=</xsl:text><xsl:value-of select="uuid"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:serialNumber=</xsl:text><xsl:value-of select="serial-number"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:blockSize=</xsl:text><xsl:value-of select="block-size"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:protocolType=</xsl:text><xsl:value-of select="multiprotocol-type"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:size=</xsl:text><xsl:value-of select="size"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:usedSize=</xsl:text><xsl:value-of select="size-used"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>r:naVolume#</xsl:text><xsl:value-of select="$system"/>^<xsl:value-of select="$uuid"/><xsl:text>&#xa;</xsl:text>
			<xsl:if test="qtree != ''">
				<xsl:text>r:naQtree#</xsl:text><xsl:value-of select="$system"/>^<xsl:value-of select="$node"/>:kernel:<xsl:value-of select="$vol"/>-<xsl:value-of select="qtree"/><xsl:text>&#xa;</xsl:text>
			</xsl:if>	
		</xsl:if>
	</xsl:template>

	<xsl:template match="next-tag" xml:space="default">
	</xsl:template>

	<xsl:template match="num-records" xml:space="default">
	</xsl:template>

</xsl:stylesheet>
