<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="text"/>
	<xsl:param name="system" select="NoName"/>
    <xsl:param name="version" select="NoName"/>

	<xsl:template match="attributes-list/instance-info" xml:space="default">
		<xsl:text>R:naProcessor#</xsl:text><xsl:value-of select="$system"/>^<xsl:value-of select="uuid"/><xsl:text>&#xa;</xsl:text>
		<xsl:text>a:name=</xsl:text><xsl:value-of select="$system"/>^<xsl:value-of select="uuid"/><xsl:text>&#xa;</xsl:text>

        <xsl:choose>
            <xsl:when test="contains($version,'8.2andlower')">
		<xsl:text>r:naSystem#</xsl:text><xsl:value-of select="$system"/>^<xsl:value-of select="substring-before(uuid, ':')"/>:kernel:system<xsl:text>&#xa;</xsl:text>
            </xsl:when>
            <xsl:otherwise>
                <xsl:text>r:naSystem#</xsl:text><xsl:value-of select="$system"/>^<xsl:value-of select="substring-before(uuid, ':')"/><xsl:text>&#xa;</xsl:text>
            </xsl:otherwise>
        </xsl:choose>
	</xsl:template>

	<xsl:template match="next-tag" xml:space="default">
	</xsl:template>

	<xsl:template match="num-records" xml:space="default">
	</xsl:template>

</xsl:stylesheet>
