<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="text"/>
	<xsl:param name="system" select="NoName"/>
	<xsl:param name="node" select="NoName"/>
	<xsl:param name="uuid" select="NoName"/>
	<xsl:param name="qtree" select="NoName"/>	
	<xsl:param name="volume" select="NoName"/>	
	<xsl:param name="vserver" select="NoName"/>		

	<xsl:template match="attributes-list/qtree-info" xml:space="default">
		<xsl:if test="qtree != ''">
			<xsl:if test="$qtree = qtree and $volume = volume and $vserver = vserver">
			<xsl:text>R:naQtree#</xsl:text><xsl:value-of select="$system"/>^<xsl:value-of select="$node"/>:kernel:<xsl:value-of select="volume"/>-<xsl:value-of select="qtree"/><xsl:text>&#xa;</xsl:text>
				<xsl:text>a:name=</xsl:text><xsl:value-of select="$system"/>^<xsl:value-of select="vserver"/>^<xsl:value-of select="volume"/>-<xsl:value-of select="qtree"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:status=</xsl:text><xsl:value-of select="status"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:securityStyle=</xsl:text><xsl:value-of select="security-style"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:opLocks=</xsl:text><xsl:value-of select="oplocks"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>r:naVolume#</xsl:text><xsl:value-of select="$system"/>^<xsl:value-of select="$uuid"/><xsl:text>&#xa;</xsl:text>
			</xsl:if>	
		</xsl:if>
	</xsl:template>

	<xsl:template match="next-tag" xml:space="default">
	</xsl:template>

	<xsl:template match="num-records" xml:space="default">
	</xsl:template>

</xsl:stylesheet>
