<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="text"/>
	<xsl:param name="system" select="NoName"/>
	<xsl:param name="mode" select="NoName"/>
	<xsl:param name="version" select="NoName"/>
    <xsl:param name="managementIp" select="NoName"/>
    <xsl:param name="testVersion" select="NoName"/>

	<xsl:template match="system-info" xml:space="default">
        <xsl:choose>
            <xsl:when test="contains($testVersion,'8.2andlower')">
		<xsl:text>R:naSystem#</xsl:text><xsl:value-of select="$system"/>^<xsl:value-of select="system-name"/>:kernel:system<xsl:text>&#xa;</xsl:text>
            </xsl:when>
            <xsl:otherwise>
                <xsl:text>R:naSystem#</xsl:text><xsl:value-of select="$system"/>^<xsl:value-of select="system-name"/><xsl:text>&#xa;</xsl:text>
            </xsl:otherwise>
        </xsl:choose>

		<xsl:text>a:name=</xsl:text><xsl:value-of select="system-name"/><xsl:text>&#xa;</xsl:text>
		<xsl:text>a:id=</xsl:text><xsl:value-of select="system-id"/><xsl:text>&#xa;</xsl:text>
		<xsl:text>a:model=</xsl:text><xsl:value-of select="system-model"/><xsl:text>&#xa;</xsl:text>
		<xsl:text>a:machineType=</xsl:text><xsl:value-of select="system-machine-type"/><xsl:text>&#xa;</xsl:text>
		<xsl:text>a:vendor=</xsl:text><xsl:value-of select="vendor-id"/><xsl:text>&#xa;</xsl:text>
		<xsl:text>a:mode=</xsl:text><xsl:value-of select="$mode"/><xsl:text>&#xa;</xsl:text>
		<xsl:text>a:version=</xsl:text><xsl:value-of select="$version"/><xsl:text>&#xa;</xsl:text>
		<xsl:text>a:serialNumber=</xsl:text><xsl:value-of select="system-serial-number"/><xsl:text>&#xa;</xsl:text>
		<xsl:text>a:memorySize=</xsl:text><xsl:value-of select="memory-size"/><xsl:text>&#xa;</xsl:text>
		<xsl:text>a:numProcessors=</xsl:text><xsl:value-of select="number-of-processors"/><xsl:text>&#xa;</xsl:text>
		<xsl:text>a:cpuSerialNumber=</xsl:text><xsl:value-of select="cpu-serial-number"/><xsl:text>&#xa;</xsl:text>
		<xsl:text>a:cpuMicroCodeVersion=</xsl:text><xsl:value-of select="cpu-microcode-version"/><xsl:text>&#xa;</xsl:text>
		<xsl:text>a:raidArraySupport=</xsl:text><xsl:value-of select="supports-raid-array"/><xsl:text>&#xa;</xsl:text>
        <xsl:text>a:managementIpAddress=</xsl:text><xsl:value-of select="$managementIp"/><xsl:text>&#xa;</xsl:text>
        <xsl:text>r:naCluster#</xsl:text><xsl:value-of select="$system"/><xsl:text>&#xa;</xsl:text>
	</xsl:template>

	<xsl:template match="next-tag" xml:space="default">
	</xsl:template>

	<xsl:template match="num-records" xml:space="default">
	</xsl:template>

</xsl:stylesheet>
