<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="text"/>
	<xsl:param name="system" select="NoName"/>
	<xsl:param name="vserver" select="NoName"/>
	<xsl:param name="volname" select="NoName"/>
	<xsl:param name="node" select="NoName"/>
    <xsl:param name="version" select="NoName"/>

	<xsl:template match="attributes-list/volume-attributes" xml:space="default">
		<xsl:if test="$vserver = volume-id-attributes/owning-vserver-name and $volname = volume-id-attributes/name">
			<xsl:text>R:naVolume#</xsl:text><xsl:value-of select="$system"/>^<xsl:value-of select="volume-id-attributes/instance-uuid"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:name=</xsl:text><xsl:value-of select="$system"/>^<xsl:value-of select="volume-id-attributes/owning-vserver-name"/>^<xsl:value-of select="volume-id-attributes/name"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:uuid=</xsl:text><xsl:value-of select="volume-id-attributes/uuid"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:type=</xsl:text><xsl:value-of select="volume-id-attributes/type"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:capacity=</xsl:text><xsl:value-of select="volume-space-attributes/size-total"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:usedCapacity=</xsl:text><xsl:value-of select="volume-space-attributes/size-used"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:freeCapacity=</xsl:text><xsl:value-of select="volume-space-attributes/size-available"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:state=</xsl:text><xsl:value-of select="volume-state-attributes/state"/><xsl:text>&#xa;</xsl:text>

            <xsl:choose>
                <xsl:when test="contains($version,'8.2andlower')">
			<xsl:text>r:naAggregate#</xsl:text><xsl:value-of select="$system"/>^<xsl:value-of select="$node"/>:kernel:<xsl:value-of select="volume-id-attributes/containing-aggregate-name"/><xsl:text>&#xa;</xsl:text>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:text>r:naAggregate#</xsl:text><xsl:value-of select="$system"/>^<xsl:value-of select="volume-id-attributes/containing-aggregate-name"/><xsl:text>&#xa;</xsl:text>
                </xsl:otherwise>
            </xsl:choose>
		</xsl:if>
	</xsl:template>

	<xsl:template match="next-tag" xml:space="default">
	</xsl:template>

	<xsl:template match="num-records" xml:space="default">
	</xsl:template>

</xsl:stylesheet>
