<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="text"/>
	<xsl:param name="system" select="NoName"/>
	<xsl:param name="vserver" select="NoName"/>

	<xsl:template match="attributes-list/vserver-info" xml:space="default">
		<xsl:if test="vserver-type = 'data' and $vserver = vserver-name">
			<xsl:text>R:naVserver#</xsl:text><xsl:value-of select="$system"/>^<xsl:value-of select="vserver-name"/><xsl:text>&#xa;</xsl:text>
			<xsl:text>a:name=</xsl:text><xsl:value-of select="$system"/>^<xsl:value-of select="vserver-name"/><xsl:text>&#xa;</xsl:text>
            <xsl:text>a:ipSpace=</xsl:text><xsl:value-of select="ipspace"/><xsl:text>&#xa;</xsl:text>
            <xsl:text>a:maxVolume=</xsl:text><xsl:value-of select="max-volumes"/><xsl:text>&#xa;</xsl:text>
            <xsl:text>a:state=</xsl:text><xsl:value-of select="state"/><xsl:text>&#xa;</xsl:text>
            <xsl:text>a:rootVolume=</xsl:text><xsl:value-of select="root-volume"/><xsl:text>&#xa;</xsl:text>
            <xsl:text>a:quotaPolicy=</xsl:text><xsl:value-of select="quota-policy"/><xsl:text>&#xa;</xsl:text>
            <xsl:text>a:snapshotPolicy=</xsl:text><xsl:value-of select="snapshot-policy"/><xsl:text>&#xa;</xsl:text>

            <xsl:for-each select="allowed-protocols/protocol">
                <xsl:if test="position() = 1">
                    <xsl:text>a:allowedProtocol=</xsl:text>
                </xsl:if>

                <xsl:value-of select="." />

                <xsl:if test="position() != last()">
                    <xsl:text>,</xsl:text>
                </xsl:if>

                <xsl:if test="position() = last()">
                    <xsl:text>&#xa;</xsl:text>
                </xsl:if>
            </xsl:for-each>

            <xsl:text>a:cluster=</xsl:text><xsl:value-of select="$system"/><xsl:text>&#xa;</xsl:text>
            <xsl:text>r:naCluster#</xsl:text><xsl:value-of select="$system"/><xsl:text>&#xa;</xsl:text>
		</xsl:if>
	</xsl:template>

	<xsl:template match="next-tag" xml:space="default">
	</xsl:template>

	<xsl:template match="num-records" xml:space="default">
	</xsl:template>

</xsl:stylesheet>
