/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcmover.cli;

import com.archivas.clienttools.arcutils.api.ArcMoverFactory;
import com.archivas.clienttools.arcutils.config.HCPMoverProperties;
import com.archivas.clienttools.arcutils.profile.AbstractProfileBase;
import com.archivas.clienttools.arcutils.profile.ProfileManager;
import com.archivas.clienttools.arcutils.utils.net.SSLCertChain;
import com.archivas.clienttools.arcutils.utils.net.SSLCertificateCallback;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public abstract class AbstractArcCli {
    public static final String PACKAGE_NAME = AbstractArcCli.class.getPackage().getName();
    public static final String CLASS_FULL_NAME = AbstractArcCli.class.getName();
    public static final String CLASS_NAME = CLASS_FULL_NAME.substring(PACKAGE_NAME.length() + 1);
    public static Logger LOG = Logger.getLogger(CLASS_FULL_NAME);
    public static String NEWLINE = System.getProperty("line.separator");
    public static String LFS = "LFS";
    protected static String INSECURE_OPTION = "insecure";
    public static final int EXIT_CODE_OPTION_PARSE_ERROR = 1;
    public static final int EXIT_CODE_DM_ERROR = 4;
    public static final int EXIT_CODE_DM_FAILED_FILES = 5;
    public static String commandName = "hcpdm";
    private String[] args;
    private int exitCode = 0;
    protected boolean allowInsecureSSL = false;
    protected static Map<String, Integer> cliOrder = new HashMap<String, Integer>();

    protected AbstractArcCli(String[] args) {
        ArcMoverFactory.getInstance();
        this.args = args;
        if (!System.getProperty("os.name").contains("Windows")) {
            commandName = "hcpdm.sh";
        }
    }

    public void initializeProfiles(boolean allowInsecureSSL) {
        ProfileManager.initialize(new ArcCliSSLCertificateCallback(allowInsecureSSL));
        this.allowInsecureSSL = allowInsecureSSL;
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public void setExitCode(int exitCode) {
        this.exitCode = exitCode;
    }

    public void exit() {
        System.exit(this.getExitCode());
    }

    public abstract Options getOptions();

    public abstract String getHelpFooter();

    public abstract String getHelpHeader();

    public abstract String getHelpUsageLine();

    public String helpScreen() {
        StringBuffer usage = new StringBuffer();
        HelpFormatter formatter = new HelpFormatter();
        if (cliOrder != null && cliOrder.size() > 0) {
            formatter.setOptionComparator((Comparator)new OptionComparator());
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        formatter.printHelp(pw, HCPMoverProperties.CLI_WIDTH.getAsInt(), this.getHelpUsageLine(), null, this.getOptions(), 1, 3, null, false);
        usage.append(this.getHelpHeader());
        usage.append(sw.toString());
        usage.append(this.getHelpFooter());
        return usage.toString();
    }

    protected abstract void parseArgs() throws ParseException;

    public abstract void execute(PrintWriter var1, PrintWriter var2) throws Exception;

    public String[] getArgs() {
        return this.args;
    }

    public static String getProfileNameFromCmdLineAndValidateExistance(CommandLine cmdLine, String option) throws ParseException {
        if (!cmdLine.hasOption(option)) {
            throw new ParseException("Missing Option: " + option);
        }
        String value = cmdLine.getOptionValue(option);
        String retval = null;
        if (value != null) {
            retval = AbstractArcCli.validateProfileNameExists(value);
        }
        if (retval == null) {
            throw new ParseException("Invalid " + option + " : " + value);
        }
        return retval;
    }

    public static String validateProfileNameExists(String value) throws ParseException {
        AbstractProfileBase profile;
        if (value.equalsIgnoreCase(LFS)) {
            value = "Local File System";
        }
        if ((profile = ProfileManager.getProfileByName(value)) == null) {
            throw new ParseException("Profile does not exist with name:  " + value);
        }
        return value;
    }

    public static String getProfileNameAndValidateItDoesNotExist(CommandLine cmdLine, String option) throws ParseException {
        if (!cmdLine.hasOption(option)) {
            throw new ParseException("Missing Option: " + option);
        }
        String value = cmdLine.getOptionValue(option);
        String retval = null;
        if (value != null) {
            AbstractProfileBase profile = ProfileManager.getProfileByName(value);
            if (profile == null) {
                retval = value;
            } else {
                throw new ParseException("Profile already exists with name:  " + value);
            }
        }
        if (retval == null) {
            throw new ParseException("Invalid " + option + " : " + value);
        }
        return retval;
    }

    public static Option getInsecureSSLOption() {
        return new Option(null, INSECURE_OPTION, false, "Tells HCP-DM to accept self-signed and mismatched SSL server certificates.");
    }

    public class OptionComparator
    implements Comparator<Option> {
        @Override
        public int compare(Option one, Option two) {
            if (one == two || one.equals((Object)two)) {
                return 0;
            }
            Integer rankOne = cliOrder.get(one.getLongOpt());
            Integer rankTwo = cliOrder.get(two.getLongOpt());
            if (rankOne == null || rankTwo == null) {
                LOG.severe("New options need to be added to the cliOrder list in your cli class.");
                return 0;
            }
            int result = rankOne < rankTwo ? -1 : 1;
            return result;
        }
    }

    class ArcCliSSLCertificateCallback
    implements SSLCertificateCallback {
        private boolean allowInsecureSSL = false;

        ArcCliSSLCertificateCallback(boolean flag) {
            this.allowInsecureSSL = flag;
        }

        @Override
        public void validCertCallback(AbstractProfileBase profile, SSLCertChain certChain) {
            LOG.log(Level.FINE, "validCertCallback for profile " + profile + ": " + certChain);
            profile.setSSLCertChain(certChain);
        }

        @Override
        public SSLCertificateCallback.AllowSSLCert exceptionCallback(AbstractProfileBase profile, SSLCertChain certChain, String warningString) {
            return this.allowInsecureSSL ? SSLCertificateCallback.AllowSSLCert.THIS_SESSION_ONLY : SSLCertificateCallback.AllowSSLCert.NO;
        }
    }
}

