/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcmover.cli;

import com.archivas.clienttools.arcmover.cli.ManagedCLIJob;
import com.archivas.clienttools.arcutils.api.JobException;
import com.archivas.clienttools.arcutils.api.JobId;
import com.archivas.clienttools.arcutils.api.ManagedJobStats;
import com.archivas.clienttools.arcutils.api.jobs.CopyJob;
import com.archivas.clienttools.arcutils.api.jobs.ManagedJob;
import com.archivas.clienttools.arcutils.config.HCPMoverProperties;
import com.archivas.clienttools.arcutils.model.ACLMetadata;
import com.archivas.clienttools.arcutils.model.CustomMetadata;
import com.archivas.clienttools.arcutils.model.FileMetadata;
import com.archivas.clienttools.arcutils.model.LoadSchedule;
import com.archivas.clienttools.arcutils.model.Owner;
import com.archivas.clienttools.arcutils.model.Retention;
import com.archivas.clienttools.arcutils.model.StructuredMetadata;
import com.archivas.clienttools.arcutils.profile.AbstractProfileBase;
import com.archivas.clienttools.arcutils.profile.ProfileManager;
import com.archivas.clienttools.arcutils.profile.ProfileType;
import com.archivas.clienttools.arcutils.utils.FileListParser;
import com.archivas.clienttools.arcutils.utils.FileListParserException;
import com.archivas.clienttools.arcutils.utils.database.DatabaseException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public class ArcCopy
extends ManagedCLIJob {
    public static final String PACKAGE_NAME = ArcCopy.class.getPackage().getName();
    public static final String CLASS_FULL_NAME = ArcCopy.class.getName();
    public static final String CLASS_NAME = CLASS_FULL_NAME.substring(PACKAGE_NAME.length() + 1);
    public static Logger LOG = Logger.getLogger(CLASS_FULL_NAME);
    private static String DESTINATION_PROFILE_OPTION = "destination-profile";
    private static String SOURCE_PROFILE_OPTION = "source-profile";
    private static String DESTINATION_PATH_OPTION = "destination-path";
    private static String SOURCE_PATH_OPTION = "source-path";
    private static String HOLD_OPTION = "hold";
    private static String INDEX_OPTION = "index";
    private static String SHRED_OPTION = "shred";
    private static String RETENTION_OPTION = "retention";
    private static String UID_OPTION = "uid";
    private static String GID_OPTION = "gid";
    private static String FILE_PERMS_OPTION = "file-permissions";
    private static String DIR_PERMS_OPTION = "dir-permissions";
    private static String CUSTOM_METADATA_OPTION = "custom-metadata";
    private static String ACL_OPTION = "acl";
    private static String OWNER_OPTION = "owner";
    private static String DOMAIN_OPTION = "domain";
    private static Options cliOptions;
    private static int cliOptionsCount;

    private static void addNextCLIOption(String option) {
        cliOrder.put(option, cliOptionsCount++);
    }

    public ArcCopy(String[] args, int numCmdLineArgs) {
        super(args, numCmdLineArgs);
        HELP_HEADER = "Copies items from one location to another.  Items to copy are listed in the list_file.\n";
        HELP_USAGE_LINE = commandName + " copy -s <source_profile> -d <destination_profile> --destination-path <destination_path> [options] [list_file]";
    }

    @Override
    public Options getOptions() {
        if (cliOptions == null) {
            Options options = new Options();
            OptionBuilder.withDescription((String)"Displays this help text (the default behavior).");
            OptionBuilder.withLongOpt((String)HELP_OPTION);
            options.addOption(OptionBuilder.create((String)"h"));
            OptionBuilder.withArgName((String)"source_profile");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Source for the copy operation: either a namespace profile name or LFS for the local file system.");
            OptionBuilder.withLongOpt((String)SOURCE_PROFILE_OPTION);
            options.addOption(OptionBuilder.create((String)"s"));
            OptionBuilder.withArgName((String)"destination_profile");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Destination for the copy operation: either a namespace profile name or LFS for the local file system.");
            OptionBuilder.withLongOpt((String)DESTINATION_PROFILE_OPTION);
            options.addOption(OptionBuilder.create((String)"d"));
            OptionBuilder.withArgName((String)"destination_path");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Destination directory path.");
            OptionBuilder.withLongOpt((String)DESTINATION_PATH_OPTION);
            options.addOption(OptionBuilder.create());
            OptionBuilder.withArgName((String)"source_path");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Source directory path.");
            OptionBuilder.withLongOpt((String)SOURCE_PATH_OPTION);
            options.addOption(OptionBuilder.create());
            OptionBuilder.withArgName((String)"path");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Custom metadata path.  Can be relative or absolute.  This option applies only when copying from the local file system to a namespace.");
            OptionBuilder.withLongOpt((String)CUSTOM_METADATA_OPTION);
            options.addOption(OptionBuilder.create());
            OptionBuilder.withArgName((String)"path");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"ACL path.  Can be relative or absolute.  This option applies only when copying from the local file system to a HCP 5.0 or later namespace.");
            OptionBuilder.withLongOpt((String)ACL_OPTION);
            options.addOption(OptionBuilder.create());
            OptionBuilder.withArgName((String)"path");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Owner's name.  This option applies only when copying from the local file system to a HCP 5.0 or later namespace.");
            OptionBuilder.withLongOpt((String)OWNER_OPTION);
            options.addOption(OptionBuilder.create());
            OptionBuilder.withArgName((String)"path");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Owner's domain.  This option applies only when copying from the local file system to a HCP 5.0 or later namespace.");
            OptionBuilder.withLongOpt((String)DOMAIN_OPTION);
            options.addOption(OptionBuilder.create());
            OptionBuilder.withArgName((String)"true|false");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Specifies whether copied objects should be marked for indexing.  This option applies only when copying from the local file system to a namespace.");
            OptionBuilder.withLongOpt((String)INDEX_OPTION);
            options.addOption(OptionBuilder.create());
            OptionBuilder.withArgName((String)"true|false");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Specifies whether copied objects should be marked for shredding.  This option applies only when copying from the local file system to a namespace.");
            OptionBuilder.withLongOpt((String)SHRED_OPTION);
            options.addOption(OptionBuilder.create());
            OptionBuilder.withArgName((String)"true|false");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Specifies whether copied objects should be placed on hold.  This option applies only when copying from the local file system to a namespace.");
            OptionBuilder.withLongOpt((String)HOLD_OPTION);
            options.addOption(OptionBuilder.create());
            OptionBuilder.withArgName((String)"retention_setting");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Retention setting for copied objects.  This option applies only when copying from the local file system to a namespace.");
            OptionBuilder.withLongOpt((String)RETENTION_OPTION);
            options.addOption(OptionBuilder.create());
            OptionBuilder.withArgName((String)"integer");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Group ID to use for the owner of copied objects.  This option applies only when copying from the local file system to a namespace.");
            OptionBuilder.withLongOpt((String)GID_OPTION);
            options.addOption(OptionBuilder.create());
            OptionBuilder.withArgName((String)"integer");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"User ID to use for the owner of copied objects.  This option applies only when copying from the local file system to a namespace.");
            OptionBuilder.withLongOpt((String)UID_OPTION);
            options.addOption(OptionBuilder.create());
            OptionBuilder.withArgName((String)"octal_value");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"POSIX permissions for copied objects; for example, 664.  This option applies only when copying from the local file system to a namespace.");
            OptionBuilder.withLongOpt((String)FILE_PERMS_OPTION);
            options.addOption(OptionBuilder.create());
            OptionBuilder.withArgName((String)"octal_value");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"POSIX permissions for new destination directories; for example, 664.  This option applies only when copying from the local file system to a namespace.");
            OptionBuilder.withLongOpt((String)DIR_PERMS_OPTION);
            options.addOption(OptionBuilder.create());
            OptionBuilder.withArgName((String)"job_name");
            OptionBuilder.hasOptionalArg();
            OptionBuilder.withDescription((String)"Reruns the copy job with the given job name if provide, if no name is provided it reruns the last copy job run.  When rerunning you can change the load and export settings.  Any changes to profiles, paths or metadata values will not change what is set in the job.");
            OptionBuilder.withLongOpt((String)RERUN);
            options.addOption(OptionBuilder.create());
            OptionBuilder.withArgName((String)"job_name");
            OptionBuilder.hasOptionalArg();
            OptionBuilder.withDescription((String)"Resumes the copy job from where it left off, if no name is provided it resumes the last copy job run.  When rerunning you can change the load and export settings.  Any changes to profiles, paths or metadata values will not change what is set in the job.");
            OptionBuilder.withLongOpt((String)RESUME);
            options.addOption(OptionBuilder.create());
            OptionBuilder.withDescription((String)"Treat conflict (409) failures as successes.");
            OptionBuilder.withLongOpt((String)IGNORE_CONFLICTS);
            options.addOption(OptionBuilder.create());
            OptionBuilder.withArgName((String)"results_types");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Types of results lists to export: either ALL or a comma-separated list that includes one or more of SUCCESS, FAILURE, JOBLIST and CONFLICT.  If omitted no results lists are exported.");
            OptionBuilder.withLongOpt((String)EXPORT_RESULTS_TYPE);
            options.addOption(OptionBuilder.create());
            this.getSharedOptions(options);
            cliOptions = options;
        }
        return cliOptions;
    }

    @Override
    protected void parseArgs() throws ParseException {
        PosixParser parser = new PosixParser();
        CommandLine cmdLine = parser.parse(this.getOptions(), this.getArgs());
        this.printHelp = cmdLine.hasOption("h");
        if (this.printHelp) {
            return;
        }
        this.initializeProfiles(cmdLine.hasOption("insecure"));
        List argList = cmdLine.getArgList();
        LoadSchedule schedule = LoadSchedule.getDefaultLoadSchedule();
        this.getLoadSchedule(cmdLine, schedule);
        this.setUpExportListThread(cmdLine);
        boolean rerunning = this.handleRerunAndResume(cmdLine, schedule);
        if (rerunning) {
            ArrayList<String> extraOptions = new ArrayList<String>();
            if (cmdLine.hasOption(DESTINATION_PROFILE_OPTION)) {
                extraOptions.add(DESTINATION_PROFILE_OPTION);
            }
            if (cmdLine.hasOption(SOURCE_PROFILE_OPTION)) {
                extraOptions.add(SOURCE_PROFILE_OPTION);
            }
            if (cmdLine.hasOption(DESTINATION_PATH_OPTION)) {
                extraOptions.add(DESTINATION_PATH_OPTION);
            }
            if (cmdLine.hasOption(SOURCE_PATH_OPTION)) {
                extraOptions.add(SOURCE_PATH_OPTION);
            }
            if (cmdLine.hasOption(JOB_NAME)) {
                extraOptions.add(JOB_NAME);
            }
            if (cmdLine.hasOption(HOLD_OPTION)) {
                extraOptions.add(HOLD_OPTION);
            }
            if (cmdLine.hasOption(INDEX_OPTION)) {
                extraOptions.add(INDEX_OPTION);
            }
            if (cmdLine.hasOption(SHRED_OPTION)) {
                extraOptions.add(SHRED_OPTION);
            }
            if (cmdLine.hasOption(RETENTION_OPTION)) {
                extraOptions.add(RETENTION_OPTION);
            }
            if (cmdLine.hasOption(UID_OPTION)) {
                extraOptions.add(UID_OPTION);
            }
            if (cmdLine.hasOption(GID_OPTION)) {
                extraOptions.add(GID_OPTION);
            }
            if (cmdLine.hasOption(FILE_PERMS_OPTION)) {
                extraOptions.add(FILE_PERMS_OPTION);
            }
            if (cmdLine.hasOption(DIR_PERMS_OPTION)) {
                extraOptions.add(DIR_PERMS_OPTION);
            }
            if (cmdLine.hasOption(CUSTOM_METADATA_OPTION)) {
                extraOptions.add(CUSTOM_METADATA_OPTION);
            }
            if (cmdLine.hasOption(ACL_OPTION)) {
                extraOptions.add(ACL_OPTION);
            }
            if (cmdLine.hasOption(OWNER_OPTION)) {
                extraOptions.add(OWNER_OPTION);
            }
            if (cmdLine.hasOption(DOMAIN_OPTION)) {
                extraOptions.add(DOMAIN_OPTION);
            }
            if (cmdLine.hasOption(IGNORE_CONFLICTS)) {
                extraOptions.add(IGNORE_CONFLICTS);
            }
            if (!extraOptions.isEmpty()) {
                throw new ParseException("The following supplied options are not allowed with --" + RESUME + " or --" + RERUN + ": " + extraOptions);
            }
            if (argList.size() > this.numCmdLineArgs - 1) {
                throw new ParseException("The list_file argument is not allowed with --" + RESUME + " or --" + RERUN);
            }
        } else {
            ArrayList<String> extraOptions;
            if (argList.size() != this.numCmdLineArgs) {
                throw new ParseException("Missing argument list_file.");
            }
            String listFileName = (String)argList.get(this.numCmdLineArgs - 1);
            ArrayList<String> missingRequiredOptions = new ArrayList<String>();
            if (!cmdLine.hasOption("s")) {
                missingRequiredOptions.add("s");
            }
            if (!cmdLine.hasOption("d")) {
                missingRequiredOptions.add("d");
            }
            if (!cmdLine.hasOption(DESTINATION_PATH_OPTION)) {
                missingRequiredOptions.add(DESTINATION_PATH_OPTION);
            }
            if (missingRequiredOptions.size() > 1) {
                throw new ParseException("Missing required options: " + missingRequiredOptions);
            }
            String srcProfileName = ArcCopy.getProfileNameFromCmdLineAndValidateExistance(cmdLine, "s");
            String tarProfileName = ArcCopy.getProfileNameFromCmdLineAndValidateExistance(cmdLine, "d");
            AbstractProfileBase srcProfile = ProfileManager.getProfileByName(srcProfileName);
            AbstractProfileBase dstProfile = ProfileManager.getProfileByName(tarProfileName);
            String targetPath = this.validateTargetPath(cmdLine);
            String sourcePath = null;
            if (cmdLine.hasOption(SOURCE_PATH_OPTION)) {
                sourcePath = cmdLine.getOptionValue(SOURCE_PATH_OPTION);
            }
            String jobName = null;
            if (cmdLine.hasOption(JOB_NAME)) {
                jobName = cmdLine.getOptionValue(JOB_NAME);
            }
            FileMetadata metadata = new FileMetadata();
            boolean goingFromLFSToHCP = srcProfile.getType() == ProfileType.FILESYSTEM && dstProfile.getType() != ProfileType.FILESYSTEM;
            boolean isCLIMetadataOverrideEnabled = Boolean.parseBoolean(HCPMoverProperties.CLI_OVERRIDE_MD.get());
            if (goingFromLFSToHCP || isCLIMetadataOverrideEnabled) {
                if (cmdLine.hasOption(INDEX_OPTION)) {
                    metadata.setSearchIndex(new Boolean(cmdLine.getOptionValue(INDEX_OPTION)));
                }
                if (cmdLine.hasOption(HOLD_OPTION)) {
                    metadata.setRetentionHold(new Boolean(cmdLine.getOptionValue(HOLD_OPTION)));
                }
                if (cmdLine.hasOption(SHRED_OPTION)) {
                    metadata.setShred(new Boolean(cmdLine.getOptionValue(SHRED_OPTION)));
                }
                if (cmdLine.hasOption(RETENTION_OPTION)) {
                    String cmdLineRetentionValue = cmdLine.getOptionValue(RETENTION_OPTION);
                    Retention retention = Retention.fromHcapValue(cmdLineRetentionValue);
                    metadata.setRetention(retention);
                }
                if (cmdLine.hasOption(CUSTOM_METADATA_OPTION)) {
                    CustomMetadata customMetadata = new CustomMetadata(StructuredMetadata.Form.FILE, cmdLine.getOptionValue(CUSTOM_METADATA_OPTION));
                    metadata.setCustomMetadata(customMetadata);
                }
                if (cmdLine.hasOption(ACL_OPTION)) {
                    if (dstProfile.supportsACLs()) {
                        ACLMetadata acl = new ACLMetadata(StructuredMetadata.Form.FILE, cmdLine.getOptionValue(ACL_OPTION));
                        metadata.setACL(acl);
                    } else {
                        throw new ParseException("The " + ACL_OPTION + " may only be specified when copying from the local file system to a HCP 5.0 or later namespace.");
                    }
                }
                if (dstProfile.supportsPosixSettings()) {
                    if (cmdLine.hasOption(UID_OPTION)) {
                        metadata.setUid(cmdLine.getOptionValue(UID_OPTION));
                    }
                    if (cmdLine.hasOption(GID_OPTION)) {
                        metadata.setGid(cmdLine.getOptionValue(GID_OPTION));
                    }
                    if (cmdLine.hasOption(FILE_PERMS_OPTION)) {
                        metadata.setFileMode(new Integer(cmdLine.getOptionValue(FILE_PERMS_OPTION)));
                    }
                    if (cmdLine.hasOption(DIR_PERMS_OPTION)) {
                        metadata.setDirMode(new Integer(cmdLine.getOptionValue(DIR_PERMS_OPTION)));
                    }
                } else {
                    extraOptions = new ArrayList();
                    if (cmdLine.hasOption(UID_OPTION)) {
                        extraOptions.add(UID_OPTION);
                    }
                    if (cmdLine.hasOption(GID_OPTION)) {
                        extraOptions.add(GID_OPTION);
                    }
                    if (cmdLine.hasOption(FILE_PERMS_OPTION)) {
                        extraOptions.add(FILE_PERMS_OPTION);
                    }
                    if (cmdLine.hasOption(DIR_PERMS_OPTION)) {
                        extraOptions.add(DIR_PERMS_OPTION);
                    }
                    if (!extraOptions.isEmpty()) {
                        throw new ParseException("The following supplied options are only allowed when copying from the local file system to either HCAP 2.x or the default namespace on HCP 3.0 or later: " + extraOptions);
                    }
                }
                if (dstProfile.isAnonymousAccess() && cmdLine.hasOption(OWNER_OPTION)) {
                    throw new ParseException("Cannot use owner option with an anonymous namespace profile.");
                }
                if (dstProfile.supportsOwner()) {
                    if (cmdLine.hasOption(OWNER_OPTION)) {
                        String ownerName;
                        Owner owner = cmdLine.hasOption(DOMAIN_OPTION) ? new Owner(cmdLine.getOptionValue(OWNER_OPTION), cmdLine.getOptionValue(DOMAIN_OPTION)) : ((ownerName = cmdLine.getOptionValue(OWNER_OPTION)).length() == 0 ? new Owner(Owner.OwnerType.PUBLIC) : new Owner(ownerName));
                        metadata.setOwner(owner);
                    }
                } else {
                    extraOptions = new ArrayList();
                    if (cmdLine.hasOption(OWNER_OPTION)) {
                        extraOptions.add(OWNER_OPTION);
                    }
                    if (cmdLine.hasOption(DOMAIN_OPTION)) {
                        extraOptions.add(DOMAIN_OPTION);
                    }
                    if (!extraOptions.isEmpty()) {
                        throw new ParseException("The following supplied options are only allowed when copying from the local file system to an HCP 5.0 or later namespace: " + extraOptions);
                    }
                }
            } else {
                extraOptions = new ArrayList<String>();
                if (cmdLine.hasOption(HOLD_OPTION)) {
                    extraOptions.add(HOLD_OPTION);
                }
                if (cmdLine.hasOption(INDEX_OPTION)) {
                    extraOptions.add(INDEX_OPTION);
                }
                if (cmdLine.hasOption(SHRED_OPTION)) {
                    extraOptions.add(SHRED_OPTION);
                }
                if (cmdLine.hasOption(RETENTION_OPTION)) {
                    extraOptions.add(RETENTION_OPTION);
                }
                if (cmdLine.hasOption(UID_OPTION)) {
                    extraOptions.add(UID_OPTION);
                }
                if (cmdLine.hasOption(GID_OPTION)) {
                    extraOptions.add(GID_OPTION);
                }
                if (cmdLine.hasOption(FILE_PERMS_OPTION)) {
                    extraOptions.add(FILE_PERMS_OPTION);
                }
                if (cmdLine.hasOption(DIR_PERMS_OPTION)) {
                    extraOptions.add(DIR_PERMS_OPTION);
                }
                if (cmdLine.hasOption(CUSTOM_METADATA_OPTION)) {
                    extraOptions.add(CUSTOM_METADATA_OPTION);
                }
                if (cmdLine.hasOption(ACL_OPTION)) {
                    extraOptions.add(ACL_OPTION);
                }
                if (cmdLine.hasOption(OWNER_OPTION)) {
                    extraOptions.add(OWNER_OPTION);
                }
                if (cmdLine.hasOption(DOMAIN_OPTION)) {
                    extraOptions.add(DOMAIN_OPTION);
                }
                if (!extraOptions.isEmpty()) {
                    throw new ParseException("The following supplied options are only allowed when copying from the local file system to HCP: " + extraOptions);
                }
            }
            boolean ignoreConflicts = cmdLine.hasOption(IGNORE_CONFLICTS);
            try {
                FileListParser.validateFile(new File(listFileName), srcProfile, sourcePath, targetPath);
            }
            catch (IOException e) {
                throw new ParseException("Error parsing input file.  Msg: " + e.getMessage());
            }
            catch (FileListParserException e) {
                throw new ParseException("Error parsing input file.  Msg: " + e.getMessage());
            }
            try {
                this.setupCopyJob(listFileName, dstProfile, targetPath, srcProfile, sourcePath, jobName, metadata, ignoreConflicts, schedule);
                this.managedJobImpl = this.arcMover.createManagedJob(this.managedJob);
            }
            catch (IllegalArgumentException e) {
                throw new ParseException("IllegalArgumentException writing to database during file list parsing.  Msg: " + e.getMessage());
            }
            catch (DatabaseException e) {
                throw new ParseException("DatabaseException writing to database during file list parsing.  Msg: " + e.getMessage());
            }
            catch (JobException e) {
                throw new ParseException("JobException writing to database during file list parsing.  Msg: " + e.getMessage());
            }
        }
    }

    private String validateTargetPath(CommandLine cmdLine) throws ParseException {
        if (!cmdLine.hasOption(DESTINATION_PATH_OPTION)) {
            throw new ParseException("Missing Option: " + DESTINATION_PATH_OPTION);
        }
        String value = cmdLine.getOptionValue(DESTINATION_PATH_OPTION);
        String retval = null;
        if (value != null) {
            retval = value;
        }
        if (retval == null) {
            throw new ParseException("Invalid " + DESTINATION_PATH_OPTION + " : " + value);
        }
        return retval;
    }

    @Override
    protected void appendAdditionalOutput(ManagedJobStats jobStats, StringBuilder sb, String padding) {
        String newLine = NEWLINE;
        ArcCopy.appendLabel(sb, "Failed Directories", padding);
        sb.append(jobStats.getErroredDirCount());
        sb.append(newLine);
        ArcCopy.appendLabel(sb, "I/O Rate", padding);
        sb.append(jobStats.getAverageOperationRate());
        sb.append(" operations/second");
        sb.append(newLine);
        ArcCopy.appendLabel(sb, "Throughput", padding);
        sb.append(jobStats.getAverageThroughput());
        sb.append(" KB/second");
        sb.append(newLine);
    }

    @Override
    protected String getFormattedJobStats(ManagedJobStats jobStats) {
        String spaces = String.format("%4s", " ");
        return String.format("%1$,d%%" + spaces + "-" + spaces + "%7$,d objects found," + spaces + "%2$,d/%3$,d KB complete," + spaces + "%4$,d/%5$,d files moved," + spaces + "Throughput = %6$,d KB/sec", jobStats.getPercentBytesCompleted(), jobStats.getCompletedBytesInKB(), jobStats.getCopyableBytesInKB(), jobStats.getCompletedObjectCount(), jobStats.getTotalObjectCount(), jobStats.getAverageThroughput(), jobStats.getDiscoveredObjectCount());
    }

    @Override
    protected String getErrorMessage() {
        return " failed to copy because: ";
    }

    @Override
    protected ManagedJob.Type getJobType() {
        return ManagedJob.Type.COPY;
    }

    @Override
    protected JobId getLastJobID() throws NumberFormatException {
        return new JobId(Long.parseLong(HCPMoverProperties.LAST_COPY_JOB_RUN.get()));
    }

    private void setupCopyJob(String listFileName, AbstractProfileBase dstProfile, String targetPath, AbstractProfileBase srcProfile, String sourcePath, String jobName, FileMetadata metadata, boolean ignoreConflicts, LoadSchedule schedule) throws DatabaseException {
        CopyJob copyJob = new CopyJob(srcProfile, dstProfile, new File(listFileName));
        this.managedJob = copyJob;
        this.managedJob.setTargetPath(dstProfile.encode(targetPath));
        if (sourcePath != null) {
            this.managedJob.setSourcePath(srcProfile.encode(sourcePath));
        }
        if (jobName != null) {
            this.managedJob.setUserDefinedJobName(jobName);
        }
        copyJob.setIgnoreConflicts(ignoreConflicts);
        this.managedJob.setLoadSchedule(schedule);
        ((CopyJob)this.managedJob).setIngestionMetadata(metadata);
    }

    @Override
    public boolean supportsConflictReports() {
        return true;
    }

    static {
        cliOptionsCount = 0;
        ArcCopy.addNextCLIOption(HELP_OPTION);
        ArcCopy.addNextCLIOption(DESTINATION_PROFILE_OPTION);
        ArcCopy.addNextCLIOption(SOURCE_PROFILE_OPTION);
        ArcCopy.addNextCLIOption(DESTINATION_PATH_OPTION);
        ArcCopy.addNextCLIOption(SOURCE_PATH_OPTION);
        ArcCopy.addNextCLIOption(JOB_NAME);
        ArcCopy.addNextCLIOption(HOLD_OPTION);
        ArcCopy.addNextCLIOption(INDEX_OPTION);
        ArcCopy.addNextCLIOption(SHRED_OPTION);
        ArcCopy.addNextCLIOption(RETENTION_OPTION);
        ArcCopy.addNextCLIOption(UID_OPTION);
        ArcCopy.addNextCLIOption(GID_OPTION);
        ArcCopy.addNextCLIOption(FILE_PERMS_OPTION);
        ArcCopy.addNextCLIOption(DIR_PERMS_OPTION);
        ArcCopy.addNextCLIOption(CUSTOM_METADATA_OPTION);
        ArcCopy.addNextCLIOption(ACL_OPTION);
        ArcCopy.addNextCLIOption(OWNER_OPTION);
        ArcCopy.addNextCLIOption(DOMAIN_OPTION);
        ArcCopy.addNextCLIOption(MAX_CONNECTIONS);
        ArcCopy.addNextCLIOption(MAX_NODE_CONNECTIONS);
        ArcCopy.addNextCLIOption(REDUCED_MAX_CONNECTIONS);
        ArcCopy.addNextCLIOption(REDUCED_MAX_NODE_CONNECTIONS);
        ArcCopy.addNextCLIOption(REDUCED_START);
        ArcCopy.addNextCLIOption(REDUCED_END);
        ArcCopy.addNextCLIOption(IGNORE_CONFLICTS);
        ArcCopy.addNextCLIOption(EXPORT_RESULTS_TYPE);
        ArcCopy.addNextCLIOption(EXPORT_RESULTS_PATH);
        ArcCopy.addNextCLIOption(EXPORT_RESULTS_PREFIX);
        ArcCopy.addNextCLIOption(RESUME);
        ArcCopy.addNextCLIOption(RERUN);
        ArcCopy.addNextCLIOption(INSECURE_OPTION);
    }
}

