/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcmover.cli;

import com.archivas.clienttools.arcmover.cli.ArcCopy;
import com.archivas.clienttools.arcmover.cli.ManagedCLIJob;
import com.archivas.clienttools.arcutils.api.ArcMoverEngine;
import com.archivas.clienttools.arcutils.api.ArcMoverFactory;
import com.archivas.clienttools.arcutils.api.JobException;
import com.archivas.clienttools.arcutils.api.JobId;
import com.archivas.clienttools.arcutils.api.ManagedJobStats;
import com.archivas.clienttools.arcutils.api.jobs.DeleteJob;
import com.archivas.clienttools.arcutils.api.jobs.ManagedJob;
import com.archivas.clienttools.arcutils.config.HCPMoverProperties;
import com.archivas.clienttools.arcutils.model.LoadSchedule;
import com.archivas.clienttools.arcutils.profile.AbstractProfileBase;
import com.archivas.clienttools.arcutils.profile.Hcp3AuthNamespaceProfile;
import com.archivas.clienttools.arcutils.profile.ProfileManager;
import com.archivas.clienttools.arcutils.utils.FileListParser;
import com.archivas.clienttools.arcutils.utils.FileListParserException;
import com.archivas.clienttools.arcutils.utils.database.DatabaseException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public class ArcDelete
extends ManagedCLIJob {
    public static final String PACKAGE_NAME = ArcCopy.class.getPackage().getName();
    public static final String CLASS_FULL_NAME = ArcCopy.class.getName();
    public static final String CLASS_NAME = CLASS_FULL_NAME.substring(PACKAGE_NAME.length() + 1);
    public static Logger LOG = Logger.getLogger(CLASS_FULL_NAME);
    private static String PROFILE_OPTION = "profile";
    private static String PATH_OPTION = "path";
    private static String OPERATION_OPTION = "operation";
    private static String REASON_OPTION = "reason";
    ArcMoverEngine arcMover = ArcMoverFactory.getInstance();
    private static Options cliOptions;
    private static int cliOptionsCount;

    private static void addNextCLIOption(String option) {
        cliOrder.put(option, cliOptionsCount++);
    }

    public ArcDelete(String[] args, int numCmdLineArgs) {
        super(args, numCmdLineArgs);
        HELP_USAGE_LINE = commandName + " delete --profile <profile_name> [options] [list_file]";
        HELP_HEADER = "Deletes items from the specified location.  Items to delete are listed in the list_file.\n";
    }

    @Override
    public Options getOptions() {
        if (cliOptions == null) {
            Options options = new Options();
            OptionBuilder.withDescription((String)"Displays this help text (the default behavior).");
            OptionBuilder.withLongOpt((String)HELP_OPTION);
            options.addOption(OptionBuilder.create((String)"h"));
            OptionBuilder.withArgName((String)"profile_name");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Target location for the delete operation: either a namespace profile name or LFS for the local file system.");
            OptionBuilder.withLongOpt((String)PROFILE_OPTION);
            options.addOption(OptionBuilder.create((String)"p"));
            OptionBuilder.withArgName((String)"path");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Directory in which to perform the delete operation.");
            OptionBuilder.withLongOpt((String)PATH_OPTION);
            options.addOption(OptionBuilder.create());
            OptionBuilder.withArgName((String)"operation_type");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Type of operation to perform: delete, purge, privileged-delete, or privileged-purge.  If omitted, defaults to delete.  Only supported for HCP namespaces.");
            OptionBuilder.withLongOpt((String)OPERATION_OPTION);
            options.addOption(OptionBuilder.create());
            OptionBuilder.withArgName((String)"string");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Specifies the reason for a privileged operation.  The string must be from one through 1024 characters long.  Required and only supported for a privileged operation.");
            OptionBuilder.withLongOpt((String)REASON_OPTION);
            options.addOption(OptionBuilder.create());
            OptionBuilder.withArgName((String)"job_name");
            OptionBuilder.hasOptionalArg();
            OptionBuilder.withDescription((String)"Reruns the delete job with the given job name if provide, if no name is provided it reruns the last delete job run.  When rerunning you can change the load and export settings.  Any changes to the profile, path, or operation-type will not change what is set in the job.");
            OptionBuilder.withLongOpt((String)RERUN);
            options.addOption(OptionBuilder.create());
            OptionBuilder.withArgName((String)"job_name");
            OptionBuilder.hasOptionalArg();
            OptionBuilder.withDescription((String)"Resumes the delete job from where it left off, if no name is provided it resumes the last delete job run.  When rerunning you can change the load and export settings.  Any changes to the profile, path, or operation-type will not change what is set in the job.");
            OptionBuilder.withLongOpt((String)RESUME);
            options.addOption(OptionBuilder.create());
            options.addOption(ArcDelete.getInsecureSSLOption());
            OptionBuilder.withArgName((String)"results_types");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Types of results lists to export: either ALL or a comma-separated list that includes one or more of SUCCESS, FAILURE, and JOBLIST.  If omitted no results lists are exported.");
            OptionBuilder.withLongOpt((String)EXPORT_RESULTS_TYPE);
            options.addOption(OptionBuilder.create());
            this.getSharedOptions(options);
            cliOptions = options;
        }
        return cliOptions;
    }

    @Override
    protected void parseArgs() throws ParseException {
        PosixParser parser = new PosixParser();
        CommandLine cmdLine = parser.parse(this.getOptions(), this.getArgs());
        this.printHelp = cmdLine.hasOption("h");
        if (this.printHelp) {
            return;
        }
        this.initializeProfiles(cmdLine.hasOption("insecure"));
        List argList = cmdLine.getArgList();
        LoadSchedule schedule = LoadSchedule.getDefaultLoadSchedule();
        this.getLoadSchedule(cmdLine, schedule);
        this.setUpExportListThread(cmdLine);
        boolean rerunning = this.handleRerunAndResume(cmdLine, schedule);
        if (rerunning) {
            ArrayList<String> extraOptions = new ArrayList<String>();
            if (cmdLine.hasOption(PROFILE_OPTION)) {
                extraOptions.add(PROFILE_OPTION);
            }
            if (cmdLine.hasOption(PATH_OPTION)) {
                extraOptions.add(PATH_OPTION);
            }
            if (cmdLine.hasOption(OPERATION_OPTION)) {
                extraOptions.add(OPERATION_OPTION);
            }
            if (cmdLine.hasOption(REASON_OPTION)) {
                extraOptions.add(REASON_OPTION);
            }
            if (cmdLine.hasOption(JOB_NAME)) {
                extraOptions.add(JOB_NAME);
            }
            if (!extraOptions.isEmpty()) {
                throw new ParseException("The following supplied options are not allowed with --" + RESUME + " or --" + RERUN + ": " + extraOptions);
            }
            if (argList.size() > this.numCmdLineArgs - 1) {
                throw new ParseException("The list_file argument is not allowed with --" + RESUME + " or --" + RERUN);
            }
        } else {
            if (argList.size() != this.numCmdLineArgs) {
                throw new ParseException("Missing argument list_file.");
            }
            String listFileName = (String)argList.get(this.numCmdLineArgs - 1);
            String srcProfileName = ArcDelete.getProfileNameFromCmdLineAndValidateExistance(cmdLine, PROFILE_OPTION);
            AbstractProfileBase srcProfile = ProfileManager.getProfileByName(srcProfileName);
            String sourcePath = null;
            if (cmdLine.hasOption(PATH_OPTION)) {
                sourcePath = cmdLine.getOptionValue(PATH_OPTION);
                srcProfile.setDisplayPath(sourcePath);
            }
            String jobName = null;
            if (cmdLine.hasOption(JOB_NAME)) {
                jobName = cmdLine.getOptionValue(JOB_NAME);
            }
            DeleteJob.Operation operation = DeleteJob.Operation.DELETE;
            String reason = null;
            if (srcProfile instanceof Hcp3AuthNamespaceProfile) {
                if (cmdLine.hasOption(OPERATION_OPTION)) {
                    String operationStr = cmdLine.getOptionValue(OPERATION_OPTION);
                    try {
                        operation = DeleteJob.Operation.getFromString(operationStr);
                    }
                    catch (IllegalArgumentException e) {
                        throw new ParseException(e.getMessage());
                    }
                }
                if (operation.isPrivilegedOperation()) {
                    if (!cmdLine.hasOption(REASON_OPTION)) {
                        throw new ParseException("The " + REASON_OPTION + " option is required with a " + operation.getStringRepresentation() + " operation.");
                    }
                    reason = cmdLine.getOptionValue(REASON_OPTION);
                } else if (cmdLine.hasOption(REASON_OPTION)) {
                    throw new ParseException("The " + REASON_OPTION + " option is only supported for " + DeleteJob.Operation.PRIVILEGED_DELETE.getStringRepresentation() + " and " + DeleteJob.Operation.PRIVILEGED_PURGE.getStringRepresentation() + " operations.");
                }
            } else {
                ArrayList<String> extraOptions = new ArrayList<String>();
                if (cmdLine.hasOption(OPERATION_OPTION)) {
                    extraOptions.add(OPERATION_OPTION);
                }
                if (cmdLine.hasOption(REASON_OPTION)) {
                    extraOptions.add(REASON_OPTION);
                }
                if (!extraOptions.isEmpty()) {
                    throw new ParseException("The following supplied options are only supported for HCP namespaces: " + extraOptions);
                }
            }
            try {
                FileListParser.validateFile(new File(listFileName), srcProfile, sourcePath, "");
            }
            catch (IOException e) {
                throw new ParseException("Error parsing input file.  Msg: " + e.getMessage());
            }
            catch (FileListParserException e) {
                throw new ParseException("Error parsing input file.  Msg: " + e.getMessage());
            }
            try {
                this.setupDeleteJob(listFileName, srcProfile, sourcePath, jobName, operation, reason, schedule);
                this.managedJobImpl = this.arcMover.createManagedJob(this.managedJob);
            }
            catch (IllegalArgumentException e) {
                throw new ParseException("IllegalArgumentException writing to database during file list parsing.  Msg: " + e.getMessage());
            }
            catch (DatabaseException e) {
                throw new ParseException("DatabaseException writing to database during file list parsing.  Msg: " + e.getMessage());
            }
            catch (JobException e) {
                throw new ParseException("JobException writing to database during file list parsing.  Msg: " + e.getMessage());
            }
        }
    }

    @Override
    protected String getErrorMessage() {
        return " failed to delete because: ";
    }

    @Override
    protected ManagedJob.Type getJobType() {
        return ManagedJob.Type.DELETE;
    }

    @Override
    protected JobId getLastJobID() throws NumberFormatException {
        return new JobId(Long.parseLong(HCPMoverProperties.LAST_DELETE_JOB_RUN.get()));
    }

    @Override
    protected String getFormattedJobStats(ManagedJobStats jobStats) {
        return String.format("%3$,d objects found,\t%1$,d/%2$,d files deleted", jobStats.getCompletedObjectCount(), jobStats.getTotalObjectCount(), jobStats.getDiscoveredObjectCount());
    }

    @Override
    protected void appendAdditionalOutput(ManagedJobStats jobStats, StringBuilder sb, String padding) {
    }

    private void setupDeleteJob(String listFileName, AbstractProfileBase profile, String path, String jobName, DeleteJob.Operation operation, String reason, LoadSchedule schedule) throws DatabaseException {
        DeleteJob deleteJob = new DeleteJob(profile, new File(listFileName));
        if (jobName != null) {
            deleteJob.setUserDefinedJobName(jobName);
        }
        deleteJob.setOperation(operation);
        if (reason != null) {
            deleteJob.setReason(reason);
        }
        deleteJob.setSourcePath(profile.encode(path));
        deleteJob.setLoadSchedule(schedule);
        this.managedJob = deleteJob;
    }

    @Override
    public boolean supportsConflictReports() {
        return false;
    }

    static {
        cliOptionsCount = 0;
        ArcDelete.addNextCLIOption(HELP_OPTION);
        ArcDelete.addNextCLIOption(PROFILE_OPTION);
        ArcDelete.addNextCLIOption(PATH_OPTION);
        ArcDelete.addNextCLIOption(OPERATION_OPTION);
        ArcDelete.addNextCLIOption(REASON_OPTION);
        ArcDelete.addNextCLIOption(JOB_NAME);
        ArcDelete.addNextCLIOption(MAX_CONNECTIONS);
        ArcDelete.addNextCLIOption(MAX_NODE_CONNECTIONS);
        ArcDelete.addNextCLIOption(REDUCED_MAX_CONNECTIONS);
        ArcDelete.addNextCLIOption(REDUCED_MAX_NODE_CONNECTIONS);
        ArcDelete.addNextCLIOption(REDUCED_START);
        ArcDelete.addNextCLIOption(REDUCED_END);
        ArcDelete.addNextCLIOption(EXPORT_RESULTS_TYPE);
        ArcDelete.addNextCLIOption(EXPORT_RESULTS_PATH);
        ArcDelete.addNextCLIOption(EXPORT_RESULTS_PREFIX);
        ArcDelete.addNextCLIOption(RESUME);
        ArcDelete.addNextCLIOption(RERUN);
        ArcDelete.addNextCLIOption(INSECURE_OPTION);
    }
}

