/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcmover.cli;

import com.archivas.clienttools.arcmover.cli.AbstractArcCli;
import com.archivas.clienttools.arcmover.cli.ArcProfileMgr;
import com.archivas.clienttools.arcutils.api.ArcMoverFactory;
import com.archivas.clienttools.arcutils.api.JobException;
import com.archivas.clienttools.arcutils.api.jobs.ManagedJobSummary;
import com.archivas.clienttools.arcutils.config.ConfigurationHelper;
import com.archivas.clienttools.arcutils.utils.database.DatabaseException;
import java.io.PrintWriter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.lang.text.StrBuilder;

public class ArcJobMgr
extends AbstractArcCli {
    public static final String PACKAGE_NAME = ArcProfileMgr.class.getPackage().getName();
    public static final String CLASS_FULL_NAME = ArcProfileMgr.class.getName();
    public static final String CLASS_NAME = CLASS_FULL_NAME.substring(PACKAGE_NAME.length() + 1);
    public static Logger LOG = Logger.getLogger(CLASS_FULL_NAME);
    private static String HELP_USAGE_LINE;
    private static final String HELP_HEADER = "Deletes, or displays information about saved jobs.\nTo rerun a job use hcpdm copy --rerun <job_name> or hcpdm delete --rerun <job_name>\n\n";
    private static final String HELP_FOOTER = "";
    private static Options cliOptions;
    private static String jobName;
    private static JobMgrAction cmdAction;
    private static final String JOB_NAME_LABEL = "Name";
    private static final String JOB_TYPE_LABEL = "Job Type";
    private static final String JOB_STATE_LABEL = "State";
    private static final String COL_SEP = "  ";

    public ArcJobMgr(String[] args) {
        super(args);
        HELP_USAGE_LINE = commandName + " job -d <job_name> | -l";
    }

    @Override
    public Options getOptions() {
        if (cliOptions == null) {
            Options options = new Options();
            this.addOption(options, JobMgrAction.HELP);
            this.addOption(options, JobMgrAction.LIST);
            this.addOption(options, JobMgrAction.DELETE);
            cliOptions = options;
        }
        return cliOptions;
    }

    private void addOption(Options options, JobMgrAction action) {
        if (action.getArgName() != null) {
            OptionBuilder.hasOptionalArg();
            OptionBuilder.withArgName((String)action.getArgName());
            OptionBuilder.withDescription((String)action.getDescription());
            OptionBuilder.withLongOpt((String)action.getCmdLineLongOpt());
            options.addOption(OptionBuilder.create((String)action.getCmdLineShortOpt()));
        } else {
            OptionBuilder.withDescription((String)action.getDescription());
            OptionBuilder.withLongOpt((String)action.getCmdLineLongOpt());
            options.addOption(OptionBuilder.create((String)action.getCmdLineShortOpt()));
        }
    }

    @Override
    public String getHelpFooter() {
        return HELP_FOOTER;
    }

    @Override
    public String getHelpHeader() {
        return HELP_HEADER;
    }

    @Override
    public String getHelpUsageLine() {
        return HELP_USAGE_LINE;
    }

    public static void main(String[] args) {
        ArcJobMgr arcJobMgr = null;
        ConfigurationHelper.validateLaunchOK();
        try {
            arcJobMgr = new ArcJobMgr(args);
            arcJobMgr.parseArgs();
            if (cmdAction == JobMgrAction.HELP) {
                System.out.println(arcJobMgr.helpScreen());
            } else {
                arcJobMgr.execute(new PrintWriter(System.out), new PrintWriter(System.err));
            }
        }
        catch (ParseException e) {
            System.out.println("Error: " + e.getMessage());
            System.out.println();
            System.out.println(arcJobMgr.helpScreen());
            arcJobMgr.setExitCode(1);
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Unexpected Exception.", e);
            System.out.println();
            System.out.println("Failed to create a new profile " + e.getMessage());
            arcJobMgr.setExitCode(4);
        }
        finally {
            if (arcJobMgr != null) {
                arcJobMgr.exit();
            }
        }
    }

    @Override
    protected void parseArgs() throws ParseException {
        PosixParser parser = new PosixParser();
        CommandLine cmdLine = parser.parse(this.getOptions(), this.getArgs());
        cmdAction = JobMgrAction.HELP;
        if (cmdLine.hasOption(JobMgrAction.LIST.getCmdLineLongOpt())) {
            cmdAction = JobMgrAction.LIST;
        } else if (cmdLine.hasOption(JobMgrAction.DELETE.getCmdLineLongOpt())) {
            cmdAction = JobMgrAction.DELETE;
            jobName = cmdLine.getOptionValue(JobMgrAction.DELETE.getCmdLineShortOpt());
        } else if (!cmdLine.hasOption(JobMgrAction.HELP.getCmdLineLongOpt())) {
            throw new ParseException("Illegal options passed in.");
        }
    }

    @Override
    public void execute(PrintWriter out, PrintWriter err) {
        StrBuilder output = new StrBuilder();
        try {
            if (cmdAction == JobMgrAction.LIST) {
                output.append(this.createJobListing());
            } else if (cmdAction == JobMgrAction.DELETE) {
                this.deleteJob(jobName);
                output.append("Job " + jobName + " was deleted.");
            } else {
                output.append(this.helpScreen());
            }
        }
        catch (DatabaseException e) {
            output.append("Database Exception while trying to execute command: " + e.getMessage());
        }
        catch (JobException e) {
            output.append("Job Exception while trying to execute command: " + e.getMessage());
        }
        out.println(output.toString());
        out.flush();
        err.flush();
    }

    private void deleteJob(String jobName) throws DatabaseException, JobException {
        boolean jobFound = false;
        List<ManagedJobSummary> jobsList = ArcMoverFactory.getInstance().getAllManagedJobs();
        for (ManagedJobSummary job : jobsList) {
            if (!this.getValue(job, JOB_NAME_LABEL).equals(jobName)) continue;
            ArcMoverFactory.getInstance().removeManagedJob(job.getJobId(), job.getJobType());
            jobFound = true;
            break;
        }
        if (!jobFound) {
            throw new JobException("Job was not deleted because job " + jobName + " was not found.");
        }
    }

    private String createJobListing() throws DatabaseException {
        StrBuilder sb = new StrBuilder();
        List<ManagedJobSummary> jobsList = ArcMoverFactory.getInstance().getAllManagedJobs();
        Map<String, Integer> columnWidths = this.calcColumnWidths(jobsList);
        for (Map.Entry<String, Integer> entry : columnWidths.entrySet()) {
            sb.appendFixedWidthPadRight((Object)entry.getKey(), entry.getValue().intValue(), ' ').append(COL_SEP);
        }
        sb.append(NEWLINE);
        for (ManagedJobSummary job : jobsList) {
            sb.appendFixedWidthPadRight((Object)this.getValue(job, JOB_NAME_LABEL), columnWidths.get(JOB_NAME_LABEL).intValue(), ' ').append(COL_SEP);
            sb.appendFixedWidthPadRight((Object)this.getValue(job, JOB_TYPE_LABEL), columnWidths.get(JOB_TYPE_LABEL).intValue(), ' ').append(COL_SEP);
            sb.appendFixedWidthPadRight((Object)this.getValue(job, JOB_STATE_LABEL), columnWidths.get(JOB_STATE_LABEL).intValue(), ' ').append(COL_SEP);
            sb.append(NEWLINE);
        }
        return sb.toString();
    }

    private Map<String, Integer> calcColumnWidths(List<ManagedJobSummary> jobsList) {
        LinkedHashMap<String, Integer> columnWidths = new LinkedHashMap<String, Integer>();
        columnWidths.put(JOB_NAME_LABEL, JOB_NAME_LABEL.length());
        columnWidths.put(JOB_TYPE_LABEL, JOB_TYPE_LABEL.length());
        columnWidths.put(JOB_STATE_LABEL, JOB_STATE_LABEL.length());
        for (ManagedJobSummary job : jobsList) {
            columnWidths.put(JOB_NAME_LABEL, Math.max((Integer)columnWidths.get(JOB_NAME_LABEL), this.getValue(job, JOB_NAME_LABEL).length()));
            columnWidths.put(JOB_TYPE_LABEL, Math.max((Integer)columnWidths.get(JOB_TYPE_LABEL), this.getValue(job, JOB_TYPE_LABEL).length()));
            columnWidths.put(JOB_STATE_LABEL, Math.max((Integer)columnWidths.get(JOB_STATE_LABEL), this.getValue(job, JOB_STATE_LABEL).length()));
        }
        return columnWidths;
    }

    private String getValue(ManagedJobSummary job, String key) {
        if (JOB_NAME_LABEL.equals(key)) {
            return job.getJobName();
        }
        if (JOB_TYPE_LABEL.equals(key)) {
            return job.getJobType().getUiName();
        }
        if (JOB_STATE_LABEL.equals(key)) {
            return job.getJobStatus().toString();
        }
        throw new IllegalArgumentException("Unsupported column index " + key);
    }

    static {
        jobName = null;
    }

    static enum JobMgrAction {
        LIST("list", "l", null, "Displays the list of saved jobs."),
        DELETE("delete", "d", "job_name", "Deletes the job from the job list."),
        HELP("help", "h", null, "Displays this help text (the default behavior).");

        String cmdLineLongOpt;
        String cmdLineShortOpt;
        String argName;
        String description;

        private JobMgrAction(String cmdLineLongOpt, String cmdLineShortOpt, String argName, String description) {
            this.cmdLineLongOpt = cmdLineLongOpt;
            this.cmdLineShortOpt = cmdLineShortOpt;
            this.argName = argName;
            this.description = description;
        }

        public String getCmdLineLongOpt() {
            return this.cmdLineLongOpt;
        }

        public String getCmdLineShortOpt() {
            return this.cmdLineShortOpt;
        }

        public String getArgName() {
            return this.argName;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

