/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcmover.cli;

import com.archivas.clienttools.arcmover.cli.ManagedCLIJob;
import com.archivas.clienttools.arcutils.api.JobId;
import com.archivas.clienttools.arcutils.api.ManagedJobStats;
import com.archivas.clienttools.arcutils.api.jobs.ManagedJob;
import com.archivas.clienttools.arcutils.api.jobs.SetMetadataJob;
import com.archivas.clienttools.arcutils.config.HCPMoverProperties;
import com.archivas.clienttools.arcutils.model.ACLMetadata;
import com.archivas.clienttools.arcutils.model.CustomMetadata;
import com.archivas.clienttools.arcutils.model.FileMetadata;
import com.archivas.clienttools.arcutils.model.LoadSchedule;
import com.archivas.clienttools.arcutils.model.Owner;
import com.archivas.clienttools.arcutils.model.Retention;
import com.archivas.clienttools.arcutils.model.StructuredMetadata;
import com.archivas.clienttools.arcutils.profile.AbstractProfileBase;
import com.archivas.clienttools.arcutils.profile.ProfileManager;
import com.archivas.clienttools.arcutils.utils.FileListParser;
import com.archivas.clienttools.arcutils.utils.FileListParserException;
import com.archivas.clienttools.arcutils.utils.database.DatabaseException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public class ArcMetadata
extends ManagedCLIJob {
    private static String PROFILE_OPTION = "profile";
    private static String PATH_OPTION = "path";
    private static String HOLD_OPTION = "hold";
    private static String INDEX_OPTION = "index";
    private static String SHRED_OPTION = "shred";
    private static String RETENTION_OPTION = "retention";
    private static String CUSTOM_METADATA_OPTION = "custom-metadata";
    private static String ACL_OPTION = "acl";
    private static String OWNER_OPTION = "owner";
    private static String DOMAIN_OPTION = "domain";
    private static Options cliOptions;
    private static int cliOptionsCount;

    private static void addNextCLIOption(String option) {
        cliOrder.put(option, cliOptionsCount++);
    }

    public ArcMetadata(String[] args, int numCmdLineArgs) {
        super(args, numCmdLineArgs);
        HELP_USAGE_LINE = commandName + " metadata --profile <profile_name> [options] [list_file]";
        HELP_HEADER = "Sets metadata on items from the specified location.  Items to update are listed in the list_file.\n";
    }

    @Override
    public Options getOptions() {
        if (cliOptions == null) {
            Options options = new Options();
            OptionBuilder.withDescription((String)"Displays this help text (the default behavior).");
            OptionBuilder.withLongOpt((String)HELP_OPTION);
            options.addOption(OptionBuilder.create((String)"h"));
            OptionBuilder.withArgName((String)"profile_name");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Target location for the set metadata operation: a namespace profile name.");
            OptionBuilder.withLongOpt((String)PROFILE_OPTION);
            options.addOption(OptionBuilder.create((String)"p"));
            OptionBuilder.withArgName((String)"path");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Directory in which to perform the set metadata operation.");
            OptionBuilder.withLongOpt((String)PATH_OPTION);
            options.addOption(OptionBuilder.create());
            OptionBuilder.withArgName((String)"path");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Custom metadata path.  Can be relative or absolute.");
            OptionBuilder.withLongOpt((String)CUSTOM_METADATA_OPTION);
            options.addOption(OptionBuilder.create());
            OptionBuilder.withArgName((String)"path");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"ACL path.  Can be relative or absolute.  This option only applies when updating a HCP 5.0 or later namespace.");
            OptionBuilder.withLongOpt((String)ACL_OPTION);
            options.addOption(OptionBuilder.create());
            OptionBuilder.withArgName((String)"path");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Owner's name.  This option applies only when updating a HCP 5.0 or later namespace.");
            OptionBuilder.withLongOpt((String)OWNER_OPTION);
            options.addOption(OptionBuilder.create());
            OptionBuilder.withArgName((String)"path");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Owner's domain.  This option applies only when updating a HCP 5.0 or later namespace.");
            OptionBuilder.withLongOpt((String)DOMAIN_OPTION);
            options.addOption(OptionBuilder.create());
            OptionBuilder.withArgName((String)"true|false");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Specifies whether copied objects should be marked for indexing.");
            OptionBuilder.withLongOpt((String)INDEX_OPTION);
            options.addOption(OptionBuilder.create());
            OptionBuilder.withArgName((String)"true|false");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Specifies whether copied objects should be marked for shredding.");
            OptionBuilder.withLongOpt((String)SHRED_OPTION);
            options.addOption(OptionBuilder.create());
            OptionBuilder.withArgName((String)"true|false");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Specifies whether objects should be placed on hold.");
            OptionBuilder.withLongOpt((String)HOLD_OPTION);
            options.addOption(OptionBuilder.create());
            OptionBuilder.withArgName((String)"retention_setting");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Retention setting for copied objects.");
            OptionBuilder.withLongOpt((String)RETENTION_OPTION);
            options.addOption(OptionBuilder.create());
            OptionBuilder.withArgName((String)"job_name");
            OptionBuilder.hasOptionalArg();
            OptionBuilder.withDescription((String)"Reruns the metadata job with the given job name if provided; if no name is provided it reruns the last metadata job run.  When rerunning you can change the load and export settings.  Any changes to profiles, paths or metadata values will not change what is set in the job.");
            OptionBuilder.withLongOpt((String)RERUN);
            options.addOption(OptionBuilder.create());
            OptionBuilder.withArgName((String)"job_name");
            OptionBuilder.hasOptionalArg();
            OptionBuilder.withDescription((String)"Resumes the metadata job from where it left off, if no name is provided it resumes the last metadata job run.  When rerunning you can change the load and export settings.  Any changes to profiles, paths or metadata values will not change what is set in the job.");
            OptionBuilder.withLongOpt((String)RESUME);
            options.addOption(OptionBuilder.create());
            OptionBuilder.withArgName((String)"results_types");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Types of results lists to export: either ALL or a comma-separated list that includes one or more of SUCCESS, FAILURE, and JOBLIST.  If omitted no results lists are exported.");
            OptionBuilder.withLongOpt((String)EXPORT_RESULTS_TYPE);
            options.addOption(OptionBuilder.create());
            this.getSharedOptions(options);
            cliOptions = options;
        }
        return cliOptions;
    }

    @Override
    protected void parseArgs() throws ParseException {
        PosixParser parser = new PosixParser();
        CommandLine cmdLine = parser.parse(this.getOptions(), this.getArgs());
        this.printHelp = cmdLine.hasOption("h");
        if (this.printHelp) {
            return;
        }
        this.initializeProfiles(cmdLine.hasOption("insecure"));
        List argList = cmdLine.getArgList();
        LoadSchedule schedule = LoadSchedule.getDefaultLoadSchedule();
        this.getLoadSchedule(cmdLine, schedule);
        this.setUpExportListThread(cmdLine);
        boolean rerunning = this.handleRerunAndResume(cmdLine, schedule);
        if (rerunning) {
            ArrayList<String> extraOptions = new ArrayList<String>();
            if (cmdLine.hasOption(PROFILE_OPTION)) {
                extraOptions.add(PROFILE_OPTION);
            }
            if (cmdLine.hasOption(PATH_OPTION)) {
                extraOptions.add(PATH_OPTION);
            }
            if (cmdLine.hasOption(JOB_NAME)) {
                extraOptions.add(JOB_NAME);
            }
            if (cmdLine.hasOption(HOLD_OPTION)) {
                extraOptions.add(HOLD_OPTION);
            }
            if (cmdLine.hasOption(INDEX_OPTION)) {
                extraOptions.add(INDEX_OPTION);
            }
            if (cmdLine.hasOption(SHRED_OPTION)) {
                extraOptions.add(SHRED_OPTION);
            }
            if (cmdLine.hasOption(RETENTION_OPTION)) {
                extraOptions.add(RETENTION_OPTION);
            }
            if (cmdLine.hasOption(CUSTOM_METADATA_OPTION)) {
                extraOptions.add(CUSTOM_METADATA_OPTION);
            }
            if (cmdLine.hasOption(ACL_OPTION)) {
                extraOptions.add(ACL_OPTION);
            }
            if (cmdLine.hasOption(OWNER_OPTION)) {
                extraOptions.add(OWNER_OPTION);
            }
            if (cmdLine.hasOption(DOMAIN_OPTION)) {
                extraOptions.add(DOMAIN_OPTION);
            }
            if (!extraOptions.isEmpty()) {
                throw new ParseException("The following supplied options are not allowed with --" + RESUME + " or --" + RERUN + ": " + extraOptions);
            }
            if (argList.size() > this.numCmdLineArgs - 1) {
                throw new ParseException("The list_file argument is not allowed with --" + RESUME + " or --" + RERUN);
            }
        } else {
            if (argList.size() != this.numCmdLineArgs) {
                throw new ParseException("Missing argument list_file.");
            }
            String listFileName = (String)argList.get(this.numCmdLineArgs - 1);
            String profileName = ArcMetadata.getProfileNameFromCmdLineAndValidateExistance(cmdLine, PROFILE_OPTION);
            AbstractProfileBase profile = ProfileManager.getProfileByName(profileName);
            if (!profile.isAuthNamespace()) {
                throw new ParseException("Metadata may only be set on HCP namespaces.");
            }
            String path = this.validatePath(cmdLine);
            String jobName = null;
            if (cmdLine.hasOption(JOB_NAME)) {
                jobName = cmdLine.getOptionValue(JOB_NAME);
            }
            FileMetadata metadata = new FileMetadata();
            if (cmdLine.hasOption(INDEX_OPTION)) {
                metadata.setSearchIndex(new Boolean(cmdLine.getOptionValue(INDEX_OPTION)));
            }
            if (cmdLine.hasOption(HOLD_OPTION)) {
                metadata.setRetentionHold(new Boolean(cmdLine.getOptionValue(HOLD_OPTION)));
            }
            if (cmdLine.hasOption(SHRED_OPTION)) {
                metadata.setShred(new Boolean(cmdLine.getOptionValue(SHRED_OPTION)));
            }
            if (cmdLine.hasOption(RETENTION_OPTION)) {
                String cmdLineRetentionValue = cmdLine.getOptionValue(RETENTION_OPTION);
                Retention retention = Retention.fromHcapValue(cmdLineRetentionValue);
                metadata.setRetention(retention);
            }
            if (cmdLine.hasOption(CUSTOM_METADATA_OPTION)) {
                CustomMetadata customMetadata = new CustomMetadata(StructuredMetadata.Form.FILE, cmdLine.getOptionValue(CUSTOM_METADATA_OPTION));
                metadata.setCustomMetadata(customMetadata);
            }
            if (cmdLine.hasOption(ACL_OPTION)) {
                if (profile.supportsACLs()) {
                    ACLMetadata acl = new ACLMetadata(StructuredMetadata.Form.FILE, cmdLine.getOptionValue(ACL_OPTION));
                    metadata.setACL(acl);
                } else {
                    throw new ParseException("The " + ACL_OPTION + " may only be specified when updating a HCP 5.0 or later namespace.");
                }
            }
            if (profile.isAnonymousAccess() && cmdLine.hasOption(OWNER_OPTION)) {
                throw new ParseException("Cannot use owner option with an anonymous namespace profile.");
            }
            if (profile.supportsOwner()) {
                if (cmdLine.hasOption(OWNER_OPTION)) {
                    String ownerName;
                    Owner owner = cmdLine.hasOption(DOMAIN_OPTION) ? new Owner(cmdLine.getOptionValue(OWNER_OPTION), cmdLine.getOptionValue(DOMAIN_OPTION)) : ((ownerName = cmdLine.getOptionValue(OWNER_OPTION)).length() == 0 ? new Owner(Owner.OwnerType.PUBLIC) : new Owner(ownerName));
                    metadata.setOwner(owner);
                }
            } else {
                ArrayList<String> extraOptions = new ArrayList<String>();
                if (cmdLine.hasOption(OWNER_OPTION)) {
                    extraOptions.add(OWNER_OPTION);
                }
                if (cmdLine.hasOption(DOMAIN_OPTION)) {
                    extraOptions.add(DOMAIN_OPTION);
                }
                if (!extraOptions.isEmpty()) {
                    throw new ParseException("The following supplied options are only allowed when copying from the local file system to an HCP 5.0 or later namespace: " + extraOptions);
                }
            }
            try {
                FileListParser.validateFile(new File(listFileName), profile, path, "");
            }
            catch (IOException e) {
                throw new ParseException("Error parsing input file.  Msg: " + e.getMessage());
            }
            catch (FileListParserException e) {
                throw new ParseException("Error parsing input file.  Msg: " + e.getMessage());
            }
            try {
                this.setupMetadataJob(listFileName, profile, path, jobName, metadata, schedule);
                this.managedJobImpl = this.arcMover.createManagedJob(this.managedJob);
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "An error occurred preparing a metadata job", e);
                throw new ParseException("Error writing to database during file list parsing.  Msg: " + e.getMessage());
            }
        }
    }

    private String validatePath(CommandLine cmdLine) throws ParseException {
        if (!cmdLine.hasOption(PATH_OPTION)) {
            throw new ParseException("Missing Option: " + PATH_OPTION);
        }
        String value = cmdLine.getOptionValue(PATH_OPTION);
        String retval = null;
        if (value != null) {
            retval = value;
        }
        if (retval == null) {
            throw new ParseException("Invalid " + PATH_OPTION + " : " + value);
        }
        return retval;
    }

    @Override
    protected void appendAdditionalOutput(ManagedJobStats jobStats, StringBuilder sb, String padding) {
    }

    @Override
    protected String getFormattedJobStats(ManagedJobStats jobStats) {
        return String.format("%3$,d objects found,\t%1$,d/%2$,d objects updated", jobStats.getCompletedObjectCount(), jobStats.getTotalObjectCount(), jobStats.getDiscoveredObjectCount());
    }

    @Override
    protected String getErrorMessage() {
        return " failed to update metadata because: ";
    }

    @Override
    protected ManagedJob.Type getJobType() {
        return ManagedJob.Type.SET_METADATA;
    }

    @Override
    protected JobId getLastJobID() throws NumberFormatException {
        return new JobId(Long.parseLong(HCPMoverProperties.LAST_METADATA_JOB_RUN.get()));
    }

    private void setupMetadataJob(String listFileName, AbstractProfileBase profile, String path, String jobName, FileMetadata metadata, LoadSchedule schedule) throws DatabaseException {
        SetMetadataJob job = new SetMetadataJob(profile, new File(listFileName));
        this.managedJob = job;
        this.managedJob.setSourcePath(profile.encode(path));
        if (jobName != null) {
            this.managedJob.setUserDefinedJobName(jobName);
        }
        this.managedJob.setLoadSchedule(schedule);
        ((SetMetadataJob)this.managedJob).setIngestionMetadata(metadata);
    }

    @Override
    public boolean supportsConflictReports() {
        return false;
    }

    static {
        cliOptionsCount = 0;
        ArcMetadata.addNextCLIOption(HELP_OPTION);
        ArcMetadata.addNextCLIOption(PROFILE_OPTION);
        ArcMetadata.addNextCLIOption(PATH_OPTION);
        ArcMetadata.addNextCLIOption(JOB_NAME);
        ArcMetadata.addNextCLIOption(HOLD_OPTION);
        ArcMetadata.addNextCLIOption(INDEX_OPTION);
        ArcMetadata.addNextCLIOption(SHRED_OPTION);
        ArcMetadata.addNextCLIOption(RETENTION_OPTION);
        ArcMetadata.addNextCLIOption(CUSTOM_METADATA_OPTION);
        ArcMetadata.addNextCLIOption(ACL_OPTION);
        ArcMetadata.addNextCLIOption(OWNER_OPTION);
        ArcMetadata.addNextCLIOption(DOMAIN_OPTION);
        ArcMetadata.addNextCLIOption(MAX_CONNECTIONS);
        ArcMetadata.addNextCLIOption(MAX_NODE_CONNECTIONS);
        ArcMetadata.addNextCLIOption(REDUCED_MAX_CONNECTIONS);
        ArcMetadata.addNextCLIOption(REDUCED_MAX_NODE_CONNECTIONS);
        ArcMetadata.addNextCLIOption(REDUCED_START);
        ArcMetadata.addNextCLIOption(REDUCED_END);
        ArcMetadata.addNextCLIOption(IGNORE_CONFLICTS);
        ArcMetadata.addNextCLIOption(EXPORT_RESULTS_TYPE);
        ArcMetadata.addNextCLIOption(EXPORT_RESULTS_PATH);
        ArcMetadata.addNextCLIOption(EXPORT_RESULTS_PREFIX);
        ArcMetadata.addNextCLIOption(RESUME);
        ArcMetadata.addNextCLIOption(RERUN);
        ArcMetadata.addNextCLIOption(INSECURE_OPTION);
    }
}

