/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcmover.cli;

import com.archivas.clienttools.arcmover.cli.AbstractArcCli;
import com.archivas.clienttools.arcutils.api.ArcMoverEngine;
import com.archivas.clienttools.arcutils.api.ArcMoverFactory;
import com.archivas.clienttools.arcutils.config.ConfigurationException;
import com.archivas.clienttools.arcutils.config.ConfigurationHelper;
import com.archivas.clienttools.arcutils.impl.adapter.ConnectionTestException;
import com.archivas.clienttools.arcutils.profile.AbstractProfileBase;
import com.archivas.clienttools.arcutils.profile.FileSystemProfile;
import com.archivas.clienttools.arcutils.profile.HCAPProfile;
import com.archivas.clienttools.arcutils.profile.Hcp3AuthNamespaceProfile;
import com.archivas.clienttools.arcutils.profile.Hcp3DefaultNamespaceProfile;
import com.archivas.clienttools.arcutils.profile.Hcp5AuthNamespaceProfile;
import com.archivas.clienttools.arcutils.profile.Hcp6AuthNamespaceProfile;
import com.archivas.clienttools.arcutils.profile.ProfileManager;
import com.archivas.clienttools.arcutils.profile.ProfileType;
import com.archivas.clienttools.arcutils.utils.StringUtils;
import com.archivas.clienttools.arcutils.utils.database.DBUtils;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.lang.text.StrBuilder;

public class ArcProfileMgr
extends AbstractArcCli {
    public static final String PACKAGE_NAME = ArcProfileMgr.class.getPackage().getName();
    public static final String CLASS_FULL_NAME = ArcProfileMgr.class.getName();
    public static final String CLASS_NAME = CLASS_FULL_NAME.substring(PACKAGE_NAME.length() + 1);
    public static Logger LOG = Logger.getLogger(CLASS_FULL_NAME);
    private static String HELP_USAGE_LINE;
    private static final String HELP_HEADER = "Creates, deletes, or displays information about namespace profiles.\n";
    private static final String HELP_FOOTER = "";
    private static Options cliOptions;
    boolean printHelp = false;
    boolean listProfiles = false;
    boolean printProfile = false;
    boolean createProfile = false;
    boolean deleteProfile = false;
    String profileName = null;
    ProfileType newProfileType = null;
    String newProfileHostname = null;
    boolean dontTest;
    boolean newProfileRequireSSL = false;
    String newProfileTenant = null;
    String newProfileNamespace = null;
    String newProfileUsername = null;
    String newProfilePassword = null;
    List<String> newProfileIPList = null;
    boolean newProfileUseIPs = false;
    Integer newProfilePort = null;
    boolean authAnon = false;
    boolean validateCustomMetadata = true;
    private Map<String, Integer> columnWidths;
    public static final String COL_SEP = "  ";
    public static final String KEY_PROFILE_NAME = "Name";
    public static final String KEY_PROFILE_ID = "ID";
    public static final String KEY_TYPE = "Type";
    public static final String KEY_HOSTNAME = "Host Name";
    public static final String KEY_TENANT = "Tenant";
    public static final String KEY_NAMESPACE = "Namespace";
    public static final String KEY_USERNAME = "User Name";
    public static final String KEY_SSL = "SSL Enabled";
    public static final boolean ALLOW_PORT;

    public ArcProfileMgr(String[] args) {
        super(args);
        ProfileManager.initialize(new AbstractArcCli.ArcCliSSLCertificateCallback(true));
        HELP_USAGE_LINE = commandName + " profile -c <profile_name> | -d <profile_name> | -l [profile_name] [options]";
    }

    @Override
    public Options getOptions() {
        if (cliOptions == null) {
            Options options = new Options();
            OptionGroup operations = new OptionGroup();
            OptionBuilder.withDescription((String)"Displays this help text (the default behavior).");
            OptionBuilder.withLongOpt((String)"help");
            operations.addOption(OptionBuilder.create((String)"h"));
            OptionBuilder.hasOptionalArg();
            OptionBuilder.withArgName((String)"profile_name");
            OptionBuilder.withDescription((String)"Lists information about the specified namespace profile.  If <profile_name> is omitted, lists information about all namespace profiles.");
            OptionBuilder.withLongOpt((String)"list");
            operations.addOption(OptionBuilder.create((String)"l"));
            OptionBuilder.hasArg();
            OptionBuilder.withArgName((String)"profile_name");
            OptionBuilder.withDescription((String)"Deletes the specified namespace profile.");
            OptionBuilder.withLongOpt((String)"delete");
            operations.addOption(OptionBuilder.create((String)"d"));
            OptionBuilder.hasArg();
            OptionBuilder.withArgName((String)"profile_name");
            OptionBuilder.withDescription((String)"Creates a namespace profile with the specified name.");
            OptionBuilder.withLongOpt((String)"create");
            operations.addOption(OptionBuilder.create((String)"c"));
            options.addOptionGroup(operations);
            String profileTypesToString = "Type of namespace for which you are creating the namespace profile: ";
            for (ProfileType type : ProfileType.values()) {
                if (type == ProfileType.FILESYSTEM) continue;
                profileTypesToString = profileTypesToString + type.toString() + " | ";
            }
            profileTypesToString = profileTypesToString.substring(0, profileTypesToString.length() - 3);
            OptionBuilder.withArgName((String)"profile_type");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)profileTypesToString);
            OptionBuilder.withLongOpt((String)"type");
            options.addOption(OptionBuilder.create());
            OptionBuilder.withArgName((String)"tenant_name");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Name of the tenant that owns the namespace for which you are creating the namespace profile.");
            OptionBuilder.withLongOpt((String)"tenant");
            options.addOption(OptionBuilder.create());
            OptionBuilder.withArgName((String)"namespace_name");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Name of the namespace for which you are creating the namespace profile.");
            OptionBuilder.withLongOpt((String)"namespace");
            options.addOption(OptionBuilder.create());
            OptionBuilder.withArgName((String)"username");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Username of the data access account to use for namespace access.");
            OptionBuilder.withLongOpt((String)"username");
            options.addOption(OptionBuilder.create());
            OptionBuilder.withArgName((String)"password");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Password of the data access account to use for namespace access.");
            OptionBuilder.withLongOpt((String)"password");
            options.addOption(OptionBuilder.create());
            OptionBuilder.withArgName((String)"hostname");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"The fully qualified domain name of the HCP system.");
            OptionBuilder.withLongOpt((String)"hostname");
            options.addOption(OptionBuilder.create());
            OptionBuilder.withDescription((String)"Tells HCP-DM to use SSL when communicating with the HCP system.");
            OptionBuilder.withLongOpt((String)"ssl");
            options.addOption(OptionBuilder.create());
            OptionBuilder.withDescription((String)"Tells HCP-DM to check whether custom metadata XML is well-formed prior to communicating with the HCP system.");
            OptionBuilder.withLongOpt((String)"check-cm");
            options.addOption(OptionBuilder.create());
            OptionBuilder.withDescription((String)"Log into namespace anonymously.  Only valid with HCP 5.0 or later profile.");
            OptionBuilder.withLongOpt((String)"anon");
            options.addOption(OptionBuilder.create());
            OptionBuilder.withDescription((String)"Does not test if the namespace configuration provided can access HCP while creating the profile.");
            OptionBuilder.withLongOpt((String)"notest");
            options.addOption(OptionBuilder.create());
            OptionBuilder.withArgName((String)"address1[,address2]...");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Comma-separated list of one or more IP addresses to use to connect to the HCP system.  If omitted, HCP-DM uses the hostname.");
            OptionBuilder.withLongOpt((String)"ips");
            options.addOption(OptionBuilder.create());
            if (ALLOW_PORT) {
                OptionBuilder.withArgName((String)"port");
                OptionBuilder.hasArg();
                OptionBuilder.withDescription((String)"Port to connect to HCP on");
                OptionBuilder.withLongOpt((String)"port");
                options.addOption(OptionBuilder.create());
            }
            cliOptions = options;
        }
        return cliOptions;
    }

    @Override
    public String getHelpFooter() {
        return HELP_FOOTER;
    }

    @Override
    public String getHelpHeader() {
        return HELP_HEADER;
    }

    @Override
    public String getHelpUsageLine() {
        return HELP_USAGE_LINE;
    }

    public static void main(String[] args) {
        ArcProfileMgr arcProfileMgr = null;
        ConfigurationHelper.validateLaunchOK();
        try {
            arcProfileMgr = new ArcProfileMgr(args);
            arcProfileMgr.parseArgs();
            if (arcProfileMgr.printHelp) {
                System.out.println(arcProfileMgr.helpScreen());
            } else {
                arcProfileMgr.execute(new PrintWriter(System.out), new PrintWriter(System.err));
            }
        }
        catch (ParseException e) {
            System.out.println("Error: " + e.getMessage());
            System.out.println();
            System.out.println(arcProfileMgr.helpScreen());
            arcProfileMgr.setExitCode(1);
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Unexpected Exception.", e);
            System.out.println();
            System.out.println("Failed to create a new profile " + e.getMessage());
            arcProfileMgr.setExitCode(4);
        }
        finally {
            if (arcProfileMgr != null) {
                arcProfileMgr.exit();
            }
        }
    }

    @Override
    protected void parseArgs() throws ParseException {
        PosixParser parser = new PosixParser();
        CommandLine cmdLine = parser.parse(this.getOptions(), this.getArgs());
        List argList = cmdLine.getArgList();
        this.printHelp = cmdLine.hasOption("h");
        if (this.printHelp) {
            return;
        }
        this.listProfiles = cmdLine.hasOption("l");
        this.printProfile = cmdLine.hasOption("p");
        this.createProfile = cmdLine.hasOption("c");
        this.deleteProfile = cmdLine.hasOption("d");
        if (this.listProfiles && this.printProfile || this.listProfiles && this.createProfile || this.listProfiles && this.createProfile || this.printProfile && this.createProfile || this.printProfile && this.deleteProfile || this.createProfile && this.deleteProfile) {
            throw new ParseException(" You may not specify more than one '-lpcd' option");
        }
        if (this.printProfile) {
            this.profileName = ArcProfileMgr.getProfileNameFromCmdLineAndValidateExistance(cmdLine, "p");
        }
        if (this.createProfile) {
            this.profileName = ArcProfileMgr.getProfileNameAndValidateItDoesNotExist(cmdLine, "c");
            this.newProfileType = this.validateProfileType(cmdLine);
            this.dontTest = cmdLine.hasOption("notest");
            this.authAnon = cmdLine.hasOption("anon");
            this.validateCustomMetadata = cmdLine.hasOption("check-cm");
            this.newProfileIPList = this.validateIPs(cmdLine);
            boolean bl = this.newProfileUseIPs = this.newProfileIPList != null && this.newProfileIPList.size() > 0;
            if (this.newProfileType.equals((Object)HCAPProfile.HCAP_TYPE) || this.newProfileType.equals((Object)Hcp3DefaultNamespaceProfile.HCAP_TYPE)) {
                if (!this.newProfileUseIPs) {
                    this.newProfileHostname = this.validateHostname(cmdLine);
                }
                this.newProfileRequireSSL = this.validateRequireSSL(cmdLine);
                if (this.authAnon) {
                    throw new ParseException("Anonymous access only allowed with HCP 5.0 or later profile type.");
                }
            } else if (this.newProfileType.equals((Object)Hcp3AuthNamespaceProfile.HCAP_TYPE) || this.newProfileType.equals((Object)Hcp5AuthNamespaceProfile.HCAP_TYPE) || this.newProfileType.equals((Object)Hcp6AuthNamespaceProfile.HCAP_TYPE)) {
                this.newProfileHostname = this.validateHostname(cmdLine);
                this.newProfileRequireSSL = this.validateRequireSSL(cmdLine);
                this.newProfileTenant = this.validateTenant(cmdLine);
                this.newProfileNamespace = this.validateNamespace(cmdLine);
                if (this.authAnon) {
                    if (cmdLine.hasOption("username") || cmdLine.hasOption("password")) {
                        throw new ParseException("Cannot specify ANON and a username or password!");
                    }
                } else {
                    this.newProfileUsername = this.validateUsername(cmdLine);
                    this.newProfilePassword = this.validatePassword(cmdLine);
                }
            }
            if (ALLOW_PORT) {
                this.newProfilePort = this.validatePort(cmdLine);
            }
        }
        if (this.deleteProfile) {
            this.profileName = ArcProfileMgr.getProfileNameFromCmdLineAndValidateExistance(cmdLine, "d");
            if (this.profileName.equalsIgnoreCase(LFS) || this.profileName.equalsIgnoreCase("Local File System")) {
                throw new ParseException("Cannot delete the default file system profile.");
            }
        }
        if (this.listProfiles) {
            String namePassedIn;
            if (argList.size() > 1) {
                throw new ParseException("-l takes 0 or 1 arguments");
            }
            if (argList.size() == 1 && (namePassedIn = cmdLine.getOptionValue('l')) != null) {
                this.listProfiles = false;
                this.printProfile = true;
                this.profileName = ArcProfileMgr.validateProfileNameExists(namePassedIn);
            }
        }
    }

    public ProfileType validateProfileType(CommandLine cmdLine) throws ParseException {
        String option = "type";
        if (!cmdLine.hasOption(option)) {
            throw new ParseException("Missing Option: " + option);
        }
        String value = cmdLine.getOptionValue(option);
        ProfileType retval = null;
        boolean validType = false;
        for (ProfileType type : ProfileType.values()) {
            if (!type.toString().equals(value) || type == ProfileType.FILESYSTEM) continue;
            validType = true;
        }
        if (!validType) {
            throw new ParseException("Invalid Profile Type: " + value);
        }
        retval = ProfileType.valueOf(value);
        if (retval == null) {
            throw new ParseException("Invalid Profile Type: " + (Object)((Object)this.newProfileType));
        }
        return retval;
    }

    public List<String> validateIPs(CommandLine cmdLine) throws ParseException {
        String value;
        String[] ipArray;
        ArrayList<String> ipList = null;
        String option = "ips";
        if (cmdLine.hasOption(option) && (ipArray = org.apache.commons.lang.StringUtils.split((String)(value = cmdLine.getOptionValue(option)), (String)",")) != null) {
            ipList = new ArrayList<String>();
            for (int i = 0; i < ipArray.length; ++i) {
                ipList.add(ipArray[i]);
            }
        }
        return ipList;
    }

    public String validateHostname(CommandLine cmdLine) throws ParseException {
        String option = "hostname";
        if (!cmdLine.hasOption(option)) {
            throw new ParseException("Missing Option: " + option);
        }
        String value = cmdLine.getOptionValue(option);
        String retval = null;
        if (value != null) {
            retval = value;
        }
        if (retval == null) {
            throw new ParseException("Invalid " + option + " : " + value);
        }
        return retval;
    }

    public boolean validateRequireSSL(CommandLine cmdLine) throws ParseException {
        String option = "ssl";
        return cmdLine.hasOption(option);
    }

    public Integer validatePort(CommandLine cmdLine) throws ParseException {
        String option = "port";
        if (!cmdLine.hasOption(option)) {
            return null;
        }
        Integer port = null;
        String value = cmdLine.getOptionValue(option);
        if (value != null) {
            try {
                port = Integer.valueOf(value);
                if (port < 0) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException nfe) {
                throw new ParseException("Invalid " + option + " : " + value);
            }
        }
        return port;
    }

    public String validateTenant(CommandLine cmdLine) throws ParseException {
        String option = "tenant";
        if (!cmdLine.hasOption(option)) {
            throw new ParseException("Missing Option: " + option);
        }
        String value = cmdLine.getOptionValue(option);
        String retval = null;
        if (value != null) {
            retval = value;
        }
        if (retval == null) {
            throw new ParseException("Invalid " + option + " : " + value);
        }
        return retval;
    }

    public String validateNamespace(CommandLine cmdLine) throws ParseException {
        String option = "namespace";
        if (!cmdLine.hasOption(option)) {
            throw new ParseException("Missing Option: " + option);
        }
        String value = cmdLine.getOptionValue(option);
        String retval = null;
        if (value != null) {
            retval = value;
        }
        if (retval == null) {
            throw new ParseException(HELP_FOOTER);
        }
        return retval;
    }

    public String validateUsername(CommandLine cmdLine) throws ParseException {
        String option = "username";
        if (!cmdLine.hasOption(option)) {
            throw new ParseException("Missing Option: " + option);
        }
        String value = cmdLine.getOptionValue(option);
        String retval = null;
        if (value != null) {
            retval = value;
        }
        if (retval == null) {
            throw new ParseException("Invalid " + option + " : " + value);
        }
        return retval;
    }

    public String validatePassword(CommandLine cmdLine) throws ParseException {
        String option = "password";
        if (!cmdLine.hasOption(option)) {
            throw new ParseException("Missing Option: " + option);
        }
        String value = cmdLine.getOptionValue(option);
        String retval = null;
        if (value != null) {
            retval = Hcp3AuthNamespaceProfile.getMD5Password(value.toCharArray());
        }
        if (retval == null) {
            throw new ParseException("Invalid " + option + " : " + value);
        }
        return retval;
    }

    @Override
    public void execute(PrintWriter out, PrintWriter err) {
        StrBuilder output = new StrBuilder();
        if (this.listProfiles) {
            output.append(this.createProfileListing());
        } else if (this.printProfile) {
            output.append(this.getProfileDetails(this.profileName));
        } else if (this.createProfile) {
            output.append(this.createProfile());
        } else if (this.deleteProfile) {
            output.append(this.deleteProfile());
        } else {
            output.append(this.helpScreen());
        }
        out.println(output.toString());
        out.flush();
        err.flush();
    }

    protected List<AbstractProfileBase> getProfiles() {
        List<AbstractProfileBase> profileList = ProfileManager.getProfiles();
        profileList.add(0, FileSystemProfile.LOCAL_FILESYSTEM_PROFILE);
        return profileList;
    }

    protected String deleteProfile() {
        StrBuilder output = new StrBuilder();
        AbstractProfileBase profile = ProfileManager.getProfileByName(this.profileName);
        try {
            ProfileManager.deleteProfile(profile, true);
        }
        catch (Exception e) {
            String errMsg = "Error deleting profile '" + profile + "'";
            errMsg = DBUtils.getErrorMessage(errMsg, e);
            LOG.log(Level.WARNING, errMsg, e);
            output.append(errMsg);
            this.setExitCode(4);
        }
        return output.toString();
    }

    protected String createProfile() {
        StrBuilder output = new StrBuilder();
        AbstractProfileBase profile = ProfileManager.getInstance().createProfile(this.newProfileType);
        profile.setName(this.profileName);
        if (profile instanceof HCAPProfile) {
            HCAPProfile fcfsProfile = (HCAPProfile)profile;
            fcfsProfile.setSSLRequired(this.newProfileRequireSSL);
            fcfsProfile.setValidateCustomMetadata(this.validateCustomMetadata);
            if (this.newProfileUseIPs) {
                fcfsProfile.setIpAddressList(this.newProfileIPList);
                fcfsProfile.setConnectByDns(false);
            } else {
                fcfsProfile.setHostname(this.newProfileHostname);
            }
            fcfsProfile.setPort(this.newProfilePort);
        }
        if (profile instanceof Hcp3AuthNamespaceProfile || profile instanceof Hcp5AuthNamespaceProfile) {
            Hcp3AuthNamespaceProfile restProfile = (Hcp3AuthNamespaceProfile)profile;
            restProfile.setHostname(this.newProfileHostname);
            restProfile.setTenant(this.newProfileTenant);
            restProfile.setNamespace(this.newProfileNamespace);
            if (!restProfile.getType().supportsAnonymousAccess() && this.authAnon) {
                String errMsg = "Profile does not support anonymous access.";
                LOG.log(Level.WARNING, errMsg, "errMsg");
                output.append(errMsg);
                this.setExitCode(4);
            }
            if (restProfile.getType().supportsAnonymousAccess() && this.authAnon) {
                Hcp5AuthNamespaceProfile hcp5profile = (Hcp5AuthNamespaceProfile)restProfile;
                hcp5profile.setAnonymousAccess(true);
            } else {
                restProfile.setUsername(this.newProfileUsername);
                restProfile.setPassword(this.newProfilePassword);
            }
        }
        String badConnectionErrMsg = "Error connecting using the values passed in";
        try {
            boolean canConnect = true;
            if (!this.dontTest) {
                ArcMoverEngine arcMover = ArcMoverFactory.getInstance();
                canConnect = arcMover.testConnection(profile);
            }
            if (canConnect) {
                ProfileManager.saveProfile(profile);
            } else {
                output.append(badConnectionErrMsg);
            }
        }
        catch (ConfigurationException e) {
            String errMsg = "Error updating/saving new Profile: " + profile;
            LOG.log(Level.WARNING, errMsg, e);
            output.append(errMsg);
            this.setExitCode(4);
        }
        catch (ConnectionTestException e) {
            LOG.log(Level.WARNING, badConnectionErrMsg, e);
            output.append(badConnectionErrMsg + ": " + e.getMessage());
            this.setExitCode(4);
        }
        return output.toString();
    }

    protected String getProfileDetails(String profileName) {
        StrBuilder output = new StrBuilder();
        AbstractProfileBase profile = ProfileManager.getProfileByName(profileName);
        if (profile == null) {
            output.append("Profile does not exist: ").append(profileName);
            output.append(NEWLINE);
            output.append(this.helpScreen());
        } else {
            output.append("Name        : ").append(profile.getName()).append(" ").append(NEWLINE);
            output.append("Type        : ").append((Object)profile.getType()).append(" ").append(NEWLINE);
            if (profile instanceof HCAPProfile) {
                HCAPProfile fcfsProfile = (HCAPProfile)profile;
                if (fcfsProfile.isConnectByDns() || fcfsProfile.isAuthNamespace()) {
                    output.append("Domain Name : ").append(fcfsProfile.getHostname()).append(" ").append(NEWLINE);
                }
                if (!fcfsProfile.isConnectByDns()) {
                    output.append("IP List     : ").append(StringUtils.createCSV(fcfsProfile.getIpAddressList())).append(" ").append(NEWLINE);
                }
                output.append("SSL         : ");
                if (fcfsProfile.isSSLRequired()) {
                    output.append("Enabled");
                } else {
                    output.append("Disabled");
                }
                output.append(" ").append(NEWLINE);
                output.append("Validate CM : ");
                if (fcfsProfile.isValidateCustomMetadata()) {
                    output.append("Enabled");
                } else {
                    output.append("Disabled");
                }
                output.append(" ").append(NEWLINE);
                if (ALLOW_PORT) {
                    output.append("Port        : ").append(fcfsProfile.getPort()).append(" ").append(NEWLINE);
                }
            }
            if (profile instanceof Hcp3AuthNamespaceProfile) {
                Hcp3AuthNamespaceProfile restProfile = (Hcp3AuthNamespaceProfile)profile;
                output.append("Tenant      : ").append(restProfile.getTenant()).append(" ").append(NEWLINE);
                output.append("Namespace   : ").append(restProfile.getNamespace()).append(" ").append(NEWLINE);
                output.append("User Name   : ").append(restProfile.getUsername()).append(" ").append(NEWLINE);
            }
        }
        return output.toString();
    }

    protected String createProfileListing() {
        StrBuilder sb = new StrBuilder();
        List<AbstractProfileBase> profileList = this.getProfiles();
        this.columnWidths = this.calcColumnWidths(profileList);
        for (Map.Entry<String, Integer> entry : this.columnWidths.entrySet()) {
            sb.appendFixedWidthPadRight((Object)entry.getKey(), entry.getValue().intValue(), ' ').append(COL_SEP);
        }
        sb.append(NEWLINE);
        for (AbstractProfileBase profile : profileList) {
            sb.appendFixedWidthPadRight((Object)(HELP_FOOTER + profile.getName()), this.columnWidths.get(KEY_PROFILE_NAME).intValue(), ' ').append(COL_SEP);
            sb.appendFixedWidthPadRight((Object)(HELP_FOOTER + (Object)((Object)profile.getType())), this.columnWidths.get(KEY_TYPE).intValue(), ' ').append(COL_SEP);
            sb.append(NEWLINE);
        }
        return sb.toString();
    }

    protected Map<String, Integer> calcColumnWidths(List<AbstractProfileBase> profileList) {
        LinkedHashMap<String, Integer> columnWidths = new LinkedHashMap<String, Integer>();
        columnWidths.put(KEY_PROFILE_NAME, KEY_PROFILE_NAME.length());
        columnWidths.put(KEY_TYPE, KEY_TYPE.length());
        String key = null;
        for (AbstractProfileBase profile : profileList) {
            key = KEY_PROFILE_NAME;
            columnWidths.put(key, Math.max((Integer)columnWidths.get(key), (HELP_FOOTER + profile.getName()).length()));
            key = KEY_TYPE;
            columnWidths.put(key, Math.max((Integer)columnWidths.get(key), (HELP_FOOTER + (Object)((Object)profile.getType())).length()));
        }
        return columnWidths;
    }

    static {
        ALLOW_PORT = Boolean.getBoolean("portChoice");
        cliOrder.put("help", 0);
        cliOrder.put("list", 1);
        cliOrder.put("delete", 2);
        cliOrder.put("create", 3);
        cliOrder.put("type", 4);
        cliOrder.put("hostname", 5);
        cliOrder.put("ips", 6);
        cliOrder.put("tenant", 7);
        cliOrder.put("namespace", 8);
        cliOrder.put("username", 9);
        cliOrder.put("password", 10);
        cliOrder.put("anon", 11);
        cliOrder.put("ssl", 12);
        cliOrder.put("check-cm", 13);
        cliOrder.put("notest", 14);
        if (ALLOW_PORT) {
            cliOrder.put("port", 15);
        }
    }
}

