/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcmover.cli;

import com.archivas.clienttools.arcmover.cli.AbstractArcCli;
import com.archivas.clienttools.arcmover.cli.ArcCopy;
import com.archivas.clienttools.arcmover.cli.ArcDelete;
import com.archivas.clienttools.arcmover.cli.ArcMetadata;
import com.archivas.clienttools.arcutils.api.ArcMoverEngine;
import com.archivas.clienttools.arcutils.api.ArcMoverFactory;
import com.archivas.clienttools.arcutils.api.JobException;
import com.archivas.clienttools.arcutils.api.JobId;
import com.archivas.clienttools.arcutils.api.JobNotFoundException;
import com.archivas.clienttools.arcutils.api.JobStatus;
import com.archivas.clienttools.arcutils.api.ManagedJobStats;
import com.archivas.clienttools.arcutils.api.jobs.ManagedJob;
import com.archivas.clienttools.arcutils.api.jobs.ManagedJobSummary;
import com.archivas.clienttools.arcutils.config.ConfigurationHelper;
import com.archivas.clienttools.arcutils.impl.adapter.ConnectionTestException;
import com.archivas.clienttools.arcutils.impl.adapter.StorageAdapter;
import com.archivas.clienttools.arcutils.impl.adapter.StorageAdapterMgr;
import com.archivas.clienttools.arcutils.impl.jobs.FileStats;
import com.archivas.clienttools.arcutils.impl.jobs.ManagedJobImpl;
import com.archivas.clienttools.arcutils.model.LoadSchedule;
import com.archivas.clienttools.arcutils.profile.AbstractProfileBase;
import com.archivas.clienttools.arcutils.utils.FileUtil;
import com.archivas.clienttools.arcutils.utils.database.DatabaseException;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.lang.StringUtils;

public abstract class ManagedCLIJob
extends AbstractArcCli {
    public static final String PACKAGE_NAME = ArcCopy.class.getPackage().getName();
    public static final String CLASS_FULL_NAME = ArcCopy.class.getName();
    public static final String CLASS_NAME = CLASS_FULL_NAME.substring(PACKAGE_NAME.length() + 1);
    public static Logger LOG = Logger.getLogger(CLASS_FULL_NAME);
    protected int numCmdLineArgs;
    protected static String HELP_USAGE_LINE;
    protected static String HELP_HEADER;
    protected static String HELP_FOOTER;
    protected static String HELP_OPTION;
    protected static String MAX_CONNECTIONS;
    protected static String MAX_NODE_CONNECTIONS;
    protected static String REDUCED_MAX_CONNECTIONS;
    protected static String REDUCED_MAX_NODE_CONNECTIONS;
    protected static String REDUCED_START;
    protected static String REDUCED_END;
    protected static String EXPORT_RESULTS_TYPE;
    protected static String EXPORT_RESULTS_PATH;
    protected static String EXPORT_RESULTS_PREFIX;
    protected static String IGNORE_CONFLICTS;
    protected static String JOB_NAME;
    protected static String RERUN;
    protected static String RESUME;
    public static final String JOB_TYPE_METADATA = "Metadata";
    public static final String JOB_TYPE_DELETE = "Delete";
    public static final String JOB_TYPE_COPY = "Copy";
    ArcMoverEngine arcMover = ArcMoverFactory.getInstance();
    ManagedJobImpl managedJobImpl = null;
    ManagedJob managedJob = null;
    boolean printHelp = false;
    boolean isFirstStatusLine = true;
    protected static SimpleDateFormat timeFormat;
    ExportResults exportResults;

    public ManagedCLIJob(String[] args, int numCmdLineArgs) {
        super(args);
        this.numCmdLineArgs = numCmdLineArgs;
    }

    @Override
    public String getHelpFooter() {
        return HELP_FOOTER;
    }

    @Override
    public String getHelpHeader() {
        return HELP_HEADER;
    }

    @Override
    public String getHelpUsageLine() {
        return HELP_USAGE_LINE;
    }

    protected boolean shouldPrintHelp() {
        return this.printHelp;
    }

    public static void main(String[] args) {
        if (LOG.isLoggable(Level.FINE)) {
            StringBuffer sb = new StringBuffer();
            sb.append("Program Arguments").append(NEWLINE);
            for (int i = 0; i < args.length; ++i) {
                sb.append("    ").append(i).append(": ").append(args[i]);
                sb.append(NEWLINE);
            }
            LOG.log(Level.FINE, sb.toString());
        }
        ConfigurationHelper.validateLaunchOK();
        AbstractArcCli arcCmd = null;
        try {
            if (args[0].equals("copy")) {
                arcCmd = new ArcCopy(args, 2);
            } else if (args[0].equals("delete")) {
                arcCmd = new ArcDelete(args, 2);
            } else if (args[0].equals("metadata")) {
                arcCmd = new ArcMetadata(args, 2);
            } else {
                throw new RuntimeException("Unsupported operation: " + args[0]);
            }
            arcCmd.parseArgs();
            if (((ManagedCLIJob)arcCmd).shouldPrintHelp()) {
                System.out.println(arcCmd.helpScreen());
            } else {
                ((ManagedCLIJob)arcCmd).execute(new PrintWriter(System.out), new PrintWriter(System.err));
            }
        }
        catch (org.apache.commons.cli.ParseException e) {
            System.out.println("Error: " + e.getMessage());
            System.out.println();
            System.out.println(arcCmd.helpScreen());
            arcCmd.setExitCode(1);
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, e.getMessage(), e);
            System.out.println();
            System.err.println("Job failed.  " + e.getMessage());
            if (arcCmd != null) {
                arcCmd.setExitCode(4);
            }
        }
        finally {
            if (arcCmd != null) {
                arcCmd.exit();
            }
        }
    }

    protected void getSharedOptions(Options options) {
        OptionBuilder.withArgName((String)"results_path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Directory in which to store the exported results lists.  If omitted, defaults to the current directory.");
        OptionBuilder.withLongOpt((String)EXPORT_RESULTS_PATH);
        options.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"string");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Prefix for the results lists file names.  If omitted, results lists file names have no prefix.");
        OptionBuilder.withLongOpt((String)EXPORT_RESULTS_PREFIX);
        options.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"integer");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Maximum number of connections per HCP system node.  Valid range is from 1 to 100.  If omitted, defaults to 25.");
        OptionBuilder.withLongOpt((String)MAX_NODE_CONNECTIONS);
        options.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"integer");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Maximum number of connections to the HCP system.  Valid range is from 2 to 1000.  If omitted, defaults to 200");
        OptionBuilder.withLongOpt((String)MAX_CONNECTIONS);
        options.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"integer");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Maximum number of connections per HCP system node during reduced load.  Valid range is from 1 to 100.  If omitted, defaults to 4.");
        OptionBuilder.withLongOpt((String)REDUCED_MAX_NODE_CONNECTIONS);
        options.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"integer");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Maximum number of connections to the HCP system during reduced load.  Valid range is from 2 to 1000.  If omitted, defaults to 50.");
        OptionBuilder.withLongOpt((String)REDUCED_MAX_CONNECTIONS);
        options.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"hh:mm");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)("Start time for the reduced load.  If omitted, defaults to 08:00.  If " + REDUCED_END + " is also omitted, reduced load is off."));
        OptionBuilder.withLongOpt((String)REDUCED_START);
        options.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"hh:mm");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)("End time for the reduced load.  If omitted, defaults to 20:00.  If " + REDUCED_START + " is also omitted, reduced load is off."));
        OptionBuilder.withLongOpt((String)REDUCED_END);
        options.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"job_name");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"The name of the job.");
        OptionBuilder.withLongOpt((String)JOB_NAME);
        options.addOption(OptionBuilder.create());
        options.addOption(ManagedCLIJob.getInsecureSSLOption());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(PrintWriter out, PrintWriter err) throws Exception {
        ManagedJobStats jobStats;
        if (this.managedJob == null || this.managedJob.getSourceProfile() == null) {
            throw new org.apache.commons.cli.ParseException("Job not created during parsing of the commandline");
        }
        try {
            this.testConnection(this.managedJob.getSourceProfile());
            this.testConnection(this.managedJob.getTargetProfile());
        }
        catch (Exception e) {
            try {
                this.arcMover.removeManagedJob(this.managedJobImpl.getJobId(), this.managedJob.getJobType());
            }
            catch (Exception ex) {
                LOG.log(Level.WARNING, "An error occurred removing job " + this.managedJobImpl.getJob().getJobName() + ": " + ex.getMessage(), ex);
            }
            finally {
                this.managedJobImpl = null;
                throw e;
            }
        }
        if (this.managedJob.getJobType() == ManagedJob.Type.COPY && this.managedJob.getSourceProfile().getType().isLesserApiVersion(this.managedJob.getTargetProfile().getType())) {
            out.println(StringUtils.repeat((String)"*", (int)80));
            out.println("Copying objects to an earlier release of HCP results in loss of metadata that is");
            out.println("not supported by the earlier release.");
            out.println(StringUtils.repeat((String)"*", (int)80));
            out.println();
        }
        this.arcMover.startManagedJob(this.managedJobImpl);
        if (this.managedJobImpl.getStatus().isFinished()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        }
        while (!this.managedJobImpl.getStatus().isFinished()) {
            jobStats = this.arcMover.getManagedJobStats(this.managedJobImpl);
            out.print(this.buildProgressString(jobStats));
            out.flush();
            LOG.fine("Job Stats                : " + jobStats);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ex) {}
        }
        jobStats = this.arcMover.getManagedJobStats(this.managedJobImpl);
        out.print(this.buildProgressString(jobStats));
        LOG.fine("Job Stats                : " + jobStats);
        String details = this.generateDetails(this.arcMover.getManagedJobDetails(this.managedJobImpl, true));
        String summary = this.generateSummary(this.arcMover.getManagedJobStats(this.managedJobImpl), this.managedJob.getJobType());
        LOG.fine(details);
        LOG.info(summary);
        out.println(summary);
        if (this.exportResults.shouldExportResults()) {
            out.println("Exporting results");
            this.exportResults.exportResults();
        }
        if (jobStats.areErrors()) {
            this.setExitCode(5);
        }
        if (jobStats.getStatus().equals((Object)JobStatus.COMPLETED) && !jobStats.areErrors()) {
            try {
                this.arcMover.removeManagedJob(jobStats.getJobId(), this.managedJob.getJobType());
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "An error occurred removing job " + this.managedJobImpl.getJob().getJobName() + ": " + e.getMessage(), e);
            }
            finally {
                this.managedJobImpl = null;
            }
        }
        out.flush();
        err.flush();
    }

    protected void setUpExportListThread(CommandLine cmdLine) throws org.apache.commons.cli.ParseException {
        ArrayList<ExportListType> exportTypeList = new ArrayList<ExportListType>();
        String exportListPath = "";
        String exportListPrefix = "";
        if (cmdLine.hasOption(EXPORT_RESULTS_TYPE)) {
            String resultsListStr = cmdLine.getOptionValue(EXPORT_RESULTS_TYPE);
            if (resultsListStr.contains("ALL")) {
                for (ExportListType type : ExportListType.values()) {
                    if (type == ExportListType.CONFLICT && !this.supportsConflictReports()) continue;
                    exportTypeList.add(type);
                }
            } else {
                String[] resultsList;
                for (String type : resultsList = resultsListStr.split(",")) {
                    try {
                        ExportListType listType = ExportListType.valueOf(type.trim());
                        if (listType == ExportListType.CONFLICT && !this.supportsConflictReports()) {
                            throw new IllegalArgumentException();
                        }
                        exportTypeList.add(listType);
                    }
                    catch (IllegalArgumentException e) {
                        throw new org.apache.commons.cli.ParseException("Values provided for export-results does not match expected.");
                    }
                }
            }
        }
        if (cmdLine.hasOption(EXPORT_RESULTS_PATH)) {
            exportListPath = cmdLine.getOptionValue(EXPORT_RESULTS_PATH);
        }
        if (cmdLine.hasOption(EXPORT_RESULTS_PREFIX)) {
            exportListPrefix = cmdLine.getOptionValue(EXPORT_RESULTS_PREFIX);
        }
        try {
            this.exportResults = new ExportResults(exportListPath, exportListPrefix, exportTypeList.contains((Object)ExportListType.FAILURE), exportTypeList.contains((Object)ExportListType.SUCCESS), exportTypeList.contains((Object)ExportListType.JOBLIST), exportTypeList.contains((Object)ExportListType.CONFLICT));
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, "IOException caught when trying to create export files.  Make sure path is valid and writable", e);
            throw new org.apache.commons.cli.ParseException("IOException caught when trying to create export files.  Make sure path is valid and writable");
        }
    }

    protected void getLoadSchedule(CommandLine cmdLine, LoadSchedule result) throws org.apache.commons.cli.ParseException {
        if (result == null) {
            return;
        }
        if (cmdLine.hasOption(MAX_NODE_CONNECTIONS)) {
            result.setNormalLoadMaxConnPerNodeCount(new Integer(cmdLine.getOptionValue(MAX_NODE_CONNECTIONS)));
        }
        if (cmdLine.hasOption(MAX_CONNECTIONS)) {
            result.setNormalLoadMaxConnCount(new Integer(cmdLine.getOptionValue(MAX_CONNECTIONS)));
        }
        if (cmdLine.hasOption(REDUCED_MAX_NODE_CONNECTIONS)) {
            result.setLowLoadMaxConnPerNodeCount(new Integer(cmdLine.getOptionValue(REDUCED_MAX_NODE_CONNECTIONS)));
            result.setLowLoadEnabled(true);
        }
        if (cmdLine.hasOption(REDUCED_MAX_CONNECTIONS)) {
            result.setLowLoadMaxConnCount(new Integer(cmdLine.getOptionValue(REDUCED_MAX_CONNECTIONS)));
            result.setLowLoadEnabled(true);
        }
        if (cmdLine.hasOption(REDUCED_START)) {
            try {
                result.setLowLoadStartTime(timeFormat.parse(cmdLine.getOptionValue("reduced-start")));
                result.setLowLoadEnabled(true);
            }
            catch (ParseException e) {
                throw new org.apache.commons.cli.ParseException("Invalid format for start time.  Excpeted HH:mm");
            }
        }
        if (cmdLine.hasOption(REDUCED_END)) {
            try {
                result.setLowLoadEndTime(timeFormat.parse(cmdLine.getOptionValue("reduced-end")));
                result.setLowLoadEnabled(true);
            }
            catch (ParseException e) {
                throw new org.apache.commons.cli.ParseException("Invalid format for end time.  Excpeted HH:mm");
            }
        }
    }

    private String buildProgressString(ManagedJobStats stats) {
        StringBuilder sb = new StringBuilder();
        if (this.isFirstStatusLine) {
            this.isFirstStatusLine = false;
        } else {
            sb.append("\r");
        }
        sb.append(this.getFormattedJobStats(stats));
        return sb.toString();
    }

    private String generateSummary(ManagedJobStats jobStats, ManagedJob.Type jobType) {
        String totalObjectsLabel = "Total Objects to " + jobType.getUiName();
        if (JOB_TYPE_METADATA.equals(jobType.getUiName())) {
            totalObjectsLabel = "Total Objects to Change";
        }
        String longestLabel = totalObjectsLabel;
        StringBuilder pb = new StringBuilder();
        for (int i = 0; i < longestLabel.length(); ++i) {
            pb.append(" ");
        }
        String padding = pb.toString();
        StringBuilder sb = new StringBuilder();
        String newLine = NEWLINE;
        String spaces = String.format("%2s", " ");
        sb.append(newLine);
        sb.append(newLine);
        sb.append("Job Summary").append(newLine);
        sb.append(newLine);
        ManagedCLIJob.appendLabel(sb, "Status", padding);
        sb.append((Object)jobStats.getStatus());
        sb.append(newLine);
        ManagedCLIJob.appendLabel(sb, "Objects Found", padding);
        sb.append(jobStats.getDiscoveredObjectCount());
        sb.append(newLine);
        ManagedCLIJob.appendLabel(sb, totalObjectsLabel, padding);
        sb.append(jobStats.getTotalObjectCount());
        if (JOB_TYPE_COPY.equals(jobType.getUiName())) {
            sb.append(spaces + ", ");
            sb.append(jobStats.getTotalBytesInKB());
            sb.append(" KB");
        }
        sb.append(newLine);
        ManagedCLIJob.appendLabel(sb, "Successful", padding);
        sb.append(jobStats.getCompletedObjectCount());
        if (JOB_TYPE_COPY.equals(jobType.getUiName())) {
            sb.append(spaces + ", ");
            sb.append(jobStats.getCompletedBytesInKB());
            sb.append(" KB");
        }
        sb.append(newLine);
        ManagedCLIJob.appendLabel(sb, "Errors", padding);
        sb.append(jobStats.getErroredObjectCount());
        if (JOB_TYPE_COPY.equals(jobType.getUiName())) {
            sb.append(spaces + ", ");
            sb.append(jobStats.getErroredBytesInKB());
            sb.append(" KB");
        }
        sb.append(newLine);
        this.appendAdditionalOutput(jobStats, sb, padding);
        ManagedCLIJob.appendLabel(sb, "Total Time", padding);
        sb.append(jobStats.getRunTimeMs() / 1000L);
        sb.append(" seconds");
        sb.append(newLine);
        if (jobStats.getJobException() != null) {
            sb.append(newLine);
            ManagedCLIJob.appendLabel(sb, "Exception", padding);
            sb.append(jobStats.getJobException());
            StringWriter sw = new StringWriter();
            jobStats.getJobException().printStackTrace(new PrintWriter(sw));
            sb.append(newLine);
            sb.append(sw.toString());
        }
        return sb.toString();
    }

    protected static final StringBuilder appendLabel(StringBuilder sb, String label, String padding) {
        return sb.append(label).append(padding.substring(label.length())).append(" : ");
    }

    protected abstract void appendAdditionalOutput(ManagedJobStats var1, StringBuilder var2, String var3);

    protected abstract String getFormattedJobStats(ManagedJobStats var1);

    protected abstract String getErrorMessage();

    protected abstract ManagedJob.Type getJobType();

    protected abstract JobId getLastJobID() throws NumberFormatException;

    protected abstract boolean supportsConflictReports();

    private String generateDetails(ManagedJobImpl.JobDetails jobDetails) {
        String newLine = NEWLINE;
        StringBuilder sb = new StringBuilder();
        List<FileStats> errors = jobDetails.getObjectsFailed();
        for (FileStats fileStats : errors) {
            sb.append(fileStats.getDisplayUriRelativeToBasePath());
            sb.append(this.getErrorMessage());
            Throwable e = fileStats.getException();
            if (e == null) continue;
            sb.append(e.getMessage());
            sb.append(newLine);
        }
        if (sb.length() > 0) {
            sb.insert(0, newLine).insert(0, "Job Details ").insert(0, newLine);
        }
        return sb.toString();
    }

    protected boolean handleRerunAndResume(CommandLine cmdLine, LoadSchedule schedule) throws org.apache.commons.cli.ParseException {
        boolean result = false;
        String whichCmd = null;
        if (cmdLine.hasOption(RERUN) && cmdLine.hasOption(RESUME)) {
            throw new org.apache.commons.cli.ParseException("Cannot use both --resume and --rerun.  Please use just one.  Consult your manual if you have questions.");
        }
        if (cmdLine.hasOption(RERUN)) {
            whichCmd = RERUN;
        } else if (cmdLine.hasOption(RESUME)) {
            whichCmd = RESUME;
        }
        if (whichCmd != null) {
            try {
                this.managedJobImpl = this.getManagedJobImplFromCmdLine(cmdLine, whichCmd);
                if (whichCmd.equals(RERUN)) {
                    if (this.managedJobImpl.getStatus() != JobStatus.COMPLETED) {
                        throw new org.apache.commons.cli.ParseException("The job with this job name: \"" + this.managedJobImpl.getJob().getJobName() + "\" has not completed.  Please run this job using --resume.");
                    }
                    if (this.managedJobImpl.getFailedObjectCount() == 0L) {
                        throw new org.apache.commons.cli.ParseException("The job with this job name: \"" + this.managedJobImpl.getJob().getJobName() + "\" has already run to completion and has no failed files.");
                    }
                } else if (whichCmd.equals(RESUME) && this.managedJobImpl.getStatus() == JobStatus.COMPLETED) {
                    throw new org.apache.commons.cli.ParseException("The job with this job name: \"" + this.managedJobImpl.getJob().getJobName() + "\" has already run to completion.  Please run that job with --rerun if there were failed files.");
                }
                this.managedJob = this.managedJobImpl.getJob();
                if (cmdLine.hasOption(RERUN) || cmdLine.hasOption(RESUME)) {
                    LoadSchedule RerunResumeSchedule = this.managedJob.getLoadSchedule();
                    this.getLoadSchedule(cmdLine, RerunResumeSchedule);
                    this.managedJob.setLoadSchedule(RerunResumeSchedule);
                } else {
                    this.managedJob.setLoadSchedule(schedule);
                }
                this.arcMover.getManagedJobDetails(this.managedJobImpl, true);
                result = true;
            }
            catch (JobNotFoundException e) {
                throw new org.apache.commons.cli.ParseException("JobNotFoundException which trying to " + whichCmd + " a job.  Msg: " + e.getMessage());
            }
            catch (DatabaseException e) {
                throw new org.apache.commons.cli.ParseException("DatabaseException trying to get job to " + whichCmd + " a job.  Msg: " + e.getMessage());
            }
            catch (JobException e) {
                throw new org.apache.commons.cli.ParseException("JobException trying to initialize job to " + whichCmd + " .  Msg: " + e.getMessage());
            }
        }
        return result;
    }

    private ManagedJobImpl getManagedJobImplFromCmdLine(CommandLine cmdLine, String whichCmd) throws org.apache.commons.cli.ParseException, DatabaseException, JobException {
        JobId reRunJobID = null;
        String jobName = cmdLine.getOptionValue(whichCmd);
        if (jobName == null) {
            try {
                reRunJobID = this.getLastJobID();
            }
            catch (NumberFormatException e) {
                throw new org.apache.commons.cli.ParseException("Last job not found.  Either no jobs have been run or the job was deleted.");
            }
            if (reRunJobID == null) {
                throw new org.apache.commons.cli.ParseException("Error determining the last job run.");
            }
        } else {
            List<ManagedJobSummary> jobList = this.arcMover.getAllManagedJobs();
            for (ManagedJobSummary job : jobList) {
                if (!job.getJobName().equals(jobName)) continue;
                if (!job.getJobType().equals((Object)this.getJobType())) {
                    throw new org.apache.commons.cli.ParseException("Job name: " + jobName + " provided is not of type " + this.getJobType().getUiName());
                }
                reRunJobID = job.getJobId();
                break;
            }
            if (reRunJobID == null) {
                throw new org.apache.commons.cli.ParseException("Job name not found in job list.");
            }
        }
        return this.arcMover.loadManagedJob(reRunJobID, this.getJobType());
    }

    private void testConnection(AbstractProfileBase profile) throws JobException {
        boolean result = false;
        if (profile != null) {
            block6: {
                try {
                    StorageAdapter sourceAdapter = StorageAdapterMgr.getStorageAdapter(profile, null);
                    result = sourceAdapter.testConnection();
                }
                catch (ConnectionTestException e) {
                    String msg = null;
                    if (e.getMessage() != null) {
                        msg = e.getMessage();
                    }
                    if (e.getCause() != null && e.getCause() instanceof SSLPeerUnverifiedException) {
                        msg = msg + "  If SSL is enabled make sure you are using the --insecure flag.";
                    }
                    if (msg == null) break block6;
                    LOG.log(Level.WARNING, "Exception while connecting to profile: " + profile.getName() + ": " + msg, e);
                    throw new JobException(msg);
                }
            }
            if (!result) {
                throw new JobException("Cannot connect to profile: " + profile.getName() + ".");
            }
        }
    }

    static {
        HELP_HEADER = "";
        HELP_FOOTER = "";
        HELP_OPTION = "help";
        MAX_CONNECTIONS = "max-sys-ops";
        MAX_NODE_CONNECTIONS = "max-node-ops";
        REDUCED_MAX_CONNECTIONS = "reduced-max-sys-ops";
        REDUCED_MAX_NODE_CONNECTIONS = "reduced-max-node-ops";
        REDUCED_START = "reduced-start";
        REDUCED_END = "reduced-end";
        EXPORT_RESULTS_TYPE = "export-results";
        EXPORT_RESULTS_PATH = "export-results-path";
        EXPORT_RESULTS_PREFIX = "export-results-prefix";
        IGNORE_CONFLICTS = "ignore-conflicts";
        JOB_NAME = "job-name";
        RERUN = "rerun";
        RESUME = "resume";
        timeFormat = new SimpleDateFormat("HH:mm");
    }

    protected class ExportResults {
        private File copyListFile;
        private File successesFile;
        private File failuresFile;
        private File conflictsFile;
        boolean exportResults = false;

        public ExportResults(String path, String prefix, boolean exportFailures, boolean exportSuccessess, boolean exportJobList, boolean exportConflicts) throws IOException {
            if (exportFailures) {
                this.failuresFile = path == null || path.equals("") ? new File(prefix + "Failures.txt") : new File(FileUtil.resolvePath(path, prefix + "Failures.txt", File.separator));
                if (!this.failuresFile.exists()) {
                    this.failuresFile.createNewFile();
                }
            }
            if (exportSuccessess) {
                this.successesFile = path == null || path.equals("") ? new File(prefix + "Successes.txt") : new File(FileUtil.resolvePath(path, prefix + "Successes.txt", File.separator));
                if (!this.successesFile.exists()) {
                    this.successesFile.createNewFile();
                }
            }
            if (exportJobList) {
                this.copyListFile = path == null || path.equals("") ? new File(prefix + "JobList.txt") : new File(FileUtil.resolvePath(path, prefix + "JobList.txt", File.separator));
                if (!this.copyListFile.exists()) {
                    this.copyListFile.createNewFile();
                }
            }
            if (exportConflicts) {
                this.conflictsFile = path == null || path.equals("") ? new File(prefix + "Conflicts.txt") : new File(FileUtil.resolvePath(path, prefix + "Conflicts.txt", File.separator));
                if (!this.conflictsFile.exists()) {
                    this.conflictsFile.createNewFile();
                }
            }
            this.exportResults = this.copyListFile != null || this.successesFile != null || this.failuresFile != null || this.conflictsFile != null;
        }

        public boolean shouldExportResults() {
            return this.exportResults;
        }

        public void exportResults() {
            try {
                ManagedCLIJob.this.managedJobImpl.exportResults(this.copyListFile, this.successesFile, this.failuresFile, this.conflictsFile);
            }
            catch (DatabaseException e) {
                LOG.log(Level.INFO, "Export Results Thread Stopping: DatabaseException", e);
            }
        }
    }

    public static enum ExportListType {
        ALL,
        SUCCESS,
        FAILURE,
        JOBLIST,
        CONFLICT;

    }
}

