/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcmover.gui;

import com.archivas.clienttools.arcmover.gui.JobDialog;
import com.archivas.clienttools.arcmover.gui.MetadataJobDialog;
import com.archivas.clienttools.arcmover.gui.panels.CopyOptionsPanel;
import com.archivas.clienttools.arcutils.api.JobException;
import com.archivas.clienttools.arcutils.api.jobs.CopyJob;
import com.archivas.clienttools.arcutils.api.jobs.ManagedJob;
import com.archivas.clienttools.arcutils.impl.jobs.CopyJobImpl;
import com.archivas.clienttools.arcutils.profile.AbstractProfileBase;
import com.archivas.clienttools.arcutils.profile.FileSystemProfile;
import com.archivas.clienttools.arcutils.utils.database.DatabaseException;
import java.io.File;
import java.util.logging.Logger;
import javax.swing.JTabbedPane;

public class CopyJobDialog
extends MetadataJobDialog {
    public static Logger LOG = Logger.getLogger(CopyJobDialog.class.getName());
    public static final String OPTIONS_TAB_TITLE = "Options";
    private CopyOptionsPanel optionsPanel;
    private CopyJob copyJob;

    protected CopyJobDialog(CopyJobImpl jobImpl) throws DatabaseException, JobException {
        super(jobImpl);
        this.copyJob = jobImpl.getCopyJob();
    }

    protected CopyJobDialog(CopyJob job) throws DatabaseException, JobException {
        super(job);
        this.copyJob = job;
    }

    @Override
    protected boolean includeMetadataPanels() {
        AbstractProfileBase srcProfile = this.copyJob.getSourceProfile();
        AbstractProfileBase targetProfile = this.copyJob.getTargetProfile();
        return srcProfile instanceof FileSystemProfile && !(targetProfile instanceof FileSystemProfile);
    }

    @Override
    protected boolean supportsOwner() {
        AbstractProfileBase profile = this.copyJob.getTargetProfile();
        return profile.supportsOwner() && !profile.isAnonymousAccess();
    }

    @Override
    protected boolean supportsPosixSettings() {
        return this.copyJob.getTargetProfile().supportsPosixSettings();
    }

    @Override
    protected boolean indexSettingsEnabled() {
        return this.copyJob.getTargetProfile().supportsIndexingSettings();
    }

    @Override
    protected boolean supportsRetentionClasses() {
        return this.copyJob.getTargetProfile().supportsRetentionClasses();
    }

    @Override
    protected boolean supportsACLs() {
        return this.copyJob.getTargetProfile().supportsACLs();
    }

    @Override
    protected boolean validateCustomMetadata() {
        return this.copyJob.getTargetProfile().isValidateCustomMetadata();
    }

    @Override
    protected boolean isIngestJob() {
        return true;
    }

    @Override
    protected void addJobSpecificTabs(JTabbedPane tabbedPane, ManagedJob managedJob) throws DatabaseException, JobException {
        this.copyJob = (CopyJob)managedJob;
        this.optionsPanel = new CopyOptionsPanel(this, this.copyJob);
        tabbedPane.addTab(OPTIONS_TAB_TITLE, this.optionsPanel);
        super.addJobSpecificTabs(tabbedPane, managedJob);
    }

    @Override
    protected String getTitlePrefix() {
        return "Copy";
    }

    @Override
    protected void updateJobSpecificTabsState(boolean neverRun) {
        if (this.optionsPanel != null) {
            this.optionsPanel.enablePanel(neverRun);
        }
        super.updateJobSpecificTabsState(neverRun);
    }

    @Override
    protected void updateJobSpecForSpecificJob() throws DatabaseException, JobException {
        if (this.optionsPanel != null) {
            this.copyJob.setIgnoreConflicts(this.optionsPanel.getIgnoreConflicts());
        }
        super.updateJobSpecForSpecificJob();
    }

    @Override
    protected boolean hasTargetProfile() {
        return true;
    }

    public static void main(String[] args) {
        CopyJob job = new CopyJob(null, null, (File)null);
        try {
            JobDialog.openNewJob(job);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

