/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcmover.gui;

import com.archivas.clienttools.arcmover.gui.CopyJobDialog;
import com.archivas.clienttools.arcmover.gui.JobDialog;
import com.archivas.clienttools.arcmover.gui.panels.DeleteOptionsPanel;
import com.archivas.clienttools.arcutils.api.JobException;
import com.archivas.clienttools.arcutils.api.jobs.DeleteJob;
import com.archivas.clienttools.arcutils.api.jobs.ManagedJob;
import com.archivas.clienttools.arcutils.impl.jobs.DeleteJobImpl;
import com.archivas.clienttools.arcutils.profile.AbstractProfileBase;
import com.archivas.clienttools.arcutils.profile.Hcp3AuthNamespaceProfile;
import com.archivas.clienttools.arcutils.utils.database.DatabaseException;
import java.io.File;
import java.util.logging.Logger;
import javax.swing.JTabbedPane;

public class DeleteJobDialog
extends JobDialog {
    public static Logger LOG = Logger.getLogger(CopyJobDialog.class.getName());
    public static final String OPTIONS_TAB_TITLE = "Options";
    private DeleteOptionsPanel optionsPanel;
    private DeleteJob deleteJob;

    protected DeleteJobDialog(DeleteJobImpl jobImpl) throws DatabaseException, JobException {
        super(jobImpl);
        this.deleteJob = jobImpl.getDeleteJob();
    }

    protected DeleteJobDialog(DeleteJob job) throws DatabaseException, JobException {
        super(job);
        this.deleteJob = job;
    }

    @Override
    protected void addJobSpecificTabs(JTabbedPane tabbedPane, ManagedJob managedJob) throws DatabaseException {
        DeleteJob deleteJob = (DeleteJob)managedJob;
        AbstractProfileBase srcProfile = deleteJob.getSourceProfile();
        if (srcProfile instanceof Hcp3AuthNamespaceProfile) {
            this.optionsPanel = new DeleteOptionsPanel(this, deleteJob);
            tabbedPane.addTab(OPTIONS_TAB_TITLE, this.optionsPanel);
        }
    }

    @Override
    protected String getTitlePrefix() {
        return "Delete";
    }

    @Override
    protected void updateJobSpecificTabsState(boolean neverRun) {
        if (this.optionsPanel != null) {
            this.optionsPanel.enablePanel(neverRun);
        }
    }

    @Override
    protected void updateJobSpecForSpecificJob() throws DatabaseException {
        if (this.optionsPanel != null) {
            String reason;
            this.deleteJob.setOperation(this.optionsPanel.getOperation());
            this.deleteJob.setReason(this.optionsPanel.getReason());
            if (this.deleteJob.getOperation().isPrivilegedOperation() && ((reason = this.deleteJob.getReason()) == null || reason.trim().length() == 0)) {
                throw new IllegalStateException("You must enter a reason for all privileged operations.");
            }
        }
    }

    @Override
    protected boolean hasTargetProfile() {
        return false;
    }

    public static void main(String[] args) {
        DeleteJob job = new DeleteJob(null, (File)null);
        try {
            JobDialog.openNewJob(job);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

