/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcmover.gui;

import com.archivas.clienttools.arcmover.gui.HCPDataMigrator;
import com.archivas.clienttools.arcmover.gui.NoUserControlMessageDialog;
import com.archivas.clienttools.arcmover.gui.panels.FixedHeightPanel;
import com.archivas.clienttools.arcmover.gui.util.FixedWidthButton;
import com.archivas.clienttools.arcmover.gui.util.FixedWidthGroup;
import com.archivas.clienttools.arcmover.gui.util.FixedWidthPanel;
import com.archivas.clienttools.arcmover.gui.util.GUIHelper;
import com.archivas.clienttools.arcutils.config.HCPMoverProperties;
import com.archivas.clienttools.arcutils.impl.jobs.ManagedJobImpl;
import com.archivas.clienttools.arcutils.utils.database.DBUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import javax.swing.border.EmptyBorder;

public class ExportResultsDialog
extends JDialog {
    private static final Logger LOG = Logger.getLogger(ExportResultsDialog.class.getName());
    private JTextField dirField = new JTextField(40);
    private JButton browseButton = new FixedWidthButton("Browse", 100);
    private JTextField filePrefixField = new JTextField(30);
    private JCheckBox copyListCheckbox = new JCheckBox("Export job list", true);
    private JTextField copyListFileField = new JTextField("JobList.txt");
    private JCheckBox failuresCheckbox = new JCheckBox("Export failed job list", true);
    private JTextField failuresFileField = new JTextField("Failures.txt");
    private JCheckBox successesCheckbox = new JCheckBox("Export succeeded job list", true);
    private JTextField successesFileField = new JTextField("Successes.txt");
    private JCheckBox conflictsCheckbox = new JCheckBox("Export conflicts job list", true);
    private JTextField conflictsFileField = new JTextField("Conflicts.txt");
    private JButton exportButton = new FixedWidthButton("Export", 100);
    private JButton cancelButton = new FixedWidthButton("Cancel", 100);
    private ManagedJobImpl jobImpl;

    public ExportResultsDialog(ManagedJobImpl jobImpl) {
        this.jobImpl = jobImpl;
        this.setTitle("Export Results");
        this.setModal(true);
        this.layoutGuiComponents();
        String dirStr = HCPMoverProperties.CM_LOAD_LAST_DIRECTORY.get().trim();
        if (dirStr.length() > 0) {
            this.dirField.setText(dirStr);
        }
        this.copyListFileField.setEditable(false);
        this.failuresFileField.setEditable(false);
        this.successesFileField.setEditable(false);
        this.conflictsFileField.setEditable(false);
        this.setupListeners();
        this.pack();
    }

    private void layoutGuiComponents() {
        FixedWidthGroup group = new FixedWidthGroup();
        FixedHeightPanel dirPanel = new FixedHeightPanel();
        dirPanel.setLayout(new BoxLayout(dirPanel, 0));
        dirPanel.add(new FixedWidthPanel(group, (Component)new JLabel("Export to Directory")));
        dirPanel.add(Box.createHorizontalStrut(12));
        dirPanel.add(this.dirField);
        dirPanel.add(Box.createHorizontalStrut(12));
        dirPanel.add(this.browseButton);
        FixedHeightPanel filePrefixPanel = new FixedHeightPanel();
        filePrefixPanel.setLayout(new BoxLayout(filePrefixPanel, 0));
        filePrefixPanel.add(new FixedWidthPanel(group, (Component)new JLabel("File Prefix")));
        filePrefixPanel.add(Box.createHorizontalStrut(12));
        filePrefixPanel.add(this.filePrefixField);
        FixedWidthGroup exportGroup = new FixedWidthGroup();
        FixedHeightPanel exportPanel = new FixedHeightPanel();
        exportPanel.setLayout(new BoxLayout(exportPanel, 1));
        exportPanel.add(this.createCheckboxPanel(exportGroup, this.copyListCheckbox, this.copyListFileField));
        exportPanel.add(Box.createVerticalStrut(5));
        exportPanel.add(this.createCheckboxPanel(exportGroup, this.failuresCheckbox, this.failuresFileField));
        exportPanel.add(Box.createVerticalStrut(5));
        exportPanel.add(this.createCheckboxPanel(exportGroup, this.successesCheckbox, this.successesFileField));
        if (this.jobImpl.supportsConflictReports()) {
            exportPanel.add(Box.createVerticalStrut(5));
            exportPanel.add(this.createCheckboxPanel(exportGroup, this.conflictsCheckbox, this.conflictsFileField));
        }
        FixedHeightPanel buttonPanel = new FixedHeightPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.exportButton);
        buttonPanel.add(Box.createHorizontalStrut(12));
        buttonPanel.add(this.cancelButton);
        JPanel p = new JPanel();
        p.setBorder(new EmptyBorder(25, 25, 25, 25));
        p.setLayout(new BoxLayout(p, 1));
        p.add(dirPanel);
        p.add(Box.createVerticalStrut(5));
        p.add(filePrefixPanel);
        p.add(Box.createVerticalStrut(25));
        p.add(exportPanel);
        p.add(Box.createVerticalStrut(25));
        p.add(Box.createVerticalGlue());
        p.add(buttonPanel);
        this.getContentPane().add(p);
    }

    private JPanel createCheckboxPanel(FixedWidthGroup group, JCheckBox checkbox, JTextField fileNameField) {
        FixedHeightPanel p = new FixedHeightPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(new FixedWidthPanel(group, (Component)checkbox));
        p.add(Box.createHorizontalStrut(5));
        p.add(new JLabel("to:"));
        p.add(Box.createHorizontalStrut(12));
        p.add(fileNameField);
        return p;
    }

    private void setupListeners() {
        ActionListener checkboxListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportResultsDialog.this.exportButton.setEnabled(ExportResultsDialog.this.copyListCheckbox.isSelected() || ExportResultsDialog.this.failuresCheckbox.isSelected() || ExportResultsDialog.this.successesCheckbox.isSelected() || ExportResultsDialog.this.conflictsCheckbox.isSelected());
                ExportResultsDialog.this.copyListFileField.setEnabled(ExportResultsDialog.this.copyListCheckbox.isSelected());
                ExportResultsDialog.this.failuresFileField.setEnabled(ExportResultsDialog.this.failuresCheckbox.isSelected());
                ExportResultsDialog.this.successesFileField.setEnabled(ExportResultsDialog.this.successesCheckbox.isSelected());
                ExportResultsDialog.this.conflictsFileField.setEnabled(ExportResultsDialog.this.conflictsCheckbox.isSelected());
            }
        };
        this.copyListCheckbox.addActionListener(checkboxListener);
        this.failuresCheckbox.addActionListener(checkboxListener);
        this.successesCheckbox.addActionListener(checkboxListener);
        this.conflictsCheckbox.addActionListener(checkboxListener);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportResultsDialog.this.dispose();
            }
        });
        this.exportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportResultsDialog.this.exportResults();
            }
        });
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportResultsDialog.this.pickDirectory();
            }
        });
        this.filePrefixField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                String prefix = ExportResultsDialog.this.filePrefixField.getText().trim();
                ExportResultsDialog.this.copyListFileField.setText(prefix + "JobList.txt");
                ExportResultsDialog.this.failuresFileField.setText(prefix + "Failures.txt");
                ExportResultsDialog.this.successesFileField.setText(prefix + "Successes.txt");
                ExportResultsDialog.this.conflictsFileField.setText(prefix + "Conflicts.txt");
            }
        });
    }

    private void pickDirectory() {
        String loadPath = this.dirField.getText().trim();
        if (loadPath.length() == 0) {
            loadPath = HCPMoverProperties.CM_LOAD_LAST_DIRECTORY.get();
        }
        JFileChooser chooser = new JFileChooser(loadPath);
        chooser.setFileSelectionMode(1);
        int retVal = chooser.showOpenDialog(this);
        if (retVal == 0) {
            try {
                File f = chooser.getSelectedFile();
                this.dirField.setText(f.getPath());
            }
            catch (Exception e) {
                String msg = DBUtils.getErrorMessage("An error occurred selecting a directory", e);
                LOG.warning(msg);
                GUIHelper.showMessageDialog(this, msg, "Error Selecting Directory", 0);
            }
            HCPMoverProperties.CM_LOAD_LAST_DIRECTORY.set(chooser.getSelectedFile().getPath());
        }
    }

    private void exportResults() {
        String dirPath = this.dirField.getText().trim();
        if (dirPath.length() == 0) {
            JOptionPane.showMessageDialog(this, "You must specify a directory", "", 0);
            return;
        }
        File dir = new File(dirPath);
        if (!dir.exists() || !dir.isDirectory()) {
            JOptionPane.showMessageDialog(this, "The specified directory does not exist", "", 0);
            return;
        }
        File copyListFile = null;
        File failuresFile = null;
        File successesFile = null;
        File conflictsFile = null;
        if (this.copyListCheckbox.isSelected()) {
            copyListFile = new File(dir, this.copyListFileField.getText());
        }
        if (this.failuresCheckbox.isSelected()) {
            failuresFile = new File(dir, this.failuresFileField.getText());
        }
        if (this.successesCheckbox.isSelected()) {
            successesFile = new File(dir, this.successesFileField.getText());
        }
        if (this.jobImpl.supportsConflictReports() && this.conflictsCheckbox.isSelected()) {
            conflictsFile = new File(dir, this.conflictsFileField.getText());
        }
        this.exportResults(copyListFile, successesFile, failuresFile, conflictsFile);
        this.dispose();
    }

    private void exportResults(final File copyListFile, final File successesFile, final File failuresFile, final File conflictsFile) {
        this.getContentPane().setCursor(HCPDataMigrator.waitCursor);
        this.browseButton.setEnabled(false);
        this.exportButton.setEnabled(false);
        this.cancelButton.setEnabled(false);
        final NoUserControlMessageDialog pleaseWaitDialog = new NoUserControlMessageDialog((Component)this, "Exporting Results", "Exporting results, please wait.");
        SwingWorker sw = new SwingWorker(){
            private String finishMsg = "Completed exporting results";
            private boolean isError = false;

            protected Object doInBackground() throws Exception {
                try {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ExportResultsDialog.this.jobImpl.exportResults(copyListFile, successesFile, failuresFile, conflictsFile);
                }
                catch (Exception e) {
                    this.finishMsg = DBUtils.getErrorMessage("An error occurred exporting results", e);
                    this.isError = true;
                }
                return null;
            }

            @Override
            protected void done() {
                pleaseWaitDialog.setVisible(false);
                pleaseWaitDialog.dispose();
                GUIHelper.showMessageDialog(ExportResultsDialog.this, this.finishMsg, "Export Results Complete", this.isError ? 0 : 1);
                ExportResultsDialog.this.dispose();
            }
        };
        sw.execute();
        pleaseWaitDialog.setVisible(true);
    }
}

