/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcmover.gui;

import com.archivas.clienttools.arcmover.gui.AboutDialog;
import com.archivas.clienttools.arcmover.gui.ImportCopyJobDialog;
import com.archivas.clienttools.arcmover.gui.ImportDeleteJobDialog;
import com.archivas.clienttools.arcmover.gui.ImportJobDialog;
import com.archivas.clienttools.arcmover.gui.ImportMetadataJobDialog;
import com.archivas.clienttools.arcmover.gui.JobAlreadyOpenException;
import com.archivas.clienttools.arcmover.gui.JobDialog;
import com.archivas.clienttools.arcmover.gui.NoUserControlMessageDialog;
import com.archivas.clienttools.arcmover.gui.SavedJobsDialog;
import com.archivas.clienttools.arcmover.gui.SplashDialog;
import com.archivas.clienttools.arcmover.gui.namespacewizard.NamespaceProfileMgrDialog;
import com.archivas.clienttools.arcmover.gui.panels.ProfilePanel;
import com.archivas.clienttools.arcmover.gui.settings.PreferencesDialog;
import com.archivas.clienttools.arcmover.gui.ssl.SSLCertificateAllowDialog;
import com.archivas.clienttools.arcmover.gui.util.DialogDimensionProperties;
import com.archivas.clienttools.arcmover.gui.util.FixedWidthPanel;
import com.archivas.clienttools.arcmover.gui.util.GUIHelper;
import com.archivas.clienttools.arcmover.gui.util.SelfDestructiveDialog;
import com.archivas.clienttools.arcutils.api.jobs.CopyJob;
import com.archivas.clienttools.arcutils.api.jobs.DeleteJob;
import com.archivas.clienttools.arcutils.api.jobs.JobSpec;
import com.archivas.clienttools.arcutils.api.jobs.ManagedJob;
import com.archivas.clienttools.arcutils.api.jobs.SetMetadataJob;
import com.archivas.clienttools.arcutils.config.ConfigurationException;
import com.archivas.clienttools.arcutils.config.ConfigurationHelper;
import com.archivas.clienttools.arcutils.config.HCPMoverProperties;
import com.archivas.clienttools.arcutils.impl.adapter.StorageAdapterException;
import com.archivas.clienttools.arcutils.model.ArcCopyFile;
import com.archivas.clienttools.arcutils.model.ArcMoverDirectory;
import com.archivas.clienttools.arcutils.model.ArcMoverFile;
import com.archivas.clienttools.arcutils.model.LoadSchedule;
import com.archivas.clienttools.arcutils.model.Owner;
import com.archivas.clienttools.arcutils.model.Retention;
import com.archivas.clienttools.arcutils.profile.AbstractProfileBase;
import com.archivas.clienttools.arcutils.profile.FileSystemProfile;
import com.archivas.clienttools.arcutils.profile.HCAPProfile;
import com.archivas.clienttools.arcutils.profile.ProfileManager;
import com.archivas.clienttools.arcutils.utils.FileListParser;
import com.archivas.clienttools.arcutils.utils.FileUtil;
import com.archivas.clienttools.arcutils.utils.UidGidUtil;
import com.archivas.clienttools.arcutils.utils.database.DBUtils;
import com.archivas.clienttools.arcutils.utils.database.DatabaseException;
import com.archivas.clienttools.arcutils.utils.database.DatabaseResourceManager;
import com.archivas.clienttools.arcutils.utils.database.NonFatalDatabaseException;
import com.archivas.clienttools.arcutils.utils.net.SSLCertChain;
import com.archivas.clienttools.arcutils.utils.net.SSLCertificateCallback;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticTheme;
import com.jgoodies.looks.plastic.PlasticXPLookAndFeel;
import com.jgoodies.looks.plastic.theme.ExperienceBlue;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class HCPDataMigrator
extends JFrame {
    private static final String CLASS_FULL_NAME = HCPDataMigrator.class.getName();
    private static final Logger LOG = Logger.getLogger(CLASS_FULL_NAME);
    public static final String NEWLINE = System.getProperty("line.separator");
    public static final String PRODUCT_NAME = "HCP Data Migrator";
    private static final String LEFT_PROFILE_NAME = "hcpdm.profile.left.name";
    private static final String RIGHT_PROFILE_NAME = "hcpdm.profile.right.name";
    private static final String FILE_CHOOSER_LOOK_IN_LABEL_TEXT_PROPERTY = "FileChooser.lookInLabelText";
    private static final String FILE_CHOOSER_FILE_NAME_LABEL_TEXT_PROPERTY = "FileChooser.fileNameLabelText";
    private static final String FILE_CHOOSER_FILES_OF_TYPE_LABEL_TEXT_PROPERTY = "FileChooser.filesOfTypeLabelText";
    public static final int COPYRIGHT_YEAR = 2013;
    SplashDialog splashDialog;
    public static ImageIcon appImageIcon;
    private DialogDimensionProperties dialogProperties = new DialogDimensionProperties(CLASS_FULL_NAME, 700, 550);
    public static Cursor waitCursor;
    public static Cursor normalCursor;
    private static HCPDataMigrator mainFrame;
    private ProfilePanel leftProfilePanel;
    private ProfilePanel rightProfilePanel;
    protected JButton putButton;
    protected JButton getButton;
    protected JMenuItem openMenuItem = null;
    protected JMenuItem deleteMenuItem = null;
    protected JMenuItem setMetadataMenuItem = null;
    protected JMenuItem renameMenuItem = null;
    protected JMenuItem propertiesMenuItem = null;
    private JMenuItem toolbarMenuItem = null;
    private JToolBar toolBar;
    private JComboBox fontChooserCB;
    private JComboBox fontSizeCB;
    private static final Integer[] FONT_SIZES;
    private List<JMenuItem> lockableMenuItems = null;

    public static HCPDataMigrator getInstance() {
        return mainFrame;
    }

    public HCPDataMigrator(SplashDialog splash) throws StorageAdapterException {
        mainFrame = this;
        LOG.fine("Initializing Splash Screen");
        this.initializeIcons();
        this.splashDialog = splash;
        this.setTitle(PRODUCT_NAME);
        LOG.fine("Initializing Application");
        LOG.fine("Initializing GUI");
        ProfileManager.initialize(new SSLCertificateCallback(){

            @Override
            public void validCertCallback(AbstractProfileBase profile, SSLCertChain certChain) {
                profile.setSSLCertChain(certChain);
                LOG.log(Level.FINE, "validCertCallback for profile " + profile + ": " + certChain);
            }

            @Override
            public SSLCertificateCallback.AllowSSLCert exceptionCallback(AbstractProfileBase profile, SSLCertChain certChain, String warningString) {
                profile.setSSLCertChain(certChain);
                SSLCertificateAllowDialog sslCertificateAllowDialog = new SSLCertificateAllowDialog(profile);
                sslCertificateAllowDialog.setWarningText(warningString);
                sslCertificateAllowDialog.setTitle("Allow Security Exception");
                GUIHelper.centerDialog((Component)HCPDataMigrator.getInstance(), sslCertificateAllowDialog);
                sslCertificateAllowDialog.setVisible(true);
                return sslCertificateAllowDialog.getAllowCert();
            }
        });
        this.layoutGuiComponents();
        this.setDefaultCloseOperation(0);
        this.setSize(new Dimension(this.dialogProperties.width, this.dialogProperties.height));
        this.setLocationRelativeTo(null);
        this.initializeMenuBar();
        this.initializeWindowListeners();
        this.initializeButtons();
        GUIHelper.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                HCPDataMigrator.this.selectionFromPanel(null);
            }
        }, "clear selection during initialization");
        LOG.fine("Initialization complete");
        this.setMinimumSize(new Dimension(650, 500));
        this.setCursor(waitCursor);
        this.setVisible(true);
        this.splashDialog.cleanUp();
        this.setCursor(normalCursor);
        this.loadProfilePanels();
    }

    private void layoutGuiComponents() {
        this.getButton = new JButton();
        this.getButton.setIcon(new ImageIcon(this.getClass().getResource("/images/Rewind24.gif")));
        this.getButton.setText("");
        this.getButton.setToolTipText("Copy selected files from right to left.");
        this.putButton = new JButton();
        this.putButton.setIcon(new ImageIcon(this.getClass().getResource("/images/FastForward24.gif")));
        this.putButton.setText("");
        this.putButton.setToolTipText("Copy selected files from left to right.");
        FixedWidthPanel moveButtonsPanel = new FixedWidthPanel();
        moveButtonsPanel.setLayout(new BoxLayout(moveButtonsPanel, 1));
        moveButtonsPanel.add(Box.createVerticalGlue());
        moveButtonsPanel.add(this.putButton);
        moveButtonsPanel.add(Box.createVerticalStrut(25));
        moveButtonsPanel.add(this.getButton);
        moveButtonsPanel.add(Box.createVerticalGlue());
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.leftProfilePanel = new ProfilePanel();
        p.add(this.leftProfilePanel);
        p.add(Box.createHorizontalStrut(25));
        p.add(moveButtonsPanel);
        p.add(Box.createHorizontalStrut(25));
        this.rightProfilePanel = new ProfilePanel();
        p.add(this.rightProfilePanel);
        this.initializeToolBar();
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)this.toolBar, "North");
        mainPanel.add((Component)p, "Center");
        this.getContentPane().add(mainPanel);
    }

    private void initializeToolBar() {
        GraphicsEnvironment e = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] allFonts = e.getAvailableFontFamilyNames();
        this.fontChooserCB = new JComboBox<String>(allFonts);
        this.fontSizeCB = new JComboBox<Integer>(FONT_SIZES);
        ActionListener l = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HCPDataMigrator.this.setFont();
            }
        };
        this.fontChooserCB.addActionListener(l);
        this.fontSizeCB.addActionListener(l);
        this.toolBar = new JToolBar("HCP Data Migrator File List Font");
        this.toolBar.add(new JLabel("Font:"));
        this.toolBar.addSeparator();
        this.toolBar.add(this.fontChooserCB);
        this.fontChooserCB.setMaximumSize(this.fontChooserCB.getPreferredSize());
        this.toolBar.addSeparator();
        this.toolBar.add(this.fontSizeCB);
        this.fontSizeCB.setMaximumSize(this.fontSizeCB.getPreferredSize());
        this.toolBar.addSeparator();
        this.toolBar.setVisible(HCPMoverProperties.TOOLBAR_VISIBLE.getAsBoolean());
        Font initialFont = this.leftProfilePanel.getFileFont();
        try {
            String fontFamily = HCPMoverProperties.FONT_FAMILY.get();
            int fontSize = HCPMoverProperties.FONT_SIZE.getAsInt();
            fontSize = Math.max(fontSize, 8);
            fontSize = Math.min(fontSize, 14);
            initialFont = new Font(fontFamily, 0, fontSize);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.fontChooserCB.setSelectedItem(initialFont.getFamily());
        this.fontSizeCB.setSelectedItem(initialFont.getSize());
        this.setFont();
    }

    private void setFont() {
        String newFontName = (String)this.fontChooserCB.getSelectedItem();
        Integer newFontSize = (Integer)this.fontSizeCB.getSelectedItem();
        if (newFontName != null && newFontSize != null) {
            Font fileFont = new Font(newFontName, 0, newFontSize);
            HCPMoverProperties.FONT_FAMILY.set(fileFont.getFamily());
            HCPMoverProperties.FONT_SIZE.set(fileFont.getSize());
            this.leftProfilePanel.setFileFont(fileFont);
            this.rightProfilePanel.setFileFont(fileFont);
            JobDialog.setFileFont(fileFont);
        }
    }

    private void initializeIcons() {
        URL appImageIconURL = HCPDataMigrator.class.getResource("/images/DataMigratorIcon16x16.png");
        appImageIcon = new ImageIcon(appImageIconURL);
        this.setIconImage(appImageIcon.getImage());
    }

    private void initializeButtons() {
        this.putButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    HCPDataMigrator.this.copyLeftToRight();
                }
                catch (Exception ex) {
                    String msg = DBUtils.getErrorMessage("An error occurred copying files", ex);
                    GUIHelper.showMessageDialog(HCPDataMigrator.this, msg, "Error Copying Files", 0);
                    LOG.log(Level.WARNING, msg, ex);
                }
            }
        });
        this.getButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    HCPDataMigrator.this.copyRightToLeft();
                }
                catch (Exception ex) {
                    String msg = DBUtils.getErrorMessage("An error occurred copying files", ex);
                    GUIHelper.showMessageDialog(HCPDataMigrator.this, msg, "Error Copying Files", 0);
                    LOG.log(Level.WARNING, msg, ex);
                }
            }
        });
    }

    private void initializeMenuBar() throws StorageAdapterException {
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("File");
        menu.setMnemonic(70);
        menu.getAccessibleContext().setAccessibleDescription("File menu");
        menuBar.add(menu);
        this.lockableMenuItems = new ArrayList<JMenuItem>();
        JMenuItem menuItem = new JMenuItem("Saved Jobs", 83);
        menuItem.getAccessibleContext().setAccessibleDescription("Manage saved jobs");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    HCPDataMigrator.this.savedJobsMenuItemAction();
                }
                catch (Exception ex) {
                    String errMsg = DBUtils.getErrorMessage("An error occurred getting the list of saved jobs", ex);
                    LOG.log(Level.SEVERE, errMsg, ex);
                    GUIHelper.showMessageDialog(HCPDataMigrator.this, errMsg, "Error Reading Jobs", 0);
                }
            }
        });
        menu.add(menuItem);
        this.lockableMenuItems.add(menuItem);
        menuItem = new JMenuItem("Import Copy Job from File", 67);
        menuItem.getAccessibleContext().setAccessibleDescription("Load a Copy Job File");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HCPDataMigrator.this.loadCopyJobMenuItemAction();
            }
        });
        menu.add(menuItem);
        this.lockableMenuItems.add(menuItem);
        menuItem = new JMenuItem("Import Delete Job from File", 73);
        menuItem.getAccessibleContext().setAccessibleDescription("Load a Delete Job File");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HCPDataMigrator.this.loadDeleteJobMenuItemAction();
            }
        });
        menu.add(menuItem);
        this.lockableMenuItems.add(menuItem);
        menuItem = new JMenuItem("Import Metadata Job from File", 77);
        menuItem.getAccessibleContext().setAccessibleDescription("Load a Metadata Job File");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HCPDataMigrator.this.loadMetadataJobMenuItemAction();
            }
        });
        menu.add(menuItem);
        this.lockableMenuItems.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Namespace Profile Manager", 78);
        menuItem.getAccessibleContext().setAccessibleDescription("Open the Namespace Profile Manager");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HCPDataMigrator.this.loadProfileManagerMenuItemAction();
            }
        });
        menu.add(menuItem);
        this.lockableMenuItems.add(menuItem);
        menu.addSeparator();
        this.openMenuItem = new JMenuItem("Open", 79);
        this.openMenuItem.setEnabled(false);
        this.openMenuItem.getAccessibleContext().setAccessibleDescription("Open Object");
        this.openMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HCPDataMigrator.this.openObjectAction();
            }
        });
        menu.add(this.openMenuItem);
        this.deleteMenuItem = new JMenuItem("Delete", 68);
        this.deleteMenuItem.setEnabled(false);
        this.deleteMenuItem.getAccessibleContext().setAccessibleDescription("Delete Object");
        this.deleteMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HCPDataMigrator.this.deleteObjectAction();
            }
        });
        menu.add(this.deleteMenuItem);
        this.setMetadataMenuItem = new JMenuItem("Set Metadata");
        this.setMetadataMenuItem.setEnabled(false);
        this.setMetadataMenuItem.getAccessibleContext().setAccessibleDescription("Set Metadata");
        this.setMetadataMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HCPDataMigrator.this.setMetadataObjectAction();
            }
        });
        menu.add(this.setMetadataMenuItem);
        this.renameMenuItem = new JMenuItem("Rename", 82);
        this.renameMenuItem.setEnabled(false);
        this.renameMenuItem.getAccessibleContext().setAccessibleDescription("Rename Object");
        this.renameMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HCPDataMigrator.this.renameObjectAction();
            }
        });
        menu.add(this.renameMenuItem);
        this.propertiesMenuItem = new JMenuItem("Properties", 80);
        this.propertiesMenuItem.setMnemonic(80);
        this.propertiesMenuItem.setEnabled(false);
        this.propertiesMenuItem.getAccessibleContext().setAccessibleDescription("Object Properties");
        this.propertiesMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HCPDataMigrator.this.objectPropertiesAction();
            }
        });
        menu.add(this.propertiesMenuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Exit", 88);
        menuItem.setMnemonic(88);
        menuItem.getAccessibleContext().setAccessibleDescription("Exit this application");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HCPDataMigrator.this.quit();
            }
        });
        menu.add(menuItem);
        menu = new JMenu("Edit");
        menu.setMnemonic(69);
        menu.getAccessibleContext().setAccessibleDescription("Edit menu");
        menuBar.add(menu);
        menuItem = new JMenuItem("Preferences", 80);
        menuItem.getAccessibleContext().setAccessibleDescription("Application preferences");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HCPDataMigrator.this.preferencesMenuItemAction();
            }
        });
        menu.add(menuItem);
        menu = new JMenu("View");
        menu.setMnemonic(86);
        menu.getAccessibleContext().setAccessibleDescription("View menu");
        menuBar.add(menu);
        menuItem = new JMenuItem("Refresh");
        menuItem.setMnemonic(82);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(116, 0));
        menuItem.getAccessibleContext().setAccessibleDescription("Refresh view");
        menuItem.setIcon(GUIHelper.REFRESH_ICON);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HCPDataMigrator.this.refreshPanels();
                JobDialog.showJob();
            }
        });
        menu.add(menuItem);
        this.toolbarMenuItem = new JCheckBoxMenuItem("Font Toolbar");
        this.toolbarMenuItem.getAccessibleContext().setAccessibleDescription("Display or Hide the Font Toolbar");
        this.toolbarMenuItem.setMnemonic(84);
        this.toolbarMenuItem.setSelected(HCPMoverProperties.TOOLBAR_VISIBLE.getAsBoolean());
        this.toolbarMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HCPDataMigrator.this.toolBar.setVisible(HCPDataMigrator.this.toolbarMenuItem.isSelected());
                HCPMoverProperties.TOOLBAR_VISIBLE.set(HCPDataMigrator.this.toolbarMenuItem.isSelected());
            }
        });
        menu.add(this.toolbarMenuItem);
        menu = new JMenu("Help");
        menu.setMnemonic(72);
        menu.getAccessibleContext().setAccessibleDescription("Help menu");
        menuBar.add(menu);
        menuItem = new JMenuItem("About", 65);
        menuItem.getAccessibleContext().setAccessibleDescription("About this application");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HCPDataMigrator.this.aboutMenuItemAction();
            }
        });
        menu.add(menuItem);
        this.setJMenuBar(menuBar);
    }

    private void quit() {
        if (JobDialog.isOpen()) {
            LOG.log(Level.INFO, "Trying to close with open Job Dialog.");
            this.showMigrator(true);
            JOptionPane.showMessageDialog(this, "The current job must be closed before closing the application.", "Error Closing Application", 0);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JobDialog.showJob();
                }
            });
        } else {
            Dimension dimension = this.getSize();
            this.dialogProperties.width = dimension.width;
            this.dialogProperties.height = dimension.height;
            this.dialogProperties.persist();
            HCPMoverProperties.persist();
            try {
                ProfileManager.saveProfiles();
            }
            catch (ConfigurationException f) {
                LOG.log(Level.WARNING, "Failed to save profiles on exit.", f);
            }
            this.shutdown();
        }
    }

    private void initializeWindowListeners() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                HCPDataMigrator.this.quit();
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
                HCPDataMigrator.this.toFront();
                HCPDataMigrator.this.requestFocus();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                if (HCPDataMigrator.this.leftProfilePanel != null) {
                    HCPDataMigrator.this.leftProfilePanel.resizeFileList();
                }
                if (HCPDataMigrator.this.rightProfilePanel != null) {
                    HCPDataMigrator.this.rightProfilePanel.resizeFileList();
                }
            }
        });
        PropertyChangeListener listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (!SwingUtilities.isEventDispatchThread()) {
                    String errMsg = "propertyChange is not on the EDT but it should be";
                    IllegalStateException ex = new IllegalStateException(errMsg);
                    LOG.log(Level.SEVERE, errMsg, ex);
                    throw ex;
                }
                HCPDataMigrator.this.updateLockable();
            }
        };
        this.leftProfilePanel.addPropertyChangeListener(ProfilePanel.LOCK_PROPERTY, listener);
        this.rightProfilePanel.addPropertyChangeListener(ProfilePanel.LOCK_PROPERTY, listener);
    }

    public void updateLockable() {
        this.updateButtons();
        this.updateFileMenu();
    }

    public void refreshProfilePanel(AbstractProfileBase profile) {
        try {
            this.setCursor(waitCursor);
            if (this.leftProfilePanel.getSelectedProfile() == profile) {
                this.leftProfilePanel.refreshPathAndFileList();
            }
            if (this.rightProfilePanel.getSelectedProfile() == profile) {
                this.rightProfilePanel.refreshPathAndFileList();
            }
        }
        finally {
            this.setCursor(normalCursor);
        }
    }

    public void refreshProfiles() {
        try {
            this.setCursor(waitCursor);
            this.leftProfilePanel.refreshProfiles();
            this.rightProfilePanel.refreshProfiles();
        }
        finally {
            this.setCursor(normalCursor);
            this.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProfilePanels() {
        try {
            this.setCursor(waitCursor);
            AbstractProfileBase profile = null;
            String profileName = ConfigurationHelper.getStringProperty(LEFT_PROFILE_NAME, null);
            if (profileName != null && ProfileManager.doesProfileNameExist(profileName)) {
                profile = ProfileManager.getProfileByName(profileName);
            }
            if (profile == null) {
                profile = FileSystemProfile.LOCAL_FILESYSTEM_PROFILE;
            }
            final AbstractProfileBase leftProfile = profile;
            GUIHelper.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    HCPDataMigrator.this.leftProfilePanel.setSelectedProfile(leftProfile);
                }
            }, "set left profile");
            profile = null;
            profileName = ConfigurationHelper.getStringProperty(RIGHT_PROFILE_NAME, null);
            if (profileName != null && ProfileManager.doesProfileNameExist(profileName)) {
                profile = ProfileManager.getProfileByName(profileName);
            }
            if (profile == null) {
                profile = FileSystemProfile.LOCAL_FILESYSTEM_PROFILE;
            }
            final AbstractProfileBase rightProfile = profile;
            GUIHelper.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    HCPDataMigrator.this.rightProfilePanel.setSelectedProfile(rightProfile);
                }
            }, "set right profile");
        }
        finally {
            this.setCursor(normalCursor);
            this.repaint();
        }
    }

    public void loadCopyJobMenuItemAction() {
        this.startImportJob(new ImportCopyJobDialog());
    }

    public void loadDeleteJobMenuItemAction() {
        this.startImportJob(new ImportDeleteJobDialog());
    }

    public void loadMetadataJobMenuItemAction() {
        this.startImportJob(new ImportMetadataJobDialog());
    }

    public void startImportJob(ImportJobDialog importDialog) {
        importDialog.setVisible(true);
        if (importDialog.okClicked()) {
            String msg;
            ManagedJob job;
            String file = importDialog.getImportFilePath();
            AbstractProfileBase sourceProfile = importDialog.getSourceProfile();
            String sourcePath = sourceProfile.encode(importDialog.getSourcePath());
            AbstractProfileBase targetProfile = null;
            String targetPath = "";
            ManagedJob.Type jobType = importDialog.getJobType();
            if (jobType.hasTarget()) {
                targetProfile = importDialog.getTargetProfile();
                targetPath = targetProfile.encode(importDialog.getTargetPath());
            }
            this.getGlassPane().setCursor(waitCursor);
            this.getGlassPane().setVisible(true);
            File inputFile = new File(file);
            switch (jobType) {
                case DELETE: {
                    job = new DeleteJob(sourceProfile, inputFile);
                    break;
                }
                case SET_METADATA: {
                    job = new SetMetadataJob(sourceProfile, inputFile);
                    break;
                }
                case COPY: {
                    job = new CopyJob(sourceProfile, targetProfile, inputFile);
                    job.setTargetPath(targetPath);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(jobType.toString());
                }
            }
            job.setSourcePath(sourcePath);
            LoadSchedule schedule = LoadSchedule.getDefaultLoadSchedule();
            job.setLoadSchedule(schedule);
            try {
                FileListParser.validateFile(inputFile, sourceProfile, sourcePath, targetPath);
            }
            catch (Exception e) {
                msg = DBUtils.getErrorMessage("An error occurred parsing file " + file, e);
                LOG.log(Level.WARNING, msg, e);
                GUIHelper.showMessageDialog(this, msg, "Error Reading Input File", 0);
                job = null;
            }
            this.getGlassPane().setCursor(null);
            this.getGlassPane().setVisible(false);
            try {
                if (job != null) {
                    JobDialog.openNewJob(job);
                }
            }
            catch (Exception e) {
                msg = DBUtils.getErrorMessage("An error occurred loading a new job", e);
                LOG.log(Level.WARNING, msg, e);
                GUIHelper.showMessageDialog(this, msg, "Error Loading Job", 0);
            }
            HCPMoverProperties.IMPORT_JOB_LAST_DIRECTORY.set(file);
        }
    }

    private void savedJobsMenuItemAction() throws DatabaseException {
        SavedJobsDialog.openSavedJobsDialog();
    }

    private void loadProfileManagerMenuItemAction() {
        new NamespaceProfileMgrDialog().setVisible(true);
    }

    private void aboutMenuItemAction() {
        new AboutDialog((Window)this, "3.0.14.12345");
    }

    private void preferencesMenuItemAction() {
        PreferencesDialog d = new PreferencesDialog();
        d.setLocationRelativeTo(this);
        d.setVisible(true);
    }

    private JobSpec getCurrentJob(ProfilePanel sourcePanel, ProfilePanel targetPanel) throws DatabaseException {
        AbstractProfileBase sourceProfile = sourcePanel.getSelectedProfile();
        AbstractProfileBase targetProfile = targetPanel.getSelectedProfile();
        ArcMoverFile[] selectedFiles = sourcePanel.getSelectedFiles();
        ArrayList<ArcCopyFile> fileNameList = new ArrayList<ArcCopyFile>();
        String targetPath = targetPanel.getCurrentDirectory().getPath();
        for (ArcMoverFile nextFile : selectedFiles) {
            String targetFilename = nextFile.getFileName();
            if (sourceProfile.usesEncodedPaths() && !targetProfile.usesEncodedPaths()) {
                targetFilename = sourceProfile.decode(targetFilename);
            } else if (!sourceProfile.usesEncodedPaths() && targetProfile.usesEncodedPaths()) {
                targetFilename = targetProfile.encode(targetFilename);
            }
            ArcCopyFile nextCopyFile = new ArcCopyFile(nextFile, targetPanel.getSelectedProfile(), FileUtil.resolvePath(targetPath, targetFilename, targetPanel.getSelectedProfile().getPathSeparator()));
            fileNameList.add(nextCopyFile);
        }
        CopyJob job = new CopyJob(sourcePanel.getSelectedProfile(), targetPanel.getSelectedProfile(), (List<ArcCopyFile>)fileNameList);
        job.setSourcePath(sourcePanel.getCurrentDirectory().getPath());
        job.setTargetPath(targetPath);
        return job;
    }

    public CopyJob configureJob(CopyJob job) throws DatabaseException {
        if (!(job.getSourceProfile() instanceof HCAPProfile)) {
            if (HCPMoverProperties.PERMISSIONS_UID.get().length() > 0) {
                try {
                    job.setUid(UidGidUtil.validateId(HCPMoverProperties.PERMISSIONS_UID.get()));
                }
                catch (NumberFormatException exception) {
                    LOG.warning("Ignoring invalid UID value: " + HCPMoverProperties.PERMISSIONS_UID.get());
                }
            }
            if (HCPMoverProperties.PERMISSIONS_GID.get().length() > 0) {
                try {
                    job.setGid(UidGidUtil.validateId(HCPMoverProperties.PERMISSIONS_GID.get()));
                }
                catch (NumberFormatException exception) {
                    LOG.warning("Ignoring invalid GID value: " + HCPMoverProperties.PERMISSIONS_GID.get());
                }
            }
            if (HCPMoverProperties.PERMISSIONS_FILE_MODE.get().length() > 0) {
                try {
                    if (HCPMoverProperties.PERMISSIONS_FILE_MODE.getAsInt() >= 0) {
                        job.setFilePermissions(HCPMoverProperties.PERMISSIONS_FILE_MODE.getAsInt());
                    }
                }
                catch (NumberFormatException exception) {
                    LOG.warning("Ignoring invalid file mode value: " + HCPMoverProperties.PERMISSIONS_FILE_MODE.get());
                }
            }
            if (HCPMoverProperties.PERMISSIONS_DIR_MODE.get().length() > 0) {
                try {
                    if (HCPMoverProperties.PERMISSIONS_DIR_MODE.getAsInt() >= 0) {
                        job.setDirPermissions(HCPMoverProperties.PERMISSIONS_DIR_MODE.getAsInt());
                    }
                }
                catch (NumberFormatException exception) {
                    LOG.warning("Ignoring invalid dir mode value: " + HCPMoverProperties.PERMISSIONS_DIR_MODE.get());
                }
            }
            job.setIndex(HCPMoverProperties.INDEX_MODE.getAsTriState().toBoolean());
            job.setShred(HCPMoverProperties.SHRED_MODE.getAsTriState().toBoolean());
            job.setRetentionHold(HCPMoverProperties.RETENTION_HOLD_MODE.getAsTriState().toBoolean());
            job.setRetention(Retention.fromProperties(Retention.Type.fromUIName(HCPMoverProperties.RETENTION_TYPE.get()), HCPMoverProperties.RETENTION_USER_INPUT.get(), HCPMoverProperties.RETENTION_HCAP_VALUE.get()));
            if (HCPMoverProperties.OWNER.get().length() > 0) {
                job.setOwner(Owner.createFromStringRepresentation(HCPMoverProperties.OWNER.get()));
            }
        }
        return job;
    }

    private void copyLeftToRight() throws DatabaseException {
        this.copyFiles(this.leftProfilePanel, this.rightProfilePanel);
    }

    private void copyRightToLeft() throws DatabaseException {
        this.copyFiles(this.rightProfilePanel, this.leftProfilePanel);
    }

    public void copyFiles(AbstractProfileBase sourceProfile, ProfilePanel targetPanel, List<ArcCopyFile> fileList) throws DatabaseException {
        CopyJob job = new CopyJob(sourceProfile, targetPanel.getSelectedProfile(), fileList);
        this.configureJob(job);
        this.copyFiles(job, fileList.toArray());
        targetPanel.refreshPathAndFileList();
    }

    public void copyFiles(ProfilePanel sourcePanel, ProfilePanel targetPanel) throws DatabaseException {
        CopyJob job = (CopyJob)this.getCurrentJob(sourcePanel, targetPanel);
        this.configureJob(job);
        this.copyFiles(job, sourcePanel.getSelectedFiles());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFiles(CopyJob job, Object[] selectedObjectArray) {
        try {
            if (selectedObjectArray.length > 0) {
                JobDialog.openNewJob(job);
            }
        }
        catch (JobAlreadyOpenException jaoe) {
            JOptionPane.showMessageDialog(this, "Another job is already open.\nOnly one job may be open at a time.", "Error", 0);
        }
        catch (Exception e1) {
            String msg = DBUtils.getErrorMessage("An unexpected error occurred", e1);
            LOG.log(Level.WARNING, msg, e1);
            GUIHelper.showMessageDialog(this, msg, "Error", 0);
        }
        finally {
            this.setCursor(normalCursor);
        }
    }

    public static void main(String[] args) {
        try {
            for (Map.Entry<Object, Object> prop : System.getProperties().entrySet()) {
                LOG.log(Level.INFO, "System Property: " + prop.getKey() + "=" + prop.getValue());
            }
            PlasticXPLookAndFeel.setPlasticTheme((PlasticTheme)new ExperienceBlue());
            PlasticLookAndFeel.setPlasticTheme((PlasticTheme)new ExperienceBlue());
            UIManager.setLookAndFeel((LookAndFeel)new PlasticXPLookAndFeel());
            UIManager.put(FILE_CHOOSER_LOOK_IN_LABEL_TEXT_PROPERTY, UIManager.getString(FILE_CHOOSER_LOOK_IN_LABEL_TEXT_PROPERTY).replace(":", ""));
            UIManager.put(FILE_CHOOSER_FILE_NAME_LABEL_TEXT_PROPERTY, UIManager.getString(FILE_CHOOSER_FILE_NAME_LABEL_TEXT_PROPERTY).replace(":", ""));
            UIManager.put(FILE_CHOOSER_FILES_OF_TYPE_LABEL_TEXT_PROPERTY, UIManager.getString(FILE_CHOOSER_FILES_OF_TYPE_LABEL_TEXT_PROPERTY).replace(":", ""));
        }
        catch (Exception e) {
            LOG.warning("" + e);
            throw new RuntimeException(e);
        }
        SplashDialog splash = new SplashDialog();
        try {
            HCPDataMigrator.validateLaunchOK(splash);
            HCPDataMigrator.upgrade(splash);
            new HCPDataMigrator(splash);
        }
        catch (StorageAdapterException e) {
            LOG.warning("" + e);
            throw new RuntimeException(e);
        }
    }

    private static void upgrade(final SplashDialog splashDialog) {
        String failureDialogTitle = "HCP Data Migrator Fatal Error";
        try {
            int compare = DatabaseResourceManager.compareCurrentVersionToDbVersion();
            if (compare != 0) {
                if (compare < 0) {
                    String msg = String.format("The %1$s database has already been upgraded to a more recent version than is supported by this version of %1$s.  Please use a more recent version of %1$s.", PRODUCT_NAME);
                    LOG.log(Level.SEVERE, msg);
                    GUIHelper.showMessageDialog(splashDialog, msg, "HCP Data Migrator Fatal Error", 0);
                    System.exit(-1);
                } else {
                    splashDialog.setAlwaysOnTop(false);
                    final NoUserControlMessageDialog pleaseWaitDialog = new NoUserControlMessageDialog((Component)splashDialog, String.format("Upgrading %s Database", PRODUCT_NAME), String.format("Upgrading the %s database, please wait.", PRODUCT_NAME));
                    pleaseWaitDialog.setAlwaysOnTop(true);
                    SwingWorker sw = new SwingWorker(){
                        private String finishMsg = String.format("Completed upgrading the %s database", "HCP Data Migrator");
                        private String finishTitle = String.format("%s Upgrade Complete", "HCP Data Migrator");
                        private boolean isError = false;
                        private int msgDisplayMs = 5000;

                        protected Object doInBackground() throws Exception {
                            try {
                                do {
                                    try {
                                        Thread.sleep(1000L);
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                } while (!pleaseWaitDialog.isVisible());
                                DatabaseResourceManager.upgradeDatabase();
                            }
                            catch (NonFatalDatabaseException e) {
                                this.finishMsg = DBUtils.getErrorMessage(String.format("A partial error occurred upgrading the %s database", HCPDataMigrator.PRODUCT_NAME), e);
                                this.finishMsg = this.finishMsg + "\n\nOne or more saved jobs may not be usable.";
                                this.msgDisplayMs = -1;
                                LOG.log(Level.WARNING, this.finishMsg, e);
                            }
                            catch (Exception e) {
                                this.finishMsg = DBUtils.getErrorMessage(String.format("A fatal error occurred upgrading the %s database", HCPDataMigrator.PRODUCT_NAME), e);
                                this.finishMsg = this.finishMsg + "\n\nDelete the database to use this version of HCP Data Migrator";
                                this.finishTitle = "HCP Data Migrator Fatal Error";
                                this.isError = true;
                                LOG.log(Level.SEVERE, this.finishMsg, e);
                            }
                            return null;
                        }

                        @Override
                        protected void done() {
                            if (this.isError) {
                                GUIHelper.showMessageDialog(splashDialog, this.finishMsg, this.finishTitle, 0);
                                System.exit(-1);
                            } else {
                                GUIHelper.showMessageDialog(this.msgDisplayMs, pleaseWaitDialog, true, this.finishMsg, this.finishTitle, 1);
                                pleaseWaitDialog.setVisible(false);
                            }
                        }
                    };
                    sw.execute();
                    pleaseWaitDialog.setVisible(true);
                    splashDialog.setAlwaysOnTop(true);
                }
            }
        }
        catch (Exception e) {
            String msg = "A fatal upgrade error occurred: " + e.getMessage();
            LOG.log(Level.SEVERE, msg, e);
            GUIHelper.showMessageDialog(splashDialog, msg, "HCP Data Migrator Fatal Error", 0);
            System.exit(-1);
        }
    }

    private static void validateLaunchOK(SplashDialog splashDialog) {
        String failureDialogTitle = "HCP Data Migrator Fatal Error";
        try {
            ConfigurationHelper.validateLaunchOK(false);
        }
        catch (Exception e) {
            String msg = "A fatal error occurred: " + e.getMessage();
            LOG.log(Level.SEVERE, msg, e);
            GUIHelper.showMessageDialog(splashDialog, msg, "HCP Data Migrator Fatal Error", 0);
            System.exit(-1);
        }
    }

    private void shutdown() {
        DatabaseResourceManager.shutdownDB();
        System.exit(0);
    }

    protected void openObjectAction() {
        ProfilePanel panel = this.getActivePanel();
        if (panel != null && this.doesFilePanelHaveSingleSelection(panel)) {
            panel.openSelectedRow();
        }
    }

    protected void deleteObjectAction() {
        ProfilePanel panel = this.getActivePanel();
        if (panel != null && this.doesFilePanelHaveSelection(panel)) {
            panel.deleteSelectedRows();
        }
    }

    protected void setMetadataObjectAction() {
        ProfilePanel panel = this.getActivePanel();
        if (panel != null && this.doesFilePanelHaveSelection(panel)) {
            panel.setMetadataOnSelectedRows();
        }
    }

    protected void renameObjectAction() {
        ProfilePanel panel = this.getActivePanel();
        if (panel != null && this.doesFilePanelHaveSingleSelection(panel)) {
            panel.renameSelectedRow();
        }
    }

    protected void objectPropertiesAction() {
        ProfilePanel panel = this.getActivePanel();
        if (panel != null && this.doesFilePanelHaveSingleSelection(panel)) {
            panel.displaySelectedObjectProperties();
        }
    }

    public void selectionFromPanel(ProfilePanel panelWithSelection) {
        if (this.rightProfilePanel != panelWithSelection) {
            this.rightProfilePanel.clearSelection();
        }
        if (this.leftProfilePanel != panelWithSelection) {
            this.leftProfilePanel.clearSelection();
        }
        this.updateLockable();
    }

    private void updateButtons() {
        boolean locked = this.leftProfilePanel.isLocked() || this.rightProfilePanel.isLocked() || JobDialog.isOpen();
        boolean leftSelection = this.leftProfilePanel.getNonDeletedSelectedFileCount() > 0;
        this.putButton.setEnabled(!locked && leftSelection && !this.rightProfilePanel.isSelectionReadOnly());
        boolean rightSelection = this.rightProfilePanel.getNonDeletedSelectedFileCount() > 0;
        this.getButton.setEnabled(!locked && rightSelection && !this.leftProfilePanel.isSelectionReadOnly());
    }

    public void saveSelectedProfile(ProfilePanel panel, String profileName) {
        try {
            if (panel == this.leftProfilePanel) {
                ConfigurationHelper.setUserProperty(LEFT_PROFILE_NAME, profileName);
            } else if (panel == this.rightProfilePanel) {
                ConfigurationHelper.setUserProperty(RIGHT_PROFILE_NAME, profileName);
            }
        }
        catch (ConfigurationException e) {
            LOG.log(Level.WARNING, "Could not save selected profile", e);
        }
    }

    private void updateFileMenu() {
        if (!SwingUtilities.isEventDispatchThread()) {
            String errMsg = "updateFileMenu is not on the EDT but it should be";
            IllegalStateException ex = new IllegalStateException(errMsg);
            LOG.log(Level.SEVERE, errMsg, ex);
            throw ex;
        }
        ProfilePanel panel = this.getActivePanel();
        ArcMoverFile selectedFile = null;
        if (panel != null) {
            selectedFile = panel.getSelectedFile();
        }
        boolean single = this.doesFilePanelHaveSingleSelection(panel);
        this.setOpenMenuItemEnabled(panel, selectedFile, single);
        this.setDeleteMenuItemEnabled(panel, selectedFile, single);
        this.setSetMetadataMenuItemEnabled(panel, selectedFile, single);
        this.setRenameMenuItemEnabled(panel, selectedFile, single);
        this.setPropertiesMenuItemEnabled(panel, selectedFile, single);
        boolean locked = this.leftProfilePanel.isLocked() || this.rightProfilePanel.isLocked() || JobDialog.isOpen();
        for (JMenuItem item : this.lockableMenuItems) {
            item.setEnabled(!locked);
        }
    }

    private ProfilePanel getActivePanel() {
        ProfilePanel activePanel = null;
        if (this.leftProfilePanel.getSelectedRowCount() > 0) {
            activePanel = this.leftProfilePanel;
        } else if (this.rightProfilePanel.getSelectedRowCount() > 0) {
            activePanel = this.rightProfilePanel;
        }
        return activePanel;
    }

    protected void setOpenMenuItemEnabled(ProfilePanel panel, ArcMoverFile selectedFile, boolean single) {
        this.openMenuItem.setEnabled(panel != null && !panel.isLocked() && panel.supportsOpenAction(selectedFile, single));
    }

    protected void setDeleteMenuItemEnabled(ProfilePanel panel, ArcMoverFile selectedFile, boolean single) {
        this.deleteMenuItem.setEnabled(!JobDialog.isOpen() && panel != null && !panel.isLocked() && panel.supportsDeleteAction(selectedFile, single));
    }

    protected void setSetMetadataMenuItemEnabled(ProfilePanel panel, ArcMoverFile selectedFile, boolean single) {
        this.setMetadataMenuItem.setEnabled(!JobDialog.isOpen() && panel != null && !panel.isLocked() && panel.supportsSetMetadataAction(selectedFile, single));
    }

    protected void setRenameMenuItemEnabled(ProfilePanel panel, ArcMoverFile selectedFile, boolean single) {
        this.renameMenuItem.setEnabled(!JobDialog.isOpen() && panel != null && !panel.isLocked() && panel.supportsRenameAction(selectedFile, single));
    }

    protected void setPropertiesMenuItemEnabled(ProfilePanel panel, ArcMoverFile selectedFile, boolean single) {
        this.propertiesMenuItem.setEnabled(panel != null && !panel.isLocked() && panel.supportsPropertiesAction(selectedFile, single));
    }

    protected boolean doesFilePanelHaveSelection(ProfilePanel profilePanel) {
        return profilePanel != null && profilePanel.getSelectedRowCount() > 0;
    }

    private boolean doesFilePanelHaveSingleSelection(ProfilePanel profilePanel) {
        return profilePanel != null && profilePanel.getSelectedRowCount() == 1;
    }

    public static void showMigratorInstance() {
        HCPDataMigrator.getInstance().showMigrator();
    }

    public void showMigrator() {
        this.showMigrator(true);
    }

    private void showMigrator(boolean invoke) {
        this.updateLockable();
        this.setVisible(true);
        if (this.getState() == 1) {
            this.setState(0);
        }
        this.toFront();
        this.requestFocus();
        HCPDataMigrator migrator = this;
        if (invoke) {
            SelfDestructiveDialog.invoke(migrator);
        }
    }

    public void refreshPanels() {
        if (!this.leftProfilePanel.isLocked()) {
            this.leftProfilePanel.refreshPathAndFileList();
        }
        if (!this.rightProfilePanel.isLocked()) {
            this.rightProfilePanel.refreshPathAndFileList();
        }
    }

    public void refreshMatchingPanels(AbstractProfileBase profile, ArcMoverDirectory directory) {
        ArcMoverDirectory rightDir;
        String rightDirPath;
        ArcMoverDirectory leftDir;
        String leftDirPath;
        String dirPath = directory.isVersionList() ? directory.getParent().getPath() : directory.getPath();
        if (!this.leftProfilePanel.isLocked() && profile.equals(this.leftProfilePanel.getSelectedProfile()) && dirPath.equals(leftDirPath = (leftDir = this.leftProfilePanel.getCurrentDirectory()).isVersionList() ? leftDir.getParent().getPath() : leftDir.getPath())) {
            this.leftProfilePanel.refreshPathAndFileList();
        }
        if (!this.rightProfilePanel.isLocked() && profile.equals(this.rightProfilePanel.getSelectedProfile()) && dirPath.equals(rightDirPath = (rightDir = this.rightProfilePanel.getCurrentDirectory()).isVersionList() ? rightDir.getParent().getPath() : rightDir.getPath())) {
            this.rightProfilePanel.refreshPathAndFileList();
        }
    }

    static {
        waitCursor = new Cursor(3);
        normalCursor = null;
        FONT_SIZES = new Integer[]{8, 9, 10, 11, 12, 14};
    }
}

