/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcmover.gui;

import com.archivas.clienttools.arcutils.config.ConfigurationException;
import com.archivas.clienttools.arcutils.config.ConfigurationHelper;
import com.archivas.clienttools.arcutils.profile.AbstractProfileBase;
import com.archivas.clienttools.arcutils.utils.net.UrlUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HistoryManager {
    public static final String PACKAGE_NAME = HistoryManager.class.getPackage().getName();
    public static final String CLASS_FULL_NAME = HistoryManager.class.getName();
    public static final String CLASS_NAME = CLASS_FULL_NAME.substring(PACKAGE_NAME.length() + 1);
    public static Logger LOG = Logger.getLogger(CLASS_FULL_NAME);
    public static final HistoryKey COUNT = new HistoryKey("hcpdm.history.count", "25");
    private static Properties modifiedProperties = new Properties();

    private static synchronized void persist() {
        try {
            ConfigurationHelper.setUserProperties(modifiedProperties);
        }
        catch (ConfigurationException e) {
            LOG.log(Level.WARNING, "Error writing profiles to user properties file.", e);
        }
    }

    public static String[] openHistory(AbstractProfileBase profile) {
        int id = profile.getId();
        ArrayList<String> history = new ArrayList<String>();
        for (int i = 0; i < COUNT.getAsInt(); ++i) {
            HistoryKey key = HistoryManager.openKey(id, i);
            String value = key.get();
            if ("".equals(value) || history.contains(value)) continue;
            history.add(value);
        }
        return history.toArray(new String[0]);
    }

    public static String[] getHistoryBeginsWith(AbstractProfileBase profile, String historyKey) {
        int id = profile.getId();
        ArrayList<String> history = new ArrayList<String>();
        history.add(historyKey);
        for (int i = 0; i < COUNT.getAsInt(); ++i) {
            HistoryKey key = HistoryManager.openKey(id, i);
            String value = key.get();
            if ("".equals(value) || history.contains(value) || !value.startsWith(historyKey)) continue;
            history.add(value);
        }
        return history.toArray(new String[0]);
    }

    public static String[] addToHistory(AbstractProfileBase profile, String historyKey) {
        ArrayList<String> history = new ArrayList<String>();
        history.add(historyKey);
        for (String string : Arrays.asList(HistoryManager.openHistory(profile))) {
            if (history.contains(string)) continue;
            history.add(string);
        }
        String[] historyStrings = history.toArray(new String[0]);
        HistoryManager.saveHistory(profile, historyStrings);
        return historyStrings;
    }

    public static String[] removeFromHistory(AbstractProfileBase profile, String historyKey) {
        ArrayList<String> history = new ArrayList<String>();
        for (String string : Arrays.asList(HistoryManager.openHistory(profile))) {
            if (history.contains(string)) continue;
            history.add(string);
        }
        history.remove(historyKey);
        String[] historyStrings = history.toArray(new String[0]);
        HistoryManager.saveHistory(profile, historyStrings);
        return historyStrings;
    }

    private static HistoryKey openKey(int id, int i) {
        return new HistoryKey(HistoryManager.getPropertyName(id, i), "");
    }

    public static void saveHistory(AbstractProfileBase profile, String[] history) {
        int id = profile.getId();
        for (int i = 0; i < history.length && i < COUNT.getAsInt(); ++i) {
            new HistoryKey(HistoryManager.getPropertyName(id, i), "").set(history[i]);
        }
        HistoryManager.persist();
    }

    public static void removeHistory(AbstractProfileBase profile) {
        HashSet<String> propsToRemove = new HashSet<String>();
        int id = profile.getId();
        for (int i = 0; i < COUNT.getAsInt(); ++i) {
            propsToRemove.add(HistoryManager.getPropertyName(id, i));
        }
        try {
            ConfigurationHelper.removeUserProperties(propsToRemove);
        }
        catch (ConfigurationException e) {
            LOG.log(Level.WARNING, "Error removing profile history from user properties file.", e);
        }
    }

    private static String getPropertyName(int id, int i) {
        return "hcpdm.profile." + id + ".history." + i;
    }

    public static class HistoryKey {
        private final String key;
        private final String defaultValue;
        private String value;

        protected HistoryKey(String key, String defaultValue) {
            this.key = key.endsWith("/") ? key.substring(0, key.length() - 1) : key;
            this.defaultValue = defaultValue;
        }

        public synchronized String get() {
            if (this.value == null) {
                this.value = ConfigurationHelper.getStringProperty(this.key, this.defaultValue);
            }
            return this.value;
        }

        public synchronized URL getAsURL() throws MalformedURLException {
            return UrlUtils.makeURL("", this.get());
        }

        public synchronized int getAsInt() {
            return Integer.parseInt(this.get());
        }

        public synchronized int getAsInt(int defaultValue) {
            int value = defaultValue;
            try {
                value = Integer.parseInt(this.get());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return value;
        }

        public synchronized boolean getAsBoolean() {
            return Boolean.valueOf(this.get());
        }

        public synchronized void set(String newValue) {
            this.value = newValue;
            modifiedProperties.setProperty(this.key, this.value);
        }

        public synchronized void set(int newValue) {
            this.set(Integer.toString(newValue));
        }

        public synchronized void set(boolean newValue) {
            this.set(newValue ? "True" : "False");
        }
    }
}

