/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcmover.gui;

import com.archivas.clienttools.arcmover.gui.HCPDataMigrator;
import com.archivas.clienttools.arcmover.gui.panels.FixedHeightPanel;
import com.archivas.clienttools.arcmover.gui.util.FixedWidthButton;
import com.archivas.clienttools.arcmover.gui.util.FixedWidthGroup;
import com.archivas.clienttools.arcmover.gui.util.GUIHelper;
import com.archivas.clienttools.arcutils.api.jobs.ManagedJob;
import com.archivas.clienttools.arcutils.config.HCPMoverProperties;
import com.archivas.clienttools.arcutils.profile.AbstractProfileBase;
import com.archivas.clienttools.arcutils.profile.FileSystemProfile;
import com.archivas.clienttools.arcutils.profile.ProfileManager;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;

public class ImportJobDialog
extends JDialog {
    private static final String SOURCE_PROFILE_LABEL = "Source Profile";
    private static final String TARGET_PROFILE_LABEL = "Destination Profile";
    private static final String SOURCE_PATH_LABEL = "Source Path";
    private static final String TARGET_PATH_LABEL = "Destination Path";
    private static final String FILE_CHOOSER_LABEL = "File to Import";
    private JComboBox sourceProfileSelectionCombo;
    private JComboBox targetProfileSelectionCombo;
    private JTextField sourcePathField;
    private JTextField targetPathField;
    private JFileChooser fileChooser;
    private JButton okButton = new FixedWidthButton("OK", 100);
    private JButton cancelButton = new FixedWidthButton("Cancel", 100);
    private ManagedJob.Type jobType;
    private boolean okClicked;

    protected ImportJobDialog(ManagedJob.Type jobType) {
        super(HCPDataMigrator.getInstance());
        this.jobType = jobType;
        this.setModal(true);
        this.setTitle("Import " + jobType.getUiName() + " Job from File");
        this.layoutGuiComponents(jobType.hasTarget());
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportJobDialog.this.onOk();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportJobDialog.this.setVisible(false);
            }
        });
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private void onOk() {
        if (this.sourceProfileSelectionCombo.getSelectedItem() == null) {
            this.displayError("Please select a source profile");
        } else if (this.jobType.hasTarget() && this.targetProfileSelectionCombo.getSelectedItem() == null) {
            this.displayError("Please select a destination profile");
        } else if (this.targetPathField != null && this.targetPathField.getText().equals("")) {
            this.displayError("Please enter a destination directory");
        } else if (this.fileChooser.getSelectedFile() == null) {
            this.displayError("Please choose an input file");
        } else {
            AbstractProfileBase profile = this.getSourceProfile();
            if (profile.getName().equals("Local File System") && profile.getPathSeparator().equals("\\") && this.sourcePathField.getText().equals("")) {
                this.displayError("Please enter a source path");
            } else {
                this.okClicked = true;
                this.setVisible(false);
            }
        }
    }

    private void displayError(String errMsg) {
        GUIHelper.showMessageDialog(this, errMsg, "Error", 0);
    }

    public ManagedJob.Type getJobType() {
        return this.jobType;
    }

    public boolean okClicked() {
        return this.okClicked;
    }

    public String getImportFilePath() {
        return this.fileChooser.getSelectedFile().getAbsolutePath();
    }

    public AbstractProfileBase getSourceProfile() {
        return (AbstractProfileBase)this.sourceProfileSelectionCombo.getSelectedItem();
    }

    public AbstractProfileBase getTargetProfile() {
        return (AbstractProfileBase)this.targetProfileSelectionCombo.getSelectedItem();
    }

    public String getSourcePath() {
        return this.sourcePathField.getText().trim();
    }

    public String getTargetPath() {
        return this.targetPathField.getText().trim();
    }

    private void layoutGuiComponents(boolean jobHasTarget) {
        Object[] allProfiles = this.getProfiles();
        this.sourceProfileSelectionCombo = new JComboBox<Object>(allProfiles);
        this.sourceProfileSelectionCombo.setToolTipText("Select a namespace profile");
        this.sourceProfileSelectionCombo.setPrototypeDisplayValue("#");
        this.sourcePathField = new JTextField();
        this.sourcePathField.setToolTipText("All files/directories in the selected file are relative to this directory");
        if (jobHasTarget) {
            this.targetProfileSelectionCombo = new JComboBox<Object>(allProfiles);
            this.targetProfileSelectionCombo.setToolTipText("Select a namespace profile");
            this.targetProfileSelectionCombo.setPrototypeDisplayValue("#");
            this.targetPathField = new JTextField();
            this.targetPathField.setToolTipText("All files/directories to be copied will be placed under this directory");
        }
        FixedWidthGroup labelGroup = new FixedWidthGroup();
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.setBorder(new EmptyBorder(12, 12, 12, 12));
        p.add(GUIHelper.createNameValuePairPanel(SOURCE_PROFILE_LABEL, (Component)this.sourceProfileSelectionCombo, labelGroup, false));
        p.add(Box.createVerticalStrut(5));
        p.add(GUIHelper.createNameValuePairPanel(SOURCE_PATH_LABEL, (Component)this.sourcePathField, labelGroup, false));
        if (jobHasTarget) {
            p.add(Box.createVerticalStrut(5));
            p.add(GUIHelper.createNameValuePairPanel(TARGET_PROFILE_LABEL, (Component)this.targetProfileSelectionCombo, labelGroup, false));
            p.add(Box.createVerticalStrut(5));
            p.add(GUIHelper.createNameValuePairPanel(TARGET_PATH_LABEL, (Component)this.targetPathField, labelGroup, false));
        }
        p.add(Box.createVerticalStrut(17));
        FixedHeightPanel fileChooserPanel = new FixedHeightPanel();
        fileChooserPanel.setBorder(new TitledBorder(FILE_CHOOSER_LABEL));
        String path = HCPMoverProperties.IMPORT_JOB_LAST_DIRECTORY.get();
        if ("".equals(path)) {
            this.fileChooser = new JFileChooser();
            this.fileChooser.setFileFilter(new DMFileFilter());
        } else {
            this.fileChooser = new JFileChooser(path);
            this.fileChooser.setFileFilter(new DMFileFilter());
        }
        this.fileChooser.setControlButtonsAreShown(false);
        fileChooserPanel.add(this.fileChooser);
        p.add(fileChooserPanel);
        p.add(Box.createVerticalStrut(25));
        p.add(Box.createVerticalGlue());
        FixedHeightPanel buttonPanel = new FixedHeightPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.okButton);
        buttonPanel.add(Box.createHorizontalStrut(12));
        buttonPanel.add(this.cancelButton);
        p.add(buttonPanel);
        this.getContentPane().add(p);
        this.fileChooser.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportJobDialog.this.dispose();
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
        p.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportJobDialog.this.dispose();
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
    }

    protected Object[] getProfiles() {
        List<AbstractProfileBase> profiles = ProfileManager.getProfiles();
        profiles.add(0, FileSystemProfile.LOCAL_FILESYSTEM_PROFILE);
        return profiles.toArray();
    }

    class DMFileFilter
    extends FileFilter {
        DMFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            return f.isDirectory() || f.getName().toLowerCase().endsWith(".txt");
        }

        @Override
        public String getDescription() {
            return ".txt files";
        }
    }
}

